/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.CSVImporterFormat;
import com.univocity.parsers.common.AbstractParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class RDFImporterFormat
extends CSVImporterFormat {
    private static final char[] STRING_CONTENT_SKIP = new char[]{'\'', '\'', '\"', '\"', '<', '>'};

    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        long skipEntries;
        AbstractParser csvParser = this.createCSVParser(settings, ",");
        long l = skipEntries = settings.edgesSkipEntries != null ? settings.edgesSkipEntries : 0L;
        if (settings.edgesSkipEntries == null) {
            skipEntries = 1L;
        }
        try (InputStreamReader inputFileReader = new InputStreamReader(parser.getInputStream(), DatabaseFactory.getDefaultCharset());){
            String[] row;
            csvParser.beginParsing((Reader)inputFileReader);
            if (!database.isTransactionActive()) {
                database.begin();
            }
            long line = 0L;
            while ((row = csvParser.parseNext()) != null) {
                context.parsed.incrementAndGet();
                if (skipEntries <= 0L || line >= skipEntries) {
                    String v1Id = this.getStringContent(row[0], STRING_CONTENT_SKIP);
                    String edgeLabel = this.getStringContent(row[1], STRING_CONTENT_SKIP);
                    String v2Id = this.getStringContent(row[2], STRING_CONTENT_SKIP);
                    database.newEdgeByKeys(settings.vertexTypeName, new String[]{settings.typeIdProperty}, new Object[]{v1Id}, settings.vertexTypeName, new String[]{settings.typeIdProperty}, new Object[]{v2Id}, true, settings.edgeTypeName, true, new Object[]{"label", edgeLabel});
                    context.createdEdges.incrementAndGet();
                    context.parsed.incrementAndGet();
                    if (context.parsed.get() % (long)settings.commitEvery == 0L) {
                        database.commit();
                        database.begin();
                    }
                }
                ++line;
            }
            database.commit();
        }
        catch (IOException e) {
            throw new ImportException("Error on importing CSV", e);
        }
    }

    @Override
    public String getFormat() {
        return "RDF";
    }
}

