/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.Constants;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.Index;
import com.arcadedb.index.lsm.LSMTreeIndexAbstract;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.utility.FileUtils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrientDBImporter {
    private final File file;
    private final Map<String, OrientDBClass> classes = new LinkedHashMap<String, OrientDBClass>();
    private final Map<String, Long> totalRecordByType = new HashMap<String, Long>();
    private final Set<String> excludeClasses = new HashSet<String>(Arrays.asList("OUser", "ORole", "OSchedule", "OSequence", "OTriggered", "OSecurityPolicy", "ORestricted", "OIdentity", "OFunction", "_studio"));
    private final Set<String> edgeClasses = new HashSet<String>();
    private final List<Map<String, Object>> parsedUsers = new ArrayList<Map<String, Object>>();
    private final Map<RID, RID> vertexRidMap = new HashMap<RID, RID>();
    private final Map<String, Long> totalEdgesByVertexType = new HashMap<String, Long>();
    private final ImporterSettings settings = new ImporterSettings();
    private final ConsoleLogger logger;
    private String databasePath;
    private String inputFile;
    private String databaseName;
    private boolean createSecurityFiles = false;
    private boolean overwriteDatabase = false;
    private long totalRecordParsed = 0L;
    private long totalAttributesParsed = 0L;
    private long errors = 0L;
    private long warnings = 0L;
    private DatabaseFactory factory;
    private Database database;
    private int batchSize = 10000;
    private PHASE phase = PHASE.OFF;
    private long skippedRecordBecauseNullKey = 0L;
    private long skippedEdgeBecauseMissingVertex = 0L;
    private long beginTime;
    private long beginTimeRecordsCreation;
    private long beginTimeEdgeCreation;
    private JsonReader reader;
    private boolean error = false;
    private ImporterContext context = new ImporterContext();

    public OrientDBImporter(String[] args) {
        String state = null;
        for (String arg : args) {
            if (arg.equals("-?")) {
                this.printHelp();
                continue;
            }
            if (arg.equals("-d")) {
                state = "databasePath";
                continue;
            }
            if (arg.equals("-i")) {
                state = "inputFile";
                continue;
            }
            if (arg.equals("-s")) {
                this.createSecurityFiles = true;
                continue;
            }
            if (arg.equals("-o")) {
                this.overwriteDatabase = true;
                continue;
            }
            if (arg.equals("-b")) {
                state = "batchSize";
                continue;
            }
            if (arg.equals("-v")) {
                state = "verboseLevel";
                continue;
            }
            if (state == null) continue;
            if (state.equals("databasePath")) {
                this.databasePath = arg;
                continue;
            }
            if (state.equals("inputFile")) {
                this.inputFile = arg;
                continue;
            }
            if (state.equals("batchSize")) {
                this.batchSize = Integer.parseInt(arg);
                continue;
            }
            if (!state.equals("verboseLevel")) continue;
            this.settings.verboseLevel = Integer.parseInt(arg);
        }
        this.logger = new ConsoleLogger(this.settings.verboseLevel);
        this.printHeader();
        if (this.inputFile == null) {
            this.syntaxError("Missing input file. Use -f <file-path>");
        }
        this.file = new File(this.inputFile);
    }

    public OrientDBImporter(DatabaseInternal database) throws IOException {
        this.database = database;
        this.databasePath = database.getDatabasePath();
        this.file = null;
        this.logger = new ConsoleLogger(this.settings.verboseLevel);
    }

    public static void main(String[] args) throws IOException {
        new OrientDBImporter(args).run();
    }

    public GZIPInputStream openInputStream() throws IOException {
        return new GZIPInputStream(new FileInputStream(this.file));
    }

    public Database run() throws IOException {
        String from;
        if (this.file != null && !this.file.exists()) {
            this.error = true;
            throw new IllegalArgumentException("File '" + this.inputFile + "' not found");
        }
        String string = from = this.inputFile != null ? "'" + this.inputFile + "'" : "stream";
        if (this.databasePath == null) {
            this.logger.logLine(1, "Checking OrientDB database from %s...", from);
        } else {
            this.logger.logLine(1, "Importing OrientDB database from %s to '%s'", from, this.databasePath);
            if (!this.createDatabase()) {
                return null;
            }
        }
        this.beginTime = System.currentTimeMillis();
        this.phase = PHASE.CREATE_SCHEMA;
        this.logger.logLine(1, "Creation of the schema: types, properties and indexes", new Object[0]);
        this.parseInputFile();
        this.phase = PHASE.CREATE_EDGES;
        this.logger.logLine(1, "Creation of edges started: creating edges between vertices", new Object[0]);
        this.beginTimeEdgeCreation = System.currentTimeMillis();
        this.parseInputFile();
        if (this.database.getSchema().existsType("V") && this.database.countType("V", false) == 0L) {
            this.logger.logLine(2, "Dropping empty 'V' base vertex type (in OrientDB all the vertices have their own class", new Object[0]);
            this.database.getSchema().dropType("V");
        }
        if (this.database.getSchema().existsType("E") && this.database.countType("E", false) == 0L) {
            this.logger.logLine(2, "Dropping empty 'E' base edge type (in OrientDB all the edges have their own class", new Object[0]);
            this.database.getSchema().dropType("E");
        }
        long elapsed = (System.currentTimeMillis() - this.beginTime) / 1000L;
        this.logger.logLine(1, "***************************************************************************************************", new Object[0]);
        this.logger.logLine(1, "Import of OrientDB database completed in %,d secs with %,d errors and %,d warnings.", elapsed, this.errors, this.warnings);
        this.logger.logLine(1, "\nSUMMARY\n", new Object[0]);
        this.logger.logLine(1, "- Records..................................: %,d", this.totalRecordParsed);
        for (Map.Entry<String, OrientDBClass> entry : this.classes.entrySet()) {
            String className = entry.getKey();
            Long recordsByClass = this.totalRecordByType.get(className);
            long entries = recordsByClass != null ? recordsByClass : 0L;
            String additional = "";
            if (this.excludeClasses.contains(className)) {
                additional = " (excluded)";
            }
            this.logger.logLine(1, "-- %-40s: %,d %s", className, entries, additional);
        }
        this.logger.logLine(1, "- Total attributes.........................: %,d", this.totalAttributesParsed);
        this.logger.logLine(1, "***************************************************************************************************", new Object[0]);
        this.logger.logLine(1, "", new Object[0]);
        this.logger.logLine(1, "NOTES:", new Object[0]);
        if (this.createSecurityFiles) {
            this.writeSecurityFiles();
            this.logger.logLine(1, "- generated file server-users.jsonl to copy under ArcadeDB server 'config' directory. If the server already contains users, instead of replacing it, you can append the content", new Object[0]);
        } else {
            this.logger.logLine(1, "- users stored in OUser class will not be imported because ArcadeDB has users only at server level. If you want to import such users into ArcadeDB server configuration, please run the importer with the option -s <securityFileDirectory>", new Object[0]);
        }
        if (this.database != null) {
            this.logger.logLine(1, "- you can find your new ArcadeDB database in '" + this.database.getDatabasePath() + "'", new Object[0]);
        }
        return this.database;
    }

    private boolean createDatabase() {
        if (this.database == null) {
            this.factory = new DatabaseFactory(this.databasePath);
            if (this.factory.exists()) {
                if (!this.overwriteDatabase) {
                    this.logger.errorLine("Database already exists on path '%s'", this.databasePath);
                    ++this.errors;
                    return false;
                }
                this.database = this.factory.open();
                this.logger.errorLine("Found existent database at '%s', dropping it and recreate a new one", this.databasePath);
                this.database.drop();
            }
            this.database = this.factory.create();
        }
        return true;
    }

    public boolean isError() {
        return this.error;
    }

    public ImporterContext getContext() {
        return this.context;
    }

    public OrientDBImporter setContext(ImporterContext context) {
        this.context = context;
        return this;
    }

    private void parseInputFile() throws IOException {
        GZIPInputStream inputStream = this.openInputStream();
        this.reader = new JsonReader((Reader)new InputStreamReader((InputStream)inputStream, DatabaseFactory.getDefaultCharset()));
        this.reader.setLenient(true);
        this.reader.beginObject();
        block14: while (this.reader.hasNext()) {
            switch (this.reader.nextName()) {
                case "info": {
                    this.parseDatabaseInfo();
                    continue block14;
                }
                case "clusters": {
                    this.parseClusters();
                    continue block14;
                }
                case "schema": {
                    this.parseSchema();
                    continue block14;
                }
                case "records": {
                    this.parseRecords();
                    continue block14;
                }
            }
            try {
                this.reader.skipValue();
            }
            catch (EOFException e) {
                return;
            }
        }
        this.reader.endObject();
    }

    private void writeSecurityFiles() throws IOException {
        File securityFile = new File("./server-users.jsonl");
        StringBuilder buffer = new StringBuilder();
        for (Map<String, Object> u : this.parsedUsers) {
            JSONObject user = new JSONObject();
            user.put("name", u.get("name"));
            user.put("password", u.get("password"));
            user.put("databases", (Object)new JSONArray((Object)new String[]{this.databaseName}));
            buffer.append(user).append("\n");
        }
        FileUtils.writeFile((File)securityFile, (String)buffer.toString());
    }

    private void parseRecords() throws IOException {
        this.reader.beginArray();
        long processedItems = 0L;
        this.context.skippedEdges.set(0L);
        this.context.parsed.set(0L);
        this.database.begin();
        while (this.reader.peek() == JsonToken.BEGIN_OBJECT) {
            Map<String, Object> attributes = this.parseRecord(this.reader, false);
            String className = (String)attributes.get("@class");
            if (this.phase == PHASE.CREATE_SCHEMA || this.phase == PHASE.CREATE_RECORDS) {
                this.createRecords(processedItems, attributes, className);
            } else {
                this.createEdges(processedItems, attributes, className);
            }
            if (++processedItems > 0L && processedItems % (long)this.batchSize == 0L) {
                this.database.commit();
                this.database.begin();
            }
            if (this.reader.peek() != JsonToken.NULL) continue;
            this.reader.skipValue();
        }
        this.database.commit();
        long elapsedInSecs = (System.currentTimeMillis() - this.beginTime) / 1000L;
        switch (this.phase) {
            case CREATE_RECORDS: {
                this.logger.logLine(1, "- Creation of records completed: created %,d vertices and %,d documents, skipped %,d edges (%,d records/sec elapsed=%,d secs)", this.context.createdVertices.get(), this.context.createdDocuments.get(), this.context.skippedEdges.get(), elapsedInSecs > 0L ? (this.context.createdDocuments.get() + this.context.createdVertices.get()) / elapsedInSecs : 0L, elapsedInSecs);
                break;
            }
            case CREATE_EDGES: {
                this.logger.logLine(1, "- Creation of edges completed: created %,d edges %s (%,d edges/sec elapsed=%,d secs)", this.context.createdEdges.get(), this.totalEdgesByVertexType, elapsedInSecs > 0L ? this.context.createdEdges.get() / elapsedInSecs : 0L, elapsedInSecs);
                break;
            }
            default: {
                ++this.errors;
                this.error = true;
                throw new IllegalArgumentException("Invalid phase " + this.phase);
            }
        }
        this.reader.endArray();
    }

    private void createEdges(long processedItems, Map<String, Object> attributes, String className) {
        if (this.edgeClasses.contains(className)) {
            this.createEdges(attributes);
            if (processedItems > 0L && processedItems % 1000000L == 0L) {
                long elapsed = System.currentTimeMillis() - this.beginTimeEdgeCreation;
                this.logger.logLine(2, "- Status update: created %,d edges %s (%,d edges/sec)", this.context.createdEdges.get(), this.totalEdgesByVertexType, this.context.createdEdges.get() / elapsed * 1000L);
            }
        }
    }

    private void createRecords(long processedItems, Map<String, Object> attributes, String className) throws IOException {
        if (!this.edgeClasses.contains(className)) {
            this.createRecord(attributes);
        } else {
            this.context.skippedEdges.incrementAndGet();
        }
        if (processedItems > 0L && processedItems % 1000000L == 0L) {
            long elapsed = System.currentTimeMillis() - this.beginTimeRecordsCreation;
            this.logger.logLine(2, "- Status update: created %,d vertices and %,d documents, skipped %,d edges (%,d records/sec)", this.context.createdVertices.get(), this.context.createdDocuments.get(), this.context.skippedEdges.get(), (this.context.createdDocuments.get() + this.context.createdVertices.get()) / elapsed * 1000L);
        }
    }

    private MutableDocument createRecord(Map<String, Object> attributes) throws IOException {
        MutableVertex record = null;
        String rid = (String)attributes.get("@rid");
        if (rid == null) {
            return null;
        }
        RID recordRid = new RID(this.database, rid);
        String recordType = (String)attributes.get("@type");
        if (recordType != null) {
            switch (recordType) {
                case "b": {
                    if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 0L) break;
                    this.logger.errorLine("- Unsupported binary record. Ignoring record: %s", attributes);
                    ++this.warnings;
                    break;
                }
                case "d": {
                    String className = (String)attributes.get("@class");
                    if (className == null) {
                        if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 1L) break;
                        if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 2L) {
                            this.parseIndexes(attributes);
                            break;
                        }
                        this.logger.errorLine("- Unsupported record without class. Ignoring record: %s", attributes);
                        ++this.warnings;
                        break;
                    }
                    if (className.equals("OUser")) {
                        this.parsedUsers.add(attributes);
                    }
                    this.incrementRecordByClass(className);
                    ++this.totalRecordParsed;
                    this.context.parsed.incrementAndGet();
                    if (this.excludeClasses.contains(className)) break;
                    DocumentType type = this.database.getSchema().getType(className);
                    if (!this.checkForNullIndexes(attributes, type)) {
                        return null;
                    }
                    if (type instanceof VertexType) {
                        record = this.database.newVertex(className);
                    } else {
                        if (type instanceof EdgeType) {
                            return null;
                        }
                        record = this.database.newDocument(className);
                    }
                    for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                        String attrName = entry.getKey();
                        if (attrName.startsWith("@")) continue;
                        Object attrValue = entry.getValue();
                        if (attrValue instanceof Map) {
                            attrValue = this.createRecord((Map)attrValue);
                        } else if (attrValue instanceof List && record instanceof Vertex && (attrName.startsWith("out_") || attrName.startsWith("in_"))) {
                            attrValue = null;
                        }
                        if (attrValue == null) continue;
                        record.set(attrName, attrValue);
                    }
                    record.save();
                    if (type instanceof VertexType) {
                        this.context.createdVertices.incrementAndGet();
                    } else {
                        this.context.createdDocuments.incrementAndGet();
                    }
                    if (!(type instanceof VertexType)) break;
                    this.vertexRidMap.put(recordRid, record.getIdentity());
                    break;
                }
                default: {
                    ++this.errors;
                    this.logger.errorLine("- Unsupported record type '%s'", recordType);
                }
            }
        }
        return record;
    }

    private void createEdges(Map<String, Object> attributes) {
        String recordType = (String)attributes.get("@type");
        if (recordType == null || !recordType.equals("d")) {
            return;
        }
        String className = (String)attributes.get("@class");
        if (className == null) {
            return;
        }
        if (this.excludeClasses.contains(className)) {
            return;
        }
        DocumentType type = this.database.getSchema().getType(className);
        if (!(type instanceof EdgeType)) {
            return;
        }
        if (!this.checkForNullIndexes(attributes, type)) {
            return;
        }
        HashMap<String, Object> properties = Collections.EMPTY_MAP;
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            if (attr.getKey().startsWith("@") || attr.getKey().equals("out") || attr.getKey().equals("in")) continue;
            if (properties == Collections.EMPTY_MAP) {
                properties = new HashMap<String, Object>();
            }
            properties.put(attr.getKey(), attr.getValue());
        }
        RID out = new RID(this.database, (String)attributes.get("out"));
        RID newOut = this.vertexRidMap.get(out);
        if (newOut == null) {
            ++this.skippedEdgeBecauseMissingVertex;
            ++this.warnings;
            if (this.settings.verboseLevel < 3 && this.skippedEdgeBecauseMissingVertex == 100L) {
                this.logger.logLine(2, "- Skipped 100 edges because one vertex is not in the database. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedEdgeBecauseMissingVertex < 100L) {
                this.logger.logLine(2, "- Skip edge %s because source vertex (out) was not imported", attributes);
            }
            return;
        }
        RID in = new RID(this.database, (String)attributes.get("in"));
        RID newIn = this.vertexRidMap.get(in);
        if (newIn == null) {
            ++this.skippedEdgeBecauseMissingVertex;
            ++this.warnings;
            if (this.settings.verboseLevel < 3 && this.skippedEdgeBecauseMissingVertex == 100L) {
                this.logger.logLine(2, "- Skipped 100 edges because one vertex is not in the database. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedEdgeBecauseMissingVertex < 100L) {
                this.logger.logLine(2, "- Skip edge %s because destination vertex (in) was not imported", attributes);
            }
            return;
        }
        Vertex sourceVertex = (Vertex)this.database.lookupByRID(newOut, false);
        sourceVertex.newEdge(className, (Identifiable)newIn, true, new Object[]{properties});
        this.context.createdEdges.incrementAndGet();
        Long edgesByVertexType = this.totalEdgesByVertexType.computeIfAbsent(className, k -> 0L);
        this.totalEdgesByVertexType.put(className, edgesByVertexType + 1L);
        this.incrementRecordByClass(className);
    }

    private Map<String, Object> parseRecord(JsonReader reader, boolean ignore) throws IOException {
        LinkedHashMap<String, Object> attributes = ignore ? null : new LinkedHashMap<String, Object>();
        reader.beginObject();
        block8: while (reader.peek() != JsonToken.END_OBJECT) {
            Object attributeValue;
            String attributeName = reader.nextName();
            JsonToken propertyType = reader.peek();
            switch (propertyType) {
                case STRING: {
                    attributeValue = reader.nextString();
                    break;
                }
                case NUMBER: {
                    attributeValue = reader.nextDouble();
                    break;
                }
                case BOOLEAN: {
                    attributeValue = reader.nextBoolean();
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    attributeValue = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    attributeValue = this.parseRecord(reader, ignore);
                    break;
                }
                case BEGIN_ARRAY: {
                    attributeValue = this.parseArray(reader, ignore);
                    break;
                }
                default: {
                    this.logger.logLine(2, "Skipping property '%s' of type '%s'", attributeName, propertyType);
                    ++this.errors;
                    continue block8;
                }
            }
            if (ignore) continue;
            attributes.put(attributeName, attributeValue);
            ++this.totalAttributesParsed;
        }
        reader.endObject();
        return attributes;
    }

    private List<Object> parseArray(JsonReader reader, boolean ignore) throws IOException {
        ArrayList<Object> list = ignore ? null : new ArrayList<Object>();
        reader.beginArray();
        block8: while (reader.peek() != JsonToken.END_ARRAY) {
            Object entryValue;
            JsonToken entryType = reader.peek();
            switch (entryType) {
                case STRING: {
                    entryValue = reader.nextString();
                    break;
                }
                case NUMBER: {
                    entryValue = reader.nextDouble();
                    break;
                }
                case BOOLEAN: {
                    entryValue = reader.nextBoolean();
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    entryValue = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    entryValue = this.parseRecord(reader, ignore);
                    break;
                }
                case BEGIN_ARRAY: {
                    entryValue = this.parseArray(reader, ignore);
                    break;
                }
                default: {
                    ++this.errors;
                    this.logger.logLine(2, "Skipping entry of type '%s'", entryType);
                    continue block8;
                }
            }
            if (ignore) continue;
            list.add(entryValue);
        }
        reader.endArray();
        return list;
    }

    private void parseSchema() throws IOException {
        this.reader.beginObject();
        block26: while (this.reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = this.reader.nextName()) {
                case "classes": {
                    this.reader.beginArray();
                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                        this.reader.beginObject();
                        String className = null;
                        OrientDBClass cls = new OrientDBClass();
                        block28: while (this.reader.peek() != JsonToken.END_OBJECT) {
                            switch (this.reader.nextName()) {
                                case "name": {
                                    className = this.reader.nextString();
                                    continue block28;
                                }
                                case "cluster-ids": {
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        cls.clusterIds.add(this.reader.nextInt());
                                    }
                                    this.reader.endArray();
                                    continue block28;
                                }
                                case "super-classes": {
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        cls.superClasses.add(this.reader.nextString());
                                    }
                                    this.reader.endArray();
                                    continue block28;
                                }
                                case "properties": {
                                    String propertyName = null;
                                    String propertyType = null;
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        this.reader.beginObject();
                                        block32: while (this.reader.peek() != JsonToken.END_OBJECT) {
                                            switch (this.reader.nextName()) {
                                                case "name": {
                                                    propertyName = this.reader.nextString();
                                                    continue block32;
                                                }
                                                case "type": {
                                                    propertyType = this.reader.nextString();
                                                    continue block32;
                                                }
                                            }
                                            this.reader.skipValue();
                                        }
                                        cls.properties.put(propertyName, propertyType);
                                        this.reader.endObject();
                                    }
                                    this.reader.endArray();
                                    continue block28;
                                }
                            }
                            this.reader.skipValue();
                        }
                        this.reader.endObject();
                        this.classes.put(className, cls);
                    }
                    this.reader.endArray();
                    continue block26;
                }
            }
            this.reader.skipValue();
        }
        this.reader.endObject();
        for (String className : this.classes.keySet()) {
            this.createType(className);
        }
    }

    private void parseIndexes(Map<String, Object> attributes) throws IOException {
        List parsedIndexes = (List)attributes.get("indexes");
        for (Map parsedIndex : parsedIndexes) {
            parsedIndex.get("name");
            boolean unique = parsedIndex.get("type").toString().startsWith("UNIQUE");
            Map indexDefinition = (Map)parsedIndex.get("indexDefinition");
            String className = (String)indexDefinition.get("className");
            String keyType = (String)indexDefinition.get("keyType");
            if (!this.classes.containsKey(className) || this.excludeClasses.contains(className)) continue;
            String fieldName = (String)indexDefinition.get("field");
            Object[] properties = new String[]{fieldName};
            boolean nullValuesIgnored = (Boolean)indexDefinition.get("nullValuesIgnored");
            DocumentType type = this.database.getSchema().getType(className);
            if (!type.existsProperty(fieldName)) {
                if (keyType == null) {
                    this.logger.logLine(2, "- Skipped %s index creation on %s%s because the property is not defined and the key type is unknown", unique ? "UNIQUE" : "NOT UNIQUE", className, Arrays.toString(properties));
                    ++this.warnings;
                    continue;
                }
                type.createProperty(fieldName, Type.valueOf((String)keyType));
            }
            LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy = (nullValuesIgnored = true) ? LSMTreeIndexAbstract.NULL_STRATEGY.SKIP : LSMTreeIndexAbstract.NULL_STRATEGY.ERROR;
            this.database.getSchema().getOrCreateTypeIndex(Schema.INDEX_TYPE.LSM_TREE, unique, className, (String[])properties, 0x200000, nullStrategy, null);
            this.logger.logLine(2, "- Created index %s on %s%s", unique ? "UNIQUE" : "NOT UNIQUE", className, Arrays.toString(properties));
        }
        if (this.phase == PHASE.CREATE_SCHEMA) {
            this.logger.logLine(1, "Creation of records started: creating vertices and documents records (edges on the next phase)", new Object[0]);
            this.phase = PHASE.CREATE_RECORDS;
            this.beginTimeRecordsCreation = System.currentTimeMillis();
        }
    }

    private void createType(String className) {
        VertexType t;
        OrientDBClass classInfo = this.classes.get(className);
        int type = className.equals("V") ? 1 : (className.equals("E") ? 2 : 0);
        if (!classInfo.superClasses.isEmpty()) {
            for (String c : classInfo.superClasses) {
                this.createType(c);
            }
            type = this.getClassType(classInfo.superClasses);
        }
        if (this.database.getSchema().existsType(className)) {
            return;
        }
        if (this.excludeClasses.contains(className)) {
            return;
        }
        switch (type) {
            case 1: {
                t = this.database.getSchema().createVertexType(className);
                break;
            }
            case 2: {
                t = this.database.getSchema().createEdgeType(className);
                this.edgeClasses.add(className);
                break;
            }
            default: {
                t = this.database.getSchema().createDocumentType(className);
            }
        }
        for (Map.Entry<String, String> entry : classInfo.properties.entrySet()) {
            String orientdbType;
            switch (orientdbType = entry.getValue()) {
                case "EMBEDDEDLIST": 
                case "EMBEDDEDSET": 
                case "LINKLIST": 
                case "LINKSET": {
                    orientdbType = "LIST";
                    break;
                }
                case "EMBEDDEDMAP": 
                case "LINKMAP": {
                    orientdbType = "MAP";
                }
            }
            try {
                t.createProperty(entry.getKey(), Type.valueOf((String)orientdbType));
            }
            catch (Exception e) {
                this.logger.logLine(1, "- Unknown type '%s', ignoring creation of property in the schema for '%s.%s'", orientdbType, t.getName(), entry.getKey());
                ++this.warnings;
            }
        }
        this.logger.logLine(2, "- Created type '%s' with the following properties %s", className, classInfo.properties);
    }

    private int getClassType(List<String> list) {
        int type = 0;
        for (int i = 0; type == 0 && i < list.size(); ++i) {
            String su = list.get(i);
            if (su.equals("V")) {
                type = 1;
                break;
            }
            if (su.equals("E")) {
                type = 2;
                break;
            }
            OrientDBClass c = this.classes.get(su);
            if (c == null || c.superClasses.isEmpty()) continue;
            type = this.getClassType(c.superClasses);
        }
        return type;
    }

    private void parseClusters() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.reader.beginObject();
            String clusterName = null;
            int clusterId = -1;
            while (this.reader.hasNext()) {
                switch (this.reader.nextName()) {
                    case "name": {
                        clusterName = this.reader.nextString();
                        break;
                    }
                    case "id": {
                        clusterId = this.reader.nextInt();
                        break;
                    }
                    default: {
                        this.reader.skipValue();
                    }
                }
                if (clusterName == null || clusterId <= -1) continue;
                clusterName = null;
                clusterId = -1;
                this.skipUntilEndOfObject(this.reader, JsonToken.END_OBJECT);
                if (this.reader.peek() != JsonToken.BEGIN_OBJECT) break;
                this.reader.beginObject();
            }
            this.reader.endObject();
        }
        this.reader.endArray();
    }

    private void parseDatabaseInfo() throws IOException {
        this.reader.beginObject();
        switch (this.reader.nextName()) {
            case "name": {
                this.databaseName = this.reader.nextString();
                break;
            }
            default: {
                this.reader.skipValue();
            }
        }
        this.skipUntilEndOfObject(this.reader, JsonToken.END_OBJECT);
        this.reader.endObject();
    }

    private void skipUntilEndOfObject(JsonReader reader, JsonToken token) throws IOException {
        while (reader.hasNext()) {
            JsonToken t = reader.peek();
            reader.skipValue();
            if (t != token) continue;
            return;
        }
    }

    private void syntaxError(String s) {
        this.logger.errorLine("Syntax error: " + s, new Object[0]);
        this.error = true;
        this.printHelp();
    }

    private void printHeader() {
        this.logger.logLine(1, "ArcadeDB " + Constants.getVersion() + " - OrientDB Importer", new Object[0]);
    }

    private void printHelp() {
        this.logger.errorLine("Use:", new Object[0]);
        this.logger.errorLine("-d <database-path>: create a database from the OrientDB export", new Object[0]);
        this.logger.errorLine("-i <input-file>: path to the OrientDB export file. The default name is export.json.gz", new Object[0]);
        this.logger.errorLine("-s <security-file>: path to the security file generated from OrientDB users to use in ArcadeDB server", new Object[0]);
        this.logger.errorLine("-v <verbose-level>: 0 = error only, 1 = main steps, 2 = detailed steps, 3 = everything", new Object[0]);
    }

    private boolean checkForNullIndexes(Map<String, Object> properties, DocumentType type) {
        boolean valid = true;
        Collection indexes = type.getAllIndexes(true);
        for (Index index : indexes) {
            String indexedPropName;
            Object value;
            if (index.getNullStrategy() != LSMTreeIndexAbstract.NULL_STRATEGY.ERROR || (value = properties.get(indexedPropName = (String)index.getPropertyNames().get(0))) != null) continue;
            ++this.skippedRecordBecauseNullKey;
            ++this.errors;
            if (this.settings.verboseLevel < 3 && this.skippedRecordBecauseNullKey == 100L) {
                this.logger.logLine(2, "- Skipped 100 records where indexed field is null and the index is not accepting NULLs. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedRecordBecauseNullKey < 100L) {
                this.logger.logLine(2, "- Skipped record %s because indexed field '%s' is null and the index is not accepting NULLs", properties, indexedPropName);
            }
            valid = false;
        }
        return valid;
    }

    private void incrementRecordByClass(String className) {
        Long recordsByClass = this.totalRecordByType.computeIfAbsent(className, k -> 0L);
        this.totalRecordByType.put(className, recordsByClass + 1L);
    }

    private static class OrientDBClass {
        List<String> superClasses = new ArrayList<String>();
        List<Integer> clusterIds = new ArrayList<Integer>();
        Map<String, String> properties = new LinkedHashMap<String, String>();

        private OrientDBClass() {
        }
    }

    private static enum PHASE {
        OFF,
        CREATE_SCHEMA,
        CREATE_RECORDS,
        CREATE_EDGES;

    }
}

