/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.Constants;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.Identifiable;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.IndexCursor;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Neo4jImporter {
    private String databasePath;
    private String inputFile;
    private boolean overwriteDatabase = false;
    private Type typeForDecimals = Type.DECIMAL;
    private final Map<String, Long> totalVerticesByType = new HashMap<String, Long>();
    private long totalVerticesParsed = 0L;
    private final Map<String, Long> totalEdgesByType = new HashMap<String, Long>();
    private long totalEdgesParsed = 0L;
    private long totalAttributesParsed = 0L;
    private long errors = 0L;
    private long warnings = 0L;
    private DatabaseFactory factory;
    private Database database;
    private int batchSize = 10000;
    private long processedItems = 0L;
    private long skippedEdges = 0L;
    private long savedVertices = 0L;
    private long savedEdges = 0L;
    private long beginTime;
    private long beginTimeVerticesCreation;
    private long beginTimeEdgesCreation;
    private InputStream inputStream;
    private boolean error = false;
    private File file;
    private final Map<String, Map<String, Type>> schemaProperties = new HashMap<String, Map<String, Type>>();
    private static final SimpleDateFormat dateTimeISO8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Neo4jImporter(String[] args) {
        this.printHeader();
        String state = null;
        for (String arg : args) {
            if (arg.equals("-?")) {
                this.printHelp();
                continue;
            }
            if (arg.equals("-d")) {
                state = "databasePath";
                continue;
            }
            if (arg.equals("-i")) {
                state = "inputFile";
                continue;
            }
            if (arg.equals("-o")) {
                this.overwriteDatabase = true;
                continue;
            }
            if (arg.equals("-b")) {
                state = "batchSize";
                continue;
            }
            if (arg.equals("-decimalType")) {
                state = "decimalType";
                continue;
            }
            if (state == null) continue;
            if (state.equals("databasePath")) {
                this.databasePath = arg;
                continue;
            }
            if (state.equals("inputFile")) {
                this.inputFile = arg;
                continue;
            }
            if (state.equals("batchSize")) {
                this.batchSize = Integer.parseInt(arg);
                continue;
            }
            if (!state.equals("decimalType")) continue;
            this.typeForDecimals = Type.valueOf((String)arg.toUpperCase());
        }
        if (this.inputFile == null) {
            this.syntaxError("Missing input file. Use -f <file-path>");
        }
    }

    public Neo4jImporter(Database database) {
        this.database = database;
    }

    public static void main(String[] args) throws IOException {
        new Neo4jImporter(args).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (this.databasePath == null) {
            this.log("Checking Neo4j database from file '%s'...", this.inputFile);
        } else {
            this.log("Importing Neo4j database from file '%s' to '%s'", this.inputFile, this.databasePath);
            this.factory = new DatabaseFactory(this.databasePath);
            if (this.factory.exists()) {
                if (!this.overwriteDatabase) {
                    this.error("Database already exists on path '%s'", this.databasePath);
                    return;
                }
                this.database = this.factory.open();
                this.error("Found existent database at '%s', dropping it and recreate a new one", this.databasePath);
                this.database.drop();
            }
            this.database = this.factory.create();
        }
        try {
            String additional;
            long entries;
            String typeName;
            this.beginTime = System.currentTimeMillis();
            this.log("Creation of the schema: types, properties and indexes", new Object[0]);
            this.syncSchema();
            this.log("- Creation of vertices started", new Object[0]);
            this.beginTimeVerticesCreation = System.currentTimeMillis();
            this.parseVertices();
            this.log("Creation of edges started: creating edges between vertices", new Object[0]);
            this.beginTimeEdgesCreation = System.currentTimeMillis();
            this.parseEdges();
            long elapsed = (System.currentTimeMillis() - this.beginTime) / 1000L;
            this.log("***************************************************************************************************", new Object[0]);
            this.log("Import of Neo4j database completed in %,d secs with %,d errors and %,d warnings.", elapsed, this.errors, this.warnings);
            this.log("\nSUMMARY\n", new Object[0]);
            this.log("- Vertices.............: %,d", this.totalVerticesParsed);
            for (Map.Entry<String, Long> entry : this.totalVerticesByType.entrySet()) {
                typeName = entry.getKey();
                Long verticesByClass = this.totalVerticesByType.get(typeName);
                entries = verticesByClass != null ? verticesByClass : 0L;
                additional = "";
                this.log("-- %-20s: %,d %s", typeName, entries, additional);
            }
            this.log("- Edges................: %,d", this.totalEdgesParsed);
            for (Map.Entry<String, Long> entry : this.totalEdgesByType.entrySet()) {
                typeName = entry.getKey();
                Long edgesByClass = this.totalEdgesByType.get(typeName);
                entries = edgesByClass != null ? edgesByClass : 0L;
                additional = "";
                this.log("-- %-20s: %,d %s", typeName, entries, additional);
            }
            this.log("- Total attributes.....: %,d", this.totalAttributesParsed);
            this.log("***************************************************************************************************", new Object[0]);
            this.log("", new Object[0]);
            this.log("NOTES:", new Object[0]);
            if (this.database != null) {
                this.log("- you can find your new ArcadeDB database in '" + this.database.getDatabasePath() + "'", new Object[0]);
            }
        }
        finally {
            if (this.database != null) {
                this.database.close();
            }
        }
    }

    public boolean isError() {
        return this.error;
    }

    private void syncSchema() throws IOException {
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            switch (json.getString("type")) {
                case "node": {
                    Pair<String, List<String>> labels = this.typeNameFromLabels((JSONObject)json);
                    if (!this.database.getSchema().existsType((String)labels.getFirst())) {
                        VertexType type = this.database.getSchema().getOrCreateVertexType((String)labels.getFirst());
                        if (labels.getSecond() != null) {
                            for (String parent : (List)labels.getSecond()) {
                                type.addSuperType(parent);
                            }
                        }
                        this.database.transaction(() -> {
                            Property id = type.createProperty("id", Type.STRING);
                            id.createIndex(Schema.INDEX_TYPE.LSM_TREE, true);
                        });
                    }
                    this.inferPropertyType((JSONObject)json, (String)labels.getFirst());
                    break;
                }
                case "relationship": {
                    String edgeLabel;
                    String string = edgeLabel = json.has("label") && !json.isNull("label") ? json.getString("label") : null;
                    if (edgeLabel != null) {
                        this.database.getSchema().getOrCreateEdgeType(edgeLabel);
                    }
                    this.inferPropertyType((JSONObject)json, edgeLabel);
                }
            }
            return null;
        }));
    }

    private void inferPropertyType(JSONObject json, String label) {
        Map typeProperties = this.schemaProperties.computeIfAbsent(label, k -> new HashMap());
        JSONObject properties = json.getJSONObject("properties");
        for (String propName : properties.keySet()) {
            Object propValue;
            ++this.totalAttributesParsed;
            Type currentType = (Type)typeProperties.get(propName);
            if (currentType != null || (propValue = properties.get(propName)).equals(JSONObject.NULL)) continue;
            if (propValue instanceof String) {
                try {
                    dateTimeISO8601Format.parse((String)propValue);
                    currentType = Type.DATETIME;
                }
                catch (ParseException e) {
                    currentType = Type.STRING;
                }
            } else {
                if (propValue instanceof JSONObject) {
                    propValue = ((JSONObject)propValue).toMap();
                } else if (propValue instanceof JSONArray) {
                    propValue = ((JSONArray)propValue).toList();
                }
                currentType = Type.getTypeByValue((Object)propValue);
            }
            typeProperties.put(propName, currentType);
        }
    }

    private void parseVertices() throws IOException {
        this.database.begin();
        AtomicInteger lineNumber = new AtomicInteger();
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            lineNumber.incrementAndGet();
            switch (json.getString("type")) {
                case "node": {
                    Pair<String, List<String>> type;
                    ++this.processedItems;
                    ++this.totalVerticesParsed;
                    if (this.processedItems > 0L && this.processedItems % 1000000L == 0L) {
                        long elapsed = System.currentTimeMillis() - this.beginTimeVerticesCreation;
                        this.log("- Status update: created %,d vertices, skipped %,d edges (%,d vertices/sec)", this.savedVertices, this.skippedEdges, this.savedVertices / elapsed * 1000L);
                    }
                    if ((type = this.typeNameFromLabels((JSONObject)json)) == null) {
                        this.log("- found vertex in line %d without labels. Skip it.", lineNumber.get());
                        ++this.warnings;
                        return null;
                    }
                    String typeName = (String)type.getFirst();
                    String id = json.getString("id");
                    MutableVertex vertex = this.database.newVertex(typeName);
                    vertex.fromMap(this.setProperties(json.getJSONObject("properties"), this.schemaProperties.get(typeName)));
                    vertex.set("id", (Object)id);
                    vertex.save();
                    ++this.savedVertices;
                    this.incrementVerticesByType(typeName);
                    if (this.processedItems <= 0L || this.processedItems % (long)this.batchSize != 0L) break;
                    this.database.commit();
                    this.database.begin();
                    break;
                }
                case "relationship": {
                    ++this.skippedEdges;
                }
            }
            return null;
        }));
        this.database.commit();
        long elapsedInSecs = (System.currentTimeMillis() - this.beginTime) / 1000L;
        this.log("- Creation of vertices completed: created %,d vertices, skipped %,d edges (%,d vertices/sec elapsed=%,d secs)", this.savedVertices, this.skippedEdges, elapsedInSecs > 0L ? this.savedVertices / elapsedInSecs : 0L, elapsedInSecs);
    }

    private void parseEdges() throws IOException {
        this.database.begin();
        AtomicInteger lineNumber = new AtomicInteger();
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            lineNumber.incrementAndGet();
            switch (json.getString("type")) {
                case "node": {
                    break;
                }
                case "relationship": {
                    String type;
                    ++this.processedItems;
                    ++this.totalEdgesParsed;
                    if (this.processedItems > 0L && this.processedItems % 1000000L == 0L) {
                        long elapsed = System.currentTimeMillis() - this.beginTimeEdgesCreation;
                        this.log("- Status update: created %,d edges %s (%,d edges/sec)", this.savedEdges, this.totalEdgesByType, this.savedEdges / elapsed * 1000L);
                    }
                    if ((type = json.getString("label")) == null) {
                        this.log("- found edge in line %d without labels. Skip it.", lineNumber.get());
                        ++this.warnings;
                        return null;
                    }
                    JSONObject start = json.getJSONObject("start");
                    Pair<String, List<String>> startType = this.typeNameFromLabels(start);
                    String startId = start.getString("id");
                    IndexCursor beginCursor = this.database.lookupByKey((String)startType.getFirst(), "id", (Object)startId);
                    if (!beginCursor.hasNext()) {
                        this.log("- cannot create relationship with id '%s'. Vertex id '%s' not found for labels. Skip it.", json.getString("id"), startId);
                        ++this.warnings;
                        return null;
                    }
                    Vertex fromVertex = ((Identifiable)beginCursor.next()).asVertex();
                    JSONObject end = json.getJSONObject("end");
                    Pair<String, List<String>> endType = this.typeNameFromLabels(end);
                    String endId = end.getString("id");
                    IndexCursor endCursor = this.database.lookupByKey((String)endType.getFirst(), "id", (Object)endId);
                    if (!endCursor.hasNext()) {
                        this.log("- cannot create relationship with id '%s'. Vertex id '%s' not found for labels. Skip it.", json.getString("id"), endId);
                        ++this.warnings;
                        return null;
                    }
                    Identifiable toVertex = (Identifiable)endCursor.next();
                    MutableEdge edge = fromVertex.newEdge(type, toVertex, true, new Object[0]);
                    edge.fromMap(this.setProperties(json.getJSONObject("properties"), this.schemaProperties.get(type)));
                    edge.save();
                    ++this.savedEdges;
                    this.incrementEdgesByType(type);
                    if (this.processedItems <= 0L || this.processedItems % (long)this.batchSize != 0L) break;
                    this.database.commit();
                    this.database.begin();
                }
            }
            return null;
        }));
        this.database.commit();
        long elapsedInSecs = (System.currentTimeMillis() - this.beginTime) / 1000L;
        this.log("- Creation of edged completed: created %,d edges, (%,d edges/sec elapsed=%,d secs)", this.savedEdges, elapsedInSecs > 0L ? this.savedEdges / elapsedInSecs : 0L, elapsedInSecs);
    }

    private Map<String, Object> setProperties(JSONObject properties, Map<String, Type> typeSchema) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String propName : properties.keySet()) {
            Map<String, Object> propValue = properties.get(propName);
            if (propValue == JSONObject.NULL) {
                propValue = null;
            } else if (propValue instanceof JSONObject) {
                propValue = this.setProperties((JSONObject)propValue, null);
            } else if (propValue instanceof JSONArray) {
                propValue = ((JSONArray)propValue).toList();
            } else if (propValue instanceof String && typeSchema != null && typeSchema.get(propName) == Type.DATETIME) {
                try {
                    propValue = dateTimeISO8601Format.parse((String)((Object)propValue)).getTime();
                }
                catch (ParseException e) {
                    this.log("Invalid date '%s', ignoring conversion to timestamp and leaving it as string", propValue);
                    ++this.errors;
                }
            } else if (propValue instanceof BigDecimal) {
                propValue = this.typeForDecimals.newInstance((Object)propValue);
            }
            result.put(propName, propValue);
        }
        return result;
    }

    public InputStream openInputStream() throws IOException {
        this.file = new File(this.inputFile);
        if (!this.file.exists()) {
            this.error = true;
            throw new IllegalArgumentException("File '" + this.inputFile + "' not found");
        }
        return this.file.getName().endsWith("gz") ? new GZIPInputStream(new FileInputStream(this.file)) : new FileInputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(Callable<Void, JSONObject> callback) throws IOException {
        this.inputStream = this.openInputStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream, DatabaseFactory.getDefaultCharset()));){
            String line;
            long lineNumber = 0L;
            while ((line = reader.readLine()) != null) {
                try {
                    JSONObject json = new JSONObject(line);
                    switch (json.getString("type")) {
                        case "node": {
                            callback.call((Object)json);
                            break;
                        }
                        case "relationship": {
                            callback.call((Object)json);
                            break;
                        }
                        default: {
                            this.log("Invalid 'type' content on line %d of the input JSONL file. The line will be ignored. JSON: %s", lineNumber, line);
                            ++this.errors;
                            break;
                        }
                    }
                }
                catch (JSONException e) {
                    this.log("Error on parsing json on line %d of the input JSONL file. The line will be ignored. JSON: %s", lineNumber, line);
                    ++this.errors;
                }
                ++lineNumber;
            }
        }
        finally {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    private void incrementVerticesByType(String label) {
        Long vertices = this.totalVerticesByType.get(label);
        this.totalVerticesByType.put(label, vertices == null ? 1L : vertices + 1L);
    }

    private void incrementEdgesByType(String label) {
        Long edges = this.totalEdgesByType.get(label);
        this.totalEdgesByType.put(label, edges == null ? 1L : edges + 1L);
    }

    private Pair<String, List<String>> typeNameFromLabels(JSONObject json) {
        JSONArray nodeLabels;
        JSONArray jSONArray = nodeLabels = json.has("labels") && !json.isNull("labels") ? json.getJSONArray("labels") : null;
        if (nodeLabels != null && nodeLabels.length() > 0) {
            if (nodeLabels.length() > 1) {
                Stream<String> list = nodeLabels.toList().stream().map(String.class::cast).sorted(Comparator.naturalOrder());
                return new Pair((Object)list.collect(Collectors.joining("_")), list.collect(Collectors.toList()));
            }
            return new Pair((Object)((String)nodeLabels.get(0)), null);
        }
        return null;
    }

    private void log(String text, Object ... args) {
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.printf(text + "%n", args);
        }
    }

    private void error(String text, Object ... args) {
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.println(String.format(text, args));
        }
    }

    private void syntaxError(String s) {
        this.log("Syntax error: " + s, new Object[0]);
        this.error = true;
        this.printHelp();
    }

    private void printHeader() {
        this.log("ArcadeDB " + Constants.getVersion() + " - Neo4j Importer", new Object[0]);
    }

    private void printHelp() {
        this.log("Use:", new Object[0]);
        this.log("-d <database-path>: create a database from the Neo4j export", new Object[0]);
        this.log("-i <input-file>: path to the Neo4j export file in JSONL format", new Object[0]);
        this.log("-o: overwrite an existent database", new Object[0]);
        this.log("-decimalType <type>: use <type> for decimals. <type> can be FLOAT, DOUBLE and DECIMAL. By default decimalType is DECIMAL.", new Object[0]);
    }

    private static enum PHASE {
        OFF,
        CREATE_SCHEMA,
        CREATE_VERTICES,
        CREATE_EDGES;

    }
}

