/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.utility.FileUtils;
import java.util.HashMap;
import java.util.Map;

public class ImporterSettings {
    public String database = "./databases/imported";
    public String url = null;
    public boolean wal = false;
    public int verboseLevel = 2;
    public String documents;
    public String documentsFileType;
    public String documentsDelimiter;
    public String documentsHeader;
    public Long documentsSkipEntries = null;
    public String documentTypeName = "Document";
    public String documentPropertiesInclude = "*";
    public String vertices;
    public String verticesFileType;
    public String verticesDelimiter;
    public String verticesHeader;
    public Long verticesSkipEntries = null;
    public String vertexTypeName = "Node";
    public String vertexPropertiesInclude = "*";
    public long expectedVertices = 0L;
    public String edges;
    public String edgesFileType;
    public String edgesDelimiter;
    public String edgesHeader;
    public Long edgesSkipEntries = null;
    public String edgeTypeName = "Relationship";
    public String edgePropertiesInclude = "*";
    public long expectedEdges = 0L;
    public long maxRAMIncomingEdges = 0x10000000L;
    public String edgeFromField = null;
    public String edgeToField = null;
    public boolean edgeBidirectional = true;
    public String typeIdProperty = null;
    public boolean typeIdPropertyIsUnique = false;
    public String typeIdType = "String";
    public int parallel = 1;
    public boolean forceDatabaseCreate;
    public boolean trimText = true;
    public long analysisLimitBytes = 100000L;
    public long analysisLimitEntries = 10000L;
    public long parsingLimitBytes;
    public long parsingLimitEntries;
    public int commitEvery = 5000;
    public final Map<String, String> options = new HashMap<String, String>();

    public ImporterSettings() {
        this.parallel = Runtime.getRuntime().availableProcessors() / 2 - 1;
        if (this.parallel < 1) {
            this.parallel = 1;
        }
    }

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length - 1; i += 2) {
                this.parseParameter(args[i].substring(1), args[i + 1]);
            }
        }
    }

    public void parseParameter(String name, String value) {
        if ("database".equals(name)) {
            this.database = value;
        } else if ("url".equals(name)) {
            this.url = value;
        } else if ("forceDatabaseCreate".equals(name)) {
            this.forceDatabaseCreate = Boolean.parseBoolean(value);
        } else if ("wal".equals(name)) {
            this.wal = Boolean.parseBoolean(value);
        } else if ("commitEvery".equals(name)) {
            this.commitEvery = Integer.parseInt(value);
        } else if ("parallel".equals(name)) {
            this.parallel = Integer.parseInt(value);
        } else if ("typeIdProperty".equals(name)) {
            this.typeIdProperty = value;
        } else if ("typeIdUnique".equals(name)) {
            this.typeIdPropertyIsUnique = Boolean.parseBoolean(value);
        } else if ("typeIdType".equals(name)) {
            this.typeIdType = value;
        } else if ("trimText".equals(name)) {
            this.trimText = Boolean.parseBoolean(value);
        } else if ("analysisLimitBytes".equals(name)) {
            this.analysisLimitBytes = FileUtils.getSizeAsNumber((Object)value);
        } else if ("analysisLimitEntries".equals(name)) {
            this.analysisLimitEntries = Long.parseLong(value);
        } else if ("parsingLimitBytes".equals(name)) {
            this.parsingLimitBytes = FileUtils.getSizeAsNumber((Object)value);
        } else if ("parsingLimitEntries".equals(name)) {
            this.parsingLimitEntries = Long.parseLong(value);
        } else if ("documents".equals(name)) {
            this.documents = value;
        } else if ("documentsFileType".equals(name)) {
            this.documentsFileType = value;
        } else if ("documentsDelimiter".equals(name)) {
            this.documentsDelimiter = value;
        } else if ("documentsHeader".equals(name)) {
            this.documentsHeader = value;
        } else if ("documentsSkipEntries".equals(name)) {
            this.documentsSkipEntries = Long.parseLong(value);
        } else if ("documentPropertiesInclude".equals(name)) {
            this.documentPropertiesInclude = value;
        } else if ("documentType".equals(name)) {
            this.documentTypeName = value;
        } else if ("vertices".equals(name)) {
            this.vertices = value;
        } else if ("verticesFileType".equals(name)) {
            this.verticesFileType = value;
        } else if ("verticesDelimiter".equals(name)) {
            this.verticesDelimiter = value;
        } else if ("verticesHeader".equals(name)) {
            this.verticesHeader = value;
        } else if ("verticesSkipEntries".equals(name)) {
            this.verticesSkipEntries = Long.parseLong(value);
        } else if ("expectedVertices".equals(name)) {
            this.expectedVertices = Integer.parseInt(value);
        } else if ("vertexType".equals(name)) {
            this.vertexTypeName = value;
        } else if ("vertexPropertiesInclude".equals(name)) {
            this.vertexPropertiesInclude = value;
        } else if ("edges".equals(name)) {
            this.edges = value;
        } else if ("edgesFileType".equals(name)) {
            this.edgesFileType = value;
        } else if ("edgesDelimiter".equals(name)) {
            this.edgesDelimiter = value;
        } else if ("edgesHeader".equals(name)) {
            this.edgesHeader = value;
        } else if ("edgesSkipEntries".equals(name)) {
            this.edgesSkipEntries = Long.parseLong(value);
        } else if ("expectedEdges".equals(name)) {
            this.expectedEdges = Integer.parseInt(value);
        } else if ("maxRAMIncomingEdges".equals(name)) {
            this.maxRAMIncomingEdges = Long.parseLong(value);
        } else if ("edgeType".equals(name)) {
            this.edgeTypeName = value;
        } else if ("edgePropertiesInclude".equals(name)) {
            this.edgePropertiesInclude = value;
        } else if ("edgeFromField".equals(name)) {
            this.edgeFromField = value;
        } else if ("edgeToField".equals(name)) {
            this.edgeToField = value;
        } else if ("edgeBidirectional".equals(name)) {
            this.edgeBidirectional = Boolean.parseBoolean(value);
        } else {
            this.options.put(name, value);
        }
    }
}

