/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AbstractImporter;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceDiscovery;
import com.arcadedb.integration.importer.SourceSchema;
import java.io.IOException;

public class Importer
extends AbstractImporter {
    public Importer(String[] args) {
        super(args);
    }

    public Importer(Database database, String url) {
        super((DatabaseInternal)database);
        this.settings.url = url;
    }

    public static void main(String[] args) {
        new Importer(args).load();
        System.exit(0);
    }

    public void load() {
        this.source = null;
        try {
            String cfgValue = this.settings.options.get("maxValueSampling");
            AnalyzedSchema analyzedSchema = new AnalyzedSchema(cfgValue != null ? (long)Integer.parseInt(cfgValue) : 100L);
            this.openDatabase();
            this.startImporting();
            this.loadFromSource(this.settings.url, AnalyzedEntity.ENTITY_TYPE.DATABASE, analyzedSchema);
            this.loadFromSource(this.settings.documents, AnalyzedEntity.ENTITY_TYPE.DOCUMENT, analyzedSchema);
            this.loadFromSource(this.settings.vertices, AnalyzedEntity.ENTITY_TYPE.VERTEX, analyzedSchema);
            this.loadFromSource(this.settings.edges, AnalyzedEntity.ENTITY_TYPE.EDGE, analyzedSchema);
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new ImportException("Error on parsing source '" + this.source + "'", e);
        }
        finally {
            if (this.database != null) {
                this.stopImporting();
                this.closeDatabase();
            }
            this.closeInputFile();
        }
    }

    protected void loadFromSource(String url, AnalyzedEntity.ENTITY_TYPE entityType, AnalyzedSchema analyzedSchema) throws IOException {
        if (url == null) {
            return;
        }
        SourceDiscovery sourceDiscovery = new SourceDiscovery(url);
        SourceSchema sourceSchema = sourceDiscovery.getSchema(this.settings, entityType, analyzedSchema);
        if (sourceSchema == null) {
            return;
        }
        this.updateDatabaseSchema(sourceSchema.getSchema());
        this.source = sourceDiscovery.getSource();
        this.parser = new Parser(this.source, 0L);
        this.parser.reset();
        sourceSchema.getContentImporter().load(sourceSchema, entityType, this.parser, this.database, this.context, this.settings);
    }

    @Override
    protected void closeDatabase() {
        if (!this.databaseCreatedDuringImporting) {
            return;
        }
        if (this.database != null) {
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
            this.database.close();
        }
    }
}

