/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

public class ConsoleLogger {
    private final int verboseLevel;

    public ConsoleLogger(int verboseLevel) {
        this.verboseLevel = verboseLevel;
    }

    public void logLine(int level, String text, Object ... args) {
        if (level > this.verboseLevel) {
            return;
        }
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.printf(text + "%n", args);
        }
    }

    public void log(int level, String text, Object ... args) {
        if (level > this.verboseLevel) {
            return;
        }
        if (args.length == 0) {
            System.out.print(text);
        } else {
            System.out.print(String.format(text, args));
        }
    }

    public void errorLine(String text, Object ... args) {
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.printf(text + "%n", args);
        }
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }
}

