/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.engine.Dictionary;
import com.arcadedb.engine.WALFile;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedProperty;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.Source;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public abstract class AbstractImporter {
    protected Parser parser;
    protected ImporterSettings settings = new ImporterSettings();
    protected ImporterContext context = new ImporterContext();
    protected DatabaseInternal database;
    protected Source source;
    protected Timer timer;
    protected boolean databaseCreatedDuringImporting = true;
    protected ConsoleLogger logger;

    public AbstractImporter(String[] args) {
        this.settings.parseParameters(args);
    }

    public AbstractImporter(DatabaseInternal database) {
        this.database = database;
        this.databaseCreatedDuringImporting = false;
    }

    protected void printProgress() {
        if (this.settings.verboseLevel < 2) {
            return;
        }
        try {
            long deltaInSecs = (System.currentTimeMillis() - this.context.lastLapOn) / 1000L;
            if (deltaInSecs == 0L) {
                deltaInSecs = 1L;
            }
            if (this.source == null || this.source.compressed || this.source.totalSize < 0L) {
                this.logger.logLine(2, "- Status update: parsed %,d (%,d/sec) - %,d documents (%,d/sec) - %,d vertices (%,d/sec) - %,d edges (%,d/sec) - %,d skipped edges - %,d linked edges (%,d/sec - %,d%%)", this.context.parsed.get(), (this.context.parsed.get() - this.context.lastParsed) / deltaInSecs, this.context.createdDocuments.get(), (this.context.createdDocuments.get() - this.context.lastDocuments) / deltaInSecs, this.context.createdVertices.get(), (this.context.createdVertices.get() - this.context.lastVertices) / deltaInSecs, this.context.createdEdges.get(), (this.context.createdEdges.get() - this.context.lastEdges) / deltaInSecs, this.context.skippedEdges.get(), this.context.linkedEdges.get(), (this.context.linkedEdges.get() - this.context.lastLinkedEdges) / deltaInSecs, this.context.createdEdges.get() > 0L ? (int)(this.context.linkedEdges.get() * 100L / this.context.createdEdges.get()) : 0);
            } else {
                int progressPerc = (int)(this.parser.getPosition() * 100L / this.source.totalSize);
                this.logger.logLine(2, "Status update: parsed %,d (%,d/sec - %,d%%) - %,d records (%,d/sec) - %,d vertices (%,d/sec) - %,d edges (%,d/sec) - %,d skipped edges - %,d linked edges (%,d/sec - %,d%%)", this.context.parsed.get(), (this.context.parsed.get() - this.context.lastParsed) / deltaInSecs, progressPerc, this.context.createdDocuments.get(), (this.context.createdDocuments.get() - this.context.lastDocuments) / deltaInSecs, this.context.createdVertices.get(), (this.context.createdVertices.get() - this.context.lastVertices) / deltaInSecs, this.context.createdEdges.get(), (this.context.createdEdges.get() - this.context.lastEdges) / deltaInSecs, this.context.skippedEdges.get(), this.context.linkedEdges.get(), (this.context.linkedEdges.get() - this.context.lastLinkedEdges) / deltaInSecs, this.context.createdEdges.get() > 0L ? (int)(this.context.linkedEdges.get() * 100L / this.context.createdEdges.get()) : 0);
            }
            this.context.lastLapOn = System.currentTimeMillis();
            this.context.lastParsed = this.context.parsed.get();
            this.context.lastDocuments = this.context.createdDocuments.get();
            this.context.lastVertices = this.context.createdVertices.get();
            this.context.lastEdges = this.context.createdEdges.get();
            this.context.lastLinkedEdges = this.context.linkedEdges.get();
        }
        catch (Exception e) {
            this.logger.errorLine("Error on print statistics: " + e.getMessage(), new Object[0]);
        }
    }

    protected void startImporting() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(this.settings.verboseLevel);
        }
        this.context.startedOn = this.context.lastLapOn = System.currentTimeMillis();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractImporter.this.printProgress();
            }
        }, 5000L, 5000L);
    }

    protected void stopImporting() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.printProgress();
    }

    protected void closeInputFile() {
        if (this.source != null) {
            this.source.close();
        }
    }

    protected void closeDatabase() {
        if (!this.databaseCreatedDuringImporting) {
            return;
        }
        if (this.database != null) {
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
            this.database.close();
        }
    }

    protected void openDatabase() {
        if (this.database != null && this.database.isOpen()) {
            return;
        }
        DatabaseFactory factory = new DatabaseFactory(this.settings.database);
        if (this.settings.forceDatabaseCreate && factory.exists()) {
            FileUtils.deleteRecursively((File)new File(this.settings.database));
        }
        if (factory.exists()) {
            LogManager.instance().log((Object)this, Level.INFO, "Opening database '%s'...", (Object)this.settings.database);
            this.database = (DatabaseInternal)factory.open();
        } else {
            LogManager.instance().log((Object)this, Level.INFO, "Creating database '%s'...", (Object)this.settings.database);
            this.database = (DatabaseInternal)factory.create();
        }
        this.database.begin();
        if (this.settings.documents != null) {
            this.settings.documentTypeName = this.getOrCreateDocumentType(this.settings.documentTypeName).getName();
        }
        if (this.settings.vertices != null) {
            this.settings.vertexTypeName = this.getOrCreateVertexType(this.settings.vertexTypeName).getName();
        }
        if (this.settings.edges != null) {
            this.settings.edgeTypeName = this.getOrCreateEdgeType(this.settings.edgeTypeName).getName();
        }
        this.database.commit();
        this.database.setReadYourWrites(false);
        this.database.async().setParallelLevel(this.settings.parallel);
        this.database.async().setCommitEvery(this.settings.commitEvery);
        this.database.async().setTransactionUseWAL(this.settings.wal);
        this.database.async().setTransactionSync(WALFile.FLUSH_TYPE.NO);
        this.database.begin();
    }

    protected void beginTxIfNeeded() {
        if (!this.database.isTransactionActive()) {
            this.database.begin();
        }
    }

    protected DocumentType getOrCreateDocumentType(String name) {
        if (!this.database.getSchema().existsType(name)) {
            LogManager.instance().log((Object)this, Level.INFO, "Creating type '%s' of type DOCUMENT", (Object)name);
            this.beginTxIfNeeded();
            DocumentType type = this.database.getSchema().createDocumentType(name, this.settings.parallel);
            if (this.settings.typeIdProperty != null) {
                type.createProperty(this.settings.typeIdProperty, Type.getTypeByName((String)this.settings.typeIdType));
                this.database.getSchema().createTypeIndex(Schema.INDEX_TYPE.LSM_TREE, this.settings.typeIdPropertyIsUnique, name, new String[]{this.settings.typeIdProperty});
                LogManager.instance().log((Object)this, Level.INFO, "- Creating indexed property '%s' of type '%s'", (Object)this.settings.typeIdProperty, (Object)this.settings.typeIdType);
            }
            return type;
        }
        return this.database.getSchema().getType(name);
    }

    protected VertexType getOrCreateVertexType(String name) {
        if (!this.database.getSchema().existsType(name)) {
            LogManager.instance().log((Object)this, Level.INFO, "Creating type '%s' of type VERTEX", (Object)name);
            this.beginTxIfNeeded();
            VertexType type = this.database.getSchema().createVertexType(name, this.settings.parallel);
            if (this.settings.typeIdProperty != null) {
                type.createProperty(this.settings.typeIdProperty, Type.getTypeByName((String)this.settings.typeIdType));
                this.database.getSchema().createTypeIndex(Schema.INDEX_TYPE.LSM_TREE, this.settings.typeIdPropertyIsUnique, name, new String[]{this.settings.typeIdProperty});
                LogManager.instance().log((Object)this, Level.INFO, "- Creating indexed property '%s' of type '%s'", (Object)this.settings.typeIdProperty, (Object)this.settings.typeIdType);
            }
            return type;
        }
        return (VertexType)this.database.getSchema().getType(name);
    }

    protected EdgeType getOrCreateEdgeType(String name) {
        if (!this.database.getSchema().existsType(name)) {
            LogManager.instance().log((Object)this, Level.INFO, "Creating type '%s' of type EDGE", (Object)name);
            this.beginTxIfNeeded();
            return this.database.getSchema().createEdgeType(name, this.settings.parallel);
        }
        return (EdgeType)this.database.getSchema().getType(name);
    }

    protected void updateDatabaseSchema(AnalyzedSchema schema) {
        if (schema == null) {
            return;
        }
        Dictionary dictionary = this.database.getSchema().getDictionary();
        LogManager.instance().log((Object)this, Level.INFO, "Checking schema...");
        for (AnalyzedEntity entity : schema.getEntities()) {
            VertexType type;
            switch (entity.getType()) {
                case VERTEX: {
                    type = this.getOrCreateVertexType(entity.getName());
                    break;
                }
                case EDGE: {
                    type = this.getOrCreateEdgeType(entity.getName());
                    break;
                }
                case DOCUMENT: {
                    type = this.getOrCreateDocumentType(entity.getName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Record type '" + entity.getType() + "' is not supported");
                }
            }
            for (AnalyzedProperty propValue : entity.getProperties()) {
                String propName = propValue.getName();
                if (type.existsProperty(propName)) {
                    Property property = type.getPolymorphicProperty(propName);
                    if (property.getType() != propValue.getType()) {
                        LogManager.instance().log((Object)this, Level.WARNING, "- found schema property %s.%s of type %s, while analyzing the source type %s was found", (Object)entity, (Object)propName, (Object)property.getType(), (Object)propValue.getType());
                    }
                } else {
                    LogManager.instance().log((Object)this, Level.INFO, "- creating property %s.%s of type %s", (Object)entity, (Object)propName, (Object)propValue.getType());
                    type.createProperty(propName, propValue.getType());
                }
                for (String sample : propValue.getContents()) {
                    dictionary.getIdByName(sample, true);
                }
            }
        }
        this.database.getSchema().getEmbedded().saveConfiguration();
    }

    protected void dumpSchema(AnalyzedSchema schema, long parsedObjects) {
        LogManager.instance().log((Object)this, Level.INFO, "---------------------------------------------------------------");
        LogManager.instance().log((Object)this, Level.INFO, "Objects found %d", (Object)parsedObjects);
        for (AnalyzedEntity entity : schema.getEntities()) {
            LogManager.instance().log((Object)this, Level.INFO, "---------------------------------------------------------------");
            LogManager.instance().log((Object)this, Level.INFO, "Entity '%s':", (Object)entity);
            for (AnalyzedProperty p : entity.getProperties()) {
                LogManager.instance().log((Object)this, Level.INFO, "- %s (%s)", (Object)p.getName(), (Object)p.getType());
                if (!p.isCollectingSamples()) continue;
                LogManager.instance().log((Object)this, Level.INFO, "    contents (%d items): %s", (Object)p.getContents().size(), p.getContents());
            }
        }
        LogManager.instance().log((Object)this, Level.INFO, "---------------------------------------------------------------");
    }
}

