/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.exporter.format;

import com.arcadedb.Constants;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Document;
import com.arcadedb.database.Record;
import com.arcadedb.integration.exporter.ExportException;
import com.arcadedb.integration.exporter.ExporterContext;
import com.arcadedb.integration.exporter.ExporterSettings;
import com.arcadedb.integration.exporter.format.AbstractExporterFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.schema.EmbeddedSchema;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.JsonGraphSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;

public class JsonlExporterFormat
extends AbstractExporterFormat {
    public static final String NAME = "jsonl";
    protected final JSONObject sharedJson = new JSONObject();
    private OutputStreamWriter writer;
    private static final int VERSION = 1;

    public JsonlExporterFormat(DatabaseInternal database, ExporterSettings settings, ExporterContext context, ConsoleLogger logger) {
        super(database, settings, context, logger);
    }

    @Override
    public void exportDatabase() throws Exception {
        File file = new File(this.settings.file);
        if (file.exists() && !this.settings.overwriteFile) {
            throw new ExportException(String.format("The export file '%s' already exist and '-o' setting is false", this.settings.file));
        }
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ExportException(String.format("The export file '%s' cannot be created", this.settings.file));
        }
        if (this.database.isTransactionActive()) {
            throw new ExportException("Transaction in progress found");
        }
        this.logger.logLine(0, "Exporting database to '%s'...", this.settings.file);
        File exportFile = this.settings.file.startsWith("file://") ? new File(this.settings.file.substring("file://".length())) : new File(this.settings.file);
        if (!exportFile.getParentFile().exists()) {
            exportFile.getParentFile().mkdirs();
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(exportFile)), DatabaseFactory.getDefaultCharset());){
            this.writer = fileWriter;
            this.writeJsonLine("info", new JSONObject().put("description", (Object)"ArcadeDB Database Export").put("exporterVersion", 1).put("dbVersion", (Object)Constants.getRawVersion()).put("dbBranch", (Object)Constants.getBranch()).put("dbBuild", (Object)Constants.getBuildNumber()).put("dbTimestamp", (Object)Constants.getTimestamp()));
            long now = System.currentTimeMillis();
            this.writeJsonLine("db", new JSONObject().put("name", (Object)this.database.getName()).put("executedOn", (Object)dateFormat.format(now)).put("executedOnTimestamp", now));
            this.writeJsonLine("schema", ((EmbeddedSchema)this.database.getSchema()).toJSON());
            ArrayList<String> vertexTypes = new ArrayList<String>();
            ArrayList<String> edgeTypes = new ArrayList<String>();
            ArrayList<String> documentTypes = new ArrayList<String>();
            for (DocumentType type : this.database.getSchema().getTypes()) {
                if (type instanceof VertexType) {
                    vertexTypes.add(type.getName());
                    continue;
                }
                if (type instanceof EdgeType) {
                    edgeTypes.add(type.getName());
                    continue;
                }
                documentTypes.add(type.getName());
            }
            JSONObject recordJson = new JSONObject();
            JsonGraphSerializer graphSerializer = new JsonGraphSerializer().setSharedJson(recordJson).setExpandVertexEdges(true);
            this.exportVertices(vertexTypes, graphSerializer);
            this.exportEdges(edgeTypes, graphSerializer);
            this.exportDocuments(documentTypes, graphSerializer);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void exportVertices(List<String> vertexTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : vertexTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                this.writeJsonLine("v", graphSerializer.serializeGraphElement((Document)((Record)cursor.next()).asVertex(true)));
                this.context.vertices.incrementAndGet();
            }
        }
    }

    private void exportEdges(List<String> edgeTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : edgeTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                this.writeJsonLine("e", graphSerializer.serializeGraphElement((Document)((Record)cursor.next()).asEdge(true)));
                this.context.edges.incrementAndGet();
            }
        }
    }

    private void exportDocuments(List<String> documentTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : documentTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                this.writeJsonLine("d", graphSerializer.serializeGraphElement(((Record)cursor.next()).asDocument(true)));
                this.context.documents.incrementAndGet();
            }
        }
    }

    protected void writeJsonLine(String type, JSONObject json) throws IOException {
        this.writer.write(this.sharedJson.put("t", (Object)type).put("c", (Object)json).toString() + "\n");
        this.sharedJson.clear();
    }
}

