/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.exporter;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class ExporterSettings {
    public String format;
    public String databaseURL;
    public String file;
    public boolean overwriteFile = false;
    public int verboseLevel = 2;
    public final Map<String, String> options = new HashMap<String, String>();

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length - 1; i += this.parseParameter(args[i].substring(1), args[i + 1])) {
            }
        }
        if (this.format == null) {
            throw new IllegalArgumentException("Missing export format");
        }
        if (this.file == null) {
            switch (this.format) {
                case "jsonl": {
                    this.file = "arcadedb-export-%s.jsonl.tgz";
                    break;
                }
                case "backup": {
                    this.file = "arcadedb-backup-%s.zip";
                }
            }
        }
        if (this.file == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
            this.file = String.format(this.file, dateFormat.format(System.currentTimeMillis()));
        }
    }

    public int parseParameter(String name, String value) {
        if ("format".equals(name)) {
            this.format = value.toLowerCase();
        } else if ("f".equals(name)) {
            this.file = value;
        } else if ("d".equals(name)) {
            this.databaseURL = value;
        } else {
            if ("o".equals(name)) {
                this.overwriteFile = true;
                return 1;
            }
            this.options.put(name, value);
        }
        return 2;
    }
}

