/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.backup.format;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.EmbeddedDatabase;
import com.arcadedb.engine.PaginatedFile;
import com.arcadedb.integration.backup.BackupException;
import com.arcadedb.integration.backup.BackupSettings;
import com.arcadedb.integration.backup.format.AbstractBackupFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.schema.EmbeddedSchema;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FullBackupFormat
extends AbstractBackupFormat {
    public FullBackupFormat(DatabaseInternal database, BackupSettings settings, ConsoleLogger logger) {
        super(database, settings, logger);
    }

    @Override
    public void backupDatabase() throws Exception {
        File backupFile;
        this.settings.validateSettings();
        Object fileName = this.settings.file.startsWith("file://") ? this.settings.file.substring("file://".length()) : this.settings.file;
        if (this.settings.directory != null) {
            fileName = this.settings.directory + File.separator + (String)fileName;
        }
        if ((backupFile = new File((String)fileName)).exists() && !this.settings.overwriteFile) {
            throw new BackupException(String.format("The backup file '%s' already exist and '-o' setting is false", this.settings.file));
        }
        if (backupFile.getParentFile() != null && !backupFile.getParentFile().exists() && !backupFile.getParentFile().mkdirs()) {
            throw new BackupException(String.format("The backup file '%s' cannot be created", this.settings.file));
        }
        if (this.database.isTransactionActive()) {
            throw new BackupException("Transaction in progress found");
        }
        this.logger.logLine(0, "Executing full backup of database to '%s'...", this.settings.file);
        try (ZipOutputStream zipFile = new ZipOutputStream((OutputStream)new FileOutputStream(backupFile), DatabaseFactory.getDefaultCharset());){
            zipFile.setLevel(9);
            this.database.executeInReadLock(() -> {
                this.database.getPageManager().suspendPageFlushing(true);
                try {
                    long beginTime = System.currentTimeMillis();
                    long databaseOrigSize = 0L;
                    databaseOrigSize += this.compressFile(zipFile, ((EmbeddedDatabase)this.database).getConfigurationFile());
                    databaseOrigSize += this.compressFile(zipFile, ((EmbeddedSchema)this.database.getSchema()).getConfigurationFile());
                    List files = this.database.getFileManager().getFiles();
                    for (PaginatedFile paginatedFile : files) {
                        if (paginatedFile == null) continue;
                        databaseOrigSize += this.compressFile(zipFile, paginatedFile.getOSFile());
                    }
                    zipFile.close();
                    long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
                    long databaseCompressedSize = backupFile.length();
                    this.logger.logLine(0, "Full backup completed in %d seconds %s -> %s (%,d%% compressed)", elapsedInSecs, FileUtils.getSizeAsString((long)databaseOrigSize), FileUtils.getSizeAsString((long)databaseCompressedSize), databaseOrigSize > 0L ? (databaseOrigSize - databaseCompressedSize) * 100L / databaseOrigSize : 0L);
                }
                finally {
                    this.database.getPageManager().suspendPageFlushing(false);
                }
                return null;
            });
        }
    }

    private long compressFile(ZipOutputStream zipFile, File inputFile) throws IOException {
        this.logger.log(2, "- File '%s'...", inputFile.getName());
        long origSize = inputFile.length();
        ZipEntry zipEntry = new ZipEntry(inputFile.getName());
        zipFile.putNextEntry(zipEntry);
        try (FileInputStream fileIn = new FileInputStream(inputFile);){
            fileIn.transferTo(zipFile);
        }
        zipFile.closeEntry();
        long compressedSize = zipEntry.getCompressedSize();
        this.logger.logLine(2, " %s -> %s (%,d%% compressed)", FileUtils.getSizeAsString((long)origSize), FileUtils.getSizeAsString((long)compressedSize), origSize > 0L ? (origSize - compressedSize) * 100L / origSize : 0L);
        return origSize;
    }
}

