/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal;

import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.velocypack.internal.util.DateUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class VPackDeserializers {
    public static final VPackDeserializer<String> STRING = new VPackDeserializer<String>(){

        @Override
        public String deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsString();
        }
    };
    public static final VPackDeserializer<Boolean> BOOLEAN = new VPackDeserializer<Boolean>(){

        @Override
        public Boolean deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsBoolean();
        }
    };
    public static final VPackDeserializer<Integer> INTEGER = new VPackDeserializer<Integer>(){

        @Override
        public Integer deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsInt();
        }
    };
    public static final VPackDeserializer<Long> LONG = new VPackDeserializer<Long>(){

        @Override
        public Long deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsLong();
        }
    };
    public static final VPackDeserializer<Short> SHORT = new VPackDeserializer<Short>(){

        @Override
        public Short deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsShort();
        }
    };
    public static final VPackDeserializer<Double> DOUBLE = new VPackDeserializer<Double>(){

        @Override
        public Double deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsDouble();
        }
    };
    public static final VPackDeserializer<Float> FLOAT = new VPackDeserializer<Float>(){

        @Override
        public Float deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return Float.valueOf(vpack.getAsFloat());
        }
    };
    public static final VPackDeserializer<BigInteger> BIG_INTEGER = new VPackDeserializer<BigInteger>(){

        @Override
        public BigInteger deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsBigInteger();
        }
    };
    public static final VPackDeserializer<BigDecimal> BIG_DECIMAL = new VPackDeserializer<BigDecimal>(){

        @Override
        public BigDecimal deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsBigDecimal();
        }
    };
    public static final VPackDeserializer<Number> NUMBER = new VPackDeserializer<Number>(){

        @Override
        public Number deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack.getAsNumber();
        }
    };
    public static final VPackDeserializer<Character> CHARACTER = new VPackDeserializer<Character>(){

        @Override
        public Character deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return Character.valueOf(vpack.getAsChar());
        }
    };
    public static final VPackDeserializer<java.util.Date> DATE = new VPackDeserializer<java.util.Date>(){

        @Override
        public java.util.Date deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            java.util.Date date;
            if (vpack.isString()) {
                try {
                    date = DateUtil.parse(vpack.getAsString());
                }
                catch (ParseException e) {
                    throw new VPackParserException(e);
                }
            } else {
                date = vpack.getAsDate();
            }
            return date;
        }
    };
    public static final VPackDeserializer<Date> SQL_DATE = new VPackDeserializer<Date>(){

        @Override
        public Date deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            Date date;
            if (vpack.isString()) {
                try {
                    date = new Date(DateUtil.parse(vpack.getAsString()).getTime());
                }
                catch (ParseException e) {
                    throw new VPackParserException(e);
                }
            } else {
                date = vpack.getAsSQLDate();
            }
            return date;
        }
    };
    public static final VPackDeserializer<Timestamp> SQL_TIMESTAMP = new VPackDeserializer<Timestamp>(){

        @Override
        public Timestamp deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            Timestamp date;
            if (vpack.isString()) {
                try {
                    date = new Timestamp(DateUtil.parse(vpack.getAsString()).getTime());
                }
                catch (ParseException e) {
                    throw new VPackParserException(e);
                }
            } else {
                date = vpack.getAsSQLTimestamp();
            }
            return date;
        }
    };
    public static final VPackDeserializer<VPackSlice> VPACK = new VPackDeserializer<VPackSlice>(){

        @Override
        public VPackSlice deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return vpack;
        }
    };
    public static final VPackDeserializer<UUID> UUID = new VPackDeserializer<UUID>(){

        @Override
        public UUID deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return java.util.UUID.fromString(vpack.getAsString());
        }
    };
    public static final VPackDeserializer<byte[]> BYTE_ARRAY = new VPackDeserializer<byte[]>(){

        @Override
        public byte[] deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return DatatypeConverter.parseBase64Binary((String)vpack.getAsString());
        }
    };
    public static final VPackDeserializer<Byte> BYTE = new VPackDeserializer<Byte>(){

        @Override
        public Byte deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) {
            return vpack.getAsByte();
        }
    };

    private VPackDeserializers() {
    }
}

