package com.arakelian.docker.junit;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Container.Binding}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBinding.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Container.Binding"})
@Immutable
@CheckReturnValue
public final class ImmutableBinding implements Container.Binding {
  private final String host;
  private final int port;

  private ImmutableBinding(String host, int port) {
    this.host = host;
    this.port = port;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @Override
  public String getHost() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @Override
  public int getPort() {
    return port;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Container.Binding#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBinding withHost(String value) {
    if (this.host.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "host");
    return new ImmutableBinding(newValue, this.port);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Container.Binding#getPort() port} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBinding withPort(int value) {
    if (this.port == value) return this;
    return new ImmutableBinding(this.host, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBinding} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBinding
        && equalTo((ImmutableBinding) another);
  }

  private boolean equalTo(ImmutableBinding another) {
    return host.equals(another.host)
        && port == another.port;
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + host.hashCode();
    h += (h << 5) + port;
    return h;
  }

  /**
   * Prints the immutable value {@code Binding} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Binding")
        .omitNullValues()
        .add("host", host)
        .add("port", port)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Container.Binding} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Binding instance
   */
  public static ImmutableBinding copyOf(Container.Binding instance) {
    if (instance instanceof ImmutableBinding) {
      return (ImmutableBinding) instance;
    }
    return ImmutableBinding.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBinding ImmutableBinding}.
   * @return A new ImmutableBinding builder
   */
  public static ImmutableBinding.Builder builder() {
    return new ImmutableBinding.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBinding ImmutableBinding}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private static final long INIT_BIT_PORT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String host;
    private int port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Binding} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Container.Binding instance) {
      Objects.requireNonNull(instance, "instance");
      host(instance.getHost());
      port(instance.getPort());
      return this;
    }

    /**
     * Initializes the value for the {@link Container.Binding#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the value for the {@link Container.Binding#getPort() port} attribute.
     * @param port The value for port 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder port(int port) {
      this.port = port;
      initBits &= ~INIT_BIT_PORT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBinding ImmutableBinding}.
     * @return An immutable instance of Binding
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBinding build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBinding(host, port);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_PORT) != 0) attributes.add("port");
      return "Cannot build Binding, some of required attributes are not set " + attributes;
    }
  }
}
