/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.internal;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.view.WindowManager;
import androidx.annotation.VisibleForTesting;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1bSDK;
import com.appsflyer.internal.AFa1cSDK;
import com.appsflyer.internal.AFa1dSDK;
import com.appsflyer.internal.AFa1gSDK;
import com.appsflyer.internal.AFa1iSDK;
import com.appsflyer.internal.AFb1cSDK;
import com.appsflyer.internal.AFb1fSDK;
import com.appsflyer.internal.AFb1jSDK;
import com.appsflyer.internal.AFb1xSDK;
import com.appsflyer.internal.AFc1uSDK;
import com.appsflyer.internal.AFe1lSDK;
import com.appsflyer.internal.AFe1tSDK;
import com.appsflyer.internal.AFe1xSDK;
import com.appsflyer.internal.AFf1fSDK;
import com.appsflyer.internal.AFf1mSDK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public final class AFe1uSDK
implements AFe1tSDK {
    @NotNull
    private final Context AFInAppEventParameterName;
    @NotNull
    private final AFf1mSDK valueOf;
    @NotNull
    private final AFb1jSDK AFInAppEventType;
    @NotNull
    private final AFf1fSDK AFKeystoreWrapper;
    @NotNull
    private final AFa1gSDK values;
    @NotNull
    private final AFe1lSDK AFLogger;
    @NotNull
    private final AFb1fSDK afInfoLog;
    @NotNull
    private final AFb1cSDK afDebugLog;
    @NotNull
    private final AFa1iSDK afRDLog;
    @NotNull
    private final AFe1xSDK afErrorLog;
    @NotNull
    private final AFb1xSDK getLevel;

    public AFe1uSDK() {
    }

    public AFe1uSDK(Context context, AFf1mSDK aFf1mSDK, AFb1jSDK aFb1jSDK, AFf1fSDK aFf1fSDK, AFa1gSDK aFa1gSDK, AFe1lSDK aFe1lSDK, AFb1fSDK aFb1fSDK, AFb1cSDK aFb1cSDK, AFa1iSDK aFa1iSDK, AFe1xSDK aFe1xSDK, AFb1xSDK aFb1xSDK) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFf1mSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFb1jSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFf1fSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFa1gSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFe1lSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFb1fSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFb1cSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFa1iSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFe1xSDK, (String)"");
        Intrinsics.checkNotNullParameter((Object)aFb1xSDK, (String)"");
        this.AFInAppEventParameterName = context;
        this.valueOf = aFf1mSDK;
        this.AFInAppEventType = aFb1jSDK;
        this.AFKeystoreWrapper = aFf1fSDK;
        this.values = aFa1gSDK;
        this.AFLogger = aFe1lSDK;
        this.afInfoLog = aFb1fSDK;
        this.afDebugLog = aFb1cSDK;
        this.afRDLog = aFa1iSDK;
        this.afErrorLog = aFe1xSDK;
        this.getLevel = aFb1xSDK;
    }

    @Override
    @Nullable
    public final String valueOf() throws CertificateException, NoSuchAlgorithmException, PackageManager.NameNotFoundException {
        return AFa1cSDK.AFInAppEventType(this.AFInAppEventParameterName.getApplicationContext().getPackageManager(), this.AFInAppEventParameterName.getApplicationContext().getPackageName());
    }

    @Override
    public final long AFKeystoreWrapper() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    @Override
    @NotNull
    public final String values() {
        long l;
        long l2;
        StatFs statFs = new StatFs(Environment.getDataDirectory().getAbsolutePath());
        if (Build.VERSION.SDK_INT >= 18) {
            long l3 = statFs.getBlockSizeLong();
            l2 = statFs.getAvailableBlocksLong() * l3;
            l = statFs.getBlockCountLong() * l3;
        } else {
            int n = statFs.getBlockSize();
            l2 = statFs.getAvailableBlocks() * n;
            l = statFs.getBlockCount() * n;
        }
        double d = Math.pow(2.0, 20.0);
        long l4 = (long)((double)l2 / d);
        long l5 = (long)((double)l / d);
        return "" + l4 + '/' + l5;
    }

    @Override
    public final void values(Map<String, Object> map, boolean bl) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        Map<String, Object> map2 = map;
        String string = "platformextension";
        String string2 = this.getLevel.values();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        map2.put(string, string3);
        if (bl) {
            map.put("platform_extension_v2", this.valueOf.AFInAppEventParameterName());
        }
    }

    @Override
    public final void AFKeystoreWrapper(Map<String, Object> object) {
        String string;
        Intrinsics.checkNotNullParameter(object, (String)"");
        Map<String, Object> map = this.AFInAppEventParameterName.getSystemService("window");
        WindowManager windowManager = map instanceof WindowManager ? (WindowManager)map : null;
        if (windowManager == null) {
            return;
        }
        Object object2 = windowManager.getDefaultDisplay();
        map = object;
        object = "sc_o";
        switch (object2.getRotation()) {
            case 0: {
                string = "p";
                break;
            }
            case 2: {
                string = "pr";
                break;
            }
            case 3: {
                string = "lr";
                break;
            }
            case 1: {
                string = "l";
                break;
            }
            default: {
                string = "";
            }
        }
        object2 = string;
        map.put((String)object, object2);
    }

    @Override
    public final void AFInAppEventParameterName(boolean bl, Map<String, Object> map, int n) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        Map map2 = new HashMap();
        map2.put("cpu_abi", AFe1uSDK.AFInAppEventParameterName("ro.product.cpu.abi"));
        map2.put("cpu_abi2", AFe1uSDK.AFInAppEventParameterName("ro.product.cpu.abi2"));
        map2.put("arch", AFe1uSDK.AFInAppEventParameterName("os.arch"));
        map2.put("build_display_id", AFe1uSDK.AFInAppEventParameterName("ro.build.display.id"));
        if (bl) {
            Map map3 = map2;
            Object object = this;
            object = ((AFe1uSDK)object).AFInAppEventType.AFInAppEventParameterName(((AFe1uSDK)object).AFInAppEventParameterName);
            float f = ((AFb1jSDK.AFa1xSDK)object).AFKeystoreWrapper;
            object = ((AFb1jSDK.AFa1xSDK)object).AFInAppEventType;
            map3.put("btl", String.valueOf(f));
            if (object != null) {
                map3.put("btch", object);
            }
            if (n <= 2) {
                map2.putAll(this.AFKeystoreWrapper.AFKeystoreWrapper());
            }
        }
        Map<String, String> map4 = this.values.AFInAppEventType(this.AFInAppEventParameterName);
        map2.put("dim", map4);
        map.put("deviceData", map2);
    }

    @Override
    public final void AFInAppEventType(Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        String string = AppsFlyerProperties.getInstance().getString("oneLinkSlug");
        String string2 = AppsFlyerProperties.getInstance().getString("onelinkVersion");
        if (string != null) {
            map.put("onelink_id", string);
        }
        if (string2 != null) {
            map.put("onelink_ver", string2);
        }
    }

    @Override
    public final void values(Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        Object object = this.AFLogger;
        Object object2 = new HashMap<String, Object>(((AFe1lSDK)object).AFInAppEventParameterName);
        ((AFe1lSDK)object).AFInAppEventParameterName.clear();
        object = object2;
        object2 = "gcd";
        this.AFLogger.AFKeystoreWrapper.AFInAppEventType((String)object2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
        if (!object.isEmpty()) {
            map = AFa1dSDK.AFInAppEventParameterName(map);
            Intrinsics.checkNotNullExpressionValue(map, (String)"");
            map.put("gcd", object);
        }
    }

    @Override
    public final void AFKeystoreWrapper(Map<String, Object> map, String string) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            String string2 = this.afInfoLog.valueOf("prev_event_name", null);
            if (string2 != null) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("prev_event_timestamp", this.afInfoLog.values("prev_event_timestamp", -1L));
                jSONObject.put("prev_event_name", (Object)string2);
                map.put("prev_event", jSONObject);
            }
            this.afInfoLog.values("prev_event_name", string);
            this.afInfoLog.AFInAppEventType("prev_event_timestamp", System.currentTimeMillis());
            return;
        }
        catch (Exception exception) {
            com.appsflyer.AFLogger.afErrorLog("Error while processing previous event.", exception);
            return;
        }
    }

    @Override
    @Nullable
    public final String AFInAppEventParameterName() {
        String string;
        Object object;
        if (this.afInfoLog.valueOf("INSTALL_STORE")) {
            return this.afInfoLog.valueOf("INSTALL_STORE", null);
        }
        if (this.afErrorLog()) {
            object = this;
            string = AppsFlyerProperties.getInstance().getString("api_store_value");
            if (string == null) {
                AFe1uSDK aFe1uSDK = object;
                object = "AF_STORE";
                string = aFe1uSDK.afDebugLog.valueOf((String)object);
            }
        } else {
            string = null;
        }
        object = string;
        this.afInfoLog.values("INSTALL_STORE", (String)object);
        return object;
    }

    @Override
    @Nullable
    public final String AFInAppEventType() {
        String string = AppsFlyerProperties.getInstance().getString("api_store_value");
        if (string == null) {
            String string2 = "AF_STORE";
            string = this.afDebugLog.valueOf(string2);
        }
        return string;
    }

    @Override
    @Nullable
    public final String AFInAppEventParameterName(SimpleDateFormat simpleDateFormat) {
        Intrinsics.checkNotNullParameter((Object)simpleDateFormat, (String)"");
        String string = this.afInfoLog.valueOf("appsFlyerFirstInstall", null);
        if (string == null) {
            String string2;
            if (this.afErrorLog()) {
                com.appsflyer.AFLogger.afDebugLog("AppsFlyer: first launch detected");
                string2 = simpleDateFormat.format(new Date());
            } else {
                string2 = "";
            }
            string = string2;
            this.afInfoLog.values("appsFlyerFirstInstall", string);
        }
        com.appsflyer.AFLogger.afInfoLog("AppsFlyer: first launch date: ".concat(String.valueOf(string)));
        return string;
    }

    @Override
    public final boolean afErrorLog() {
        return !this.afInfoLog.valueOf("appsFlyerCount");
    }

    @Override
    public final boolean AFLogger() {
        return Boolean.parseBoolean(this.afInfoLog.valueOf("sentSuccessfully", null));
    }

    @Override
    public final void valueOf(Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        boolean bl = AppsFlyerProperties.getInstance().getBoolean("disableCollectNetworkData", false);
        AFa1iSDK.AFa1vSDK aFa1vSDK = this.afRDLog.valueOf(this.AFInAppEventParameterName);
        Map<String, Object> map2 = map;
        String string = "network";
        String string2 = aFa1vSDK.AFKeystoreWrapper;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2;
        map2.put(string, string3);
        if (bl) {
            return;
        }
        String string4 = aFa1vSDK.values;
        if (string4 != null) {
            string3 = string4;
            map.put("operator", string3);
        }
        String string5 = aFa1vSDK.AFInAppEventType;
        if (string5 != null) {
            string3 = string5;
            map.put("carrier", string3);
            return;
        }
    }

    @Override
    public final boolean afInfoLog() {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Object object = this.AFInAppEventParameterName.getSystemService("connectivity");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager connectivityManager = (ConnectivityManager)object;
                Network[] networkArray = connectivityManager.getAllNetworks();
                Intrinsics.checkNotNullExpressionValue((Object)networkArray, (String)"");
                for (Network network : networkArray) {
                    boolean bl = (network = connectivityManager.getNetworkCapabilities(network)) != null ? network.hasTransport(4) : false;
                    if (!bl || network.hasCapability(15)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                com.appsflyer.AFLogger.afErrorLog("Failed collecting ivc data", exception);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            List list = new ArrayList();
            try {
                for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                    if (!networkInterface.isUp()) continue;
                    String string = networkInterface.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    list.add(string);
                }
                return list.contains("tun0");
            }
            catch (Exception exception) {
                com.appsflyer.AFLogger.afErrorLog("Failed collecting ivc data", exception);
            }
        }
        return false;
    }

    @Override
    @Nullable
    public final String afDebugLog() {
        AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
        Object object = appsFlyerProperties.getString("preInstallName");
        if (object != null) {
            return object;
        }
        if (this.afInfoLog.valueOf("preInstallName")) {
            object = this.afInfoLog.valueOf("preInstallName", null);
        } else {
            if (this.afErrorLog()) {
                Object object2;
                String string;
                object = this;
                Object object3 = AFe1uSDK.AFInAppEventType(AFe1uSDK.AFInAppEventParameterName("ro.appsflyer.preinstall.path"));
                if (AFe1uSDK.AFKeystoreWrapper((File)object3)) {
                    object3 = "AF_PRE_INSTALL_PATH";
                    object3 = AFe1uSDK.AFInAppEventType(((AFe1uSDK)object).afDebugLog.valueOf((String)object3));
                }
                if (AFe1uSDK.AFKeystoreWrapper((File)object3)) {
                    object3 = AFe1uSDK.AFInAppEventType("/data/local/tmp/pre_install.appsflyer");
                }
                if (AFe1uSDK.AFKeystoreWrapper((File)object3)) {
                    object3 = AFe1uSDK.AFInAppEventType("/etc/pre_install.appsflyer");
                }
                if (AFe1uSDK.AFKeystoreWrapper((File)object3)) {
                    string = null;
                } else {
                    String string2 = ((AFe1uSDK)object).AFInAppEventParameterName.getPackageName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    string = object2 = AFe1uSDK.AFInAppEventType((File)object3, string2);
                }
                if (string == null) {
                    object3 = "AF_PRE_INSTALL_NAME";
                    object2 = object = this.afDebugLog.valueOf((String)object3);
                }
            }
            if (object != null) {
                this.afInfoLog.values("preInstallName", (String)object);
            }
        }
        if (object != null) {
            appsFlyerProperties.set("preInstallName", (String)object);
        }
        return object;
    }

    @Override
    @SuppressLint(value={"HardwareIds"})
    public final void AFInAppEventType(Map<String, Object> map, String object) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(map, (String)"");
        Object object2 = AppsFlyerProperties.getInstance();
        if (((AppsFlyerProperties)object2).getBoolean("deviceTrackingDisabled", false)) {
            map.put("deviceTrackingDisabled", "true");
            return;
        }
        Object object3 = this.afErrorLog.AFInAppEventType(this.afInfoLog);
        CharSequence charSequence2 = (CharSequence)object3;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            map.put("imei", object3);
        }
        boolean bl = ((AppsFlyerProperties)object2).getBoolean("collectAndroidId", false);
        object2 = this.afInfoLog.valueOf("androidIdCached", null);
        object3 = null;
        if (bl && ((charSequence = (CharSequence)object) == null || charSequence.length() == 0)) {
            if (this.afRDLog()) {
                try {
                    charSequence = Settings.Secure.getString((ContentResolver)this.AFInAppEventParameterName.getContentResolver(), (String)"android_id");
                    if (charSequence != null) {
                        object3 = charSequence;
                    } else if (object2 != null) {
                        com.appsflyer.AFLogger.afDebugLog("use cached AndroidId: ".concat(String.valueOf(object2)));
                        object3 = object2;
                    }
                }
                catch (Exception exception) {
                    if (object2 != null) {
                        com.appsflyer.AFLogger.afDebugLog("use cached AndroidId: ".concat(String.valueOf(object2)));
                        object3 = object2;
                    }
                    com.appsflyer.AFLogger.afErrorLog(exception.getMessage(), exception);
                }
            }
        } else if (object != null) {
            object3 = object;
        }
        if (object3 != null) {
            this.afInfoLog.values("androidIdCached", (String)object3);
            map.put("android_id", object3);
        } else {
            com.appsflyer.AFLogger.afInfoLog("Android ID was not collected.");
        }
        AFc1uSDK.AFa1wSDK aFa1wSDK = AFa1bSDK.AFKeystoreWrapper(this.AFInAppEventParameterName);
        if (aFa1wSDK != null) {
            object = aFa1wSDK;
            object3 = object2 = (Map)new LinkedHashMap();
            String string = "isManual";
            Object object4 = object;
            Boolean bl2 = ((AFc1uSDK.AFa1wSDK)object4).values;
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"");
            object4 = bl2;
            object3.put(string, object4);
            object3 = object2;
            string = "val";
            object4 = object;
            String string2 = ((AFc1uSDK.AFa1wSDK)object4).AFInAppEventParameterName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            object4 = string2;
            object3.put(string, object4);
            object4 = object;
            object3 = ((AFc1uSDK.AFa1wSDK)object4).AFInAppEventType;
            if (object3 != null) {
                object2.put("isLat", object3);
            }
            map.put("oaid", object2);
            return;
        }
    }

    @VisibleForTesting
    @SuppressLint(value={"PrivateApi"})
    @Nullable
    private static String AFInAppEventParameterName(String object) {
        try {
            Class[] classArray = new Class[1];
            Object[] objectArray = classArray;
            classArray[0] = String.class;
            Method method = Class.forName("android.os.SystemProperties").getMethod("get", (Class<?>[])objectArray);
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
            Object object2 = method.invoke(null, objectArray);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return (String)object2;
        }
        catch (Throwable throwable) {
            object = throwable;
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), (Throwable)object);
            return null;
        }
    }

    private static File AFInAppEventType(String object) {
        try {
            if (object != null && ((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()).length() > 0) {
                return new File(((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), (Throwable)object);
        }
        return null;
    }

    private static boolean AFKeystoreWrapper(File file) {
        return file == null || !file.exists();
    }

    /*
     * Loose catch block
     */
    private static String AFInAppEventType(File serializable, String object) {
        if (serializable == null) {
            return null;
        }
        Reader reader = null;
        Properties properties = new Properties();
        reader = new InputStreamReader((InputStream)new FileInputStream((File)serializable), Charset.defaultCharset());
        properties.load(reader);
        com.appsflyer.AFLogger.afInfoLog("Found PreInstall property!");
        object = properties.getProperty((String)object);
        try {
            reader.close();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), (Throwable)serializable);
        }
        return object;
        catch (FileNotFoundException fileNotFoundException) {
            com.appsflyer.AFLogger.afDebugLog("PreInstall file wasn't found: " + serializable.getAbsolutePath());
            try {
                Reader reader2 = reader;
                if (reader2 != null) {
                    reader2.close();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable2);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            com.appsflyer.AFLogger.afErrorLog(throwable.getMessage(), throwable3);
            {
                catch (Throwable throwable4) {
                    try {
                        Reader reader3 = reader;
                        if (reader3 != null) {
                            reader3.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        object = throwable5;
                        com.appsflyer.AFLogger.afErrorLog(throwable5.getMessage(), (Throwable)object);
                    }
                    throw throwable4;
                }
            }
            try {
                Reader reader4 = reader;
                if (reader4 != null) {
                    reader4.close();
                }
            }
            catch (Throwable throwable6) {
                throwable3 = throwable6;
                com.appsflyer.AFLogger.afErrorLog(throwable6.getMessage(), throwable3);
            }
        }
        return null;
    }

    private boolean afRDLog() {
        block3: {
            block2: {
                AppsFlyerProperties appsFlyerProperties = AppsFlyerProperties.getInstance();
                if (appsFlyerProperties.getBoolean("collectAndroidIdForceByUser", false) || appsFlyerProperties.getBoolean("collectIMEIForceByUser", false)) break block2;
                AFa1dSDK.valueOf();
                if (AFa1dSDK.AFKeystoreWrapper(this.AFInAppEventParameterName)) break block3;
            }
            return true;
        }
        return false;
    }
}

