/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer;

import android.util.Log;
import androidx.annotation.NonNull;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.internal.AFa1dSDK;

public class AFLogger {
    private static final long AFInAppEventParameterName = System.currentTimeMillis();

    public static void afInfoLog(String string, boolean bl) {
        if (AFLogger.AFKeystoreWrapper(LogLevel.INFO)) {
            Log.i((String)"AppsFlyer_6.12.1", (String)AFLogger.AFKeystoreWrapper(string, false));
        }
        if (bl) {
            AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventType("I", AFLogger.AFKeystoreWrapper(string, true));
        }
    }

    @NonNull
    private static String AFKeystoreWrapper(String string, boolean bl) {
        if (string == null) {
            string = "null";
        }
        if (bl || LogLevel.VERBOSE.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel())) {
            return "(" + (System.currentTimeMillis() - AFInAppEventParameterName) + ") [" + Thread.currentThread().getName() + "] " + string;
        }
        return string;
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2, boolean bl3) {
        if (string == null) {
            string = throwable.getClass().getSimpleName() + " at " + ((Object)throwable.getStackTrace()[0]).toString();
        }
        if (AFLogger.AFKeystoreWrapper(LogLevel.ERROR)) {
            String string2 = AFLogger.AFKeystoreWrapper(string, false);
            if (bl2) {
                Log.e((String)"AppsFlyer_6.12.1", (String)string2, (Throwable)throwable);
            } else if (bl) {
                Log.d((String)"AppsFlyer_6.12.1", (String)string2);
            }
        }
        AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventParameterName(throwable);
        if (bl3) {
            AFa1dSDK.valueOf().AFInAppEventParameterName().onResponseErrorNative().values(throwable, string);
        }
    }

    public static void AFInAppEventType(String string) {
        if (AFLogger.AFKeystoreWrapper(LogLevel.WARNING)) {
            Log.w((String)"AppsFlyer_6.12.1", (String)AFLogger.AFKeystoreWrapper(string, false));
        }
        AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventType("W", AFLogger.AFKeystoreWrapper(string, true));
    }

    public static void afRDLog(String string) {
        if (AFLogger.AFKeystoreWrapper(LogLevel.VERBOSE)) {
            Log.v((String)"AppsFlyer_6.12.1", (String)AFLogger.AFKeystoreWrapper(string, false));
        }
        AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventType("V", AFLogger.AFKeystoreWrapper(string, true));
    }

    private static boolean AFKeystoreWrapper(LogLevel logLevel) {
        return logLevel.getLevel() <= AppsFlyerProperties.getInstance().getInt("logLevel", LogLevel.NONE.getLevel());
    }

    public static void AFInAppEventParameterName(String string) {
        if (!AFLogger.valueOf()) {
            Log.d((String)"AppsFlyer_6.12.1", (String)AFLogger.AFKeystoreWrapper(string, false));
        }
        AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventType("F", string);
    }

    private static boolean valueOf() {
        return AppsFlyerProperties.getInstance().isLogsDisabledCompletely();
    }

    public static void afDebugLog(String string) {
        if (AFLogger.AFKeystoreWrapper(LogLevel.DEBUG)) {
            Log.d((String)"AppsFlyer_6.12.1", (String)AFLogger.AFKeystoreWrapper(string, false));
        }
        AFa1dSDK.valueOf().AFInAppEventParameterName().afErrorLogForExcManagerOnly().AFInAppEventType("D", AFLogger.AFKeystoreWrapper(string, true));
    }

    public static void afInfoLog(String string) {
        AFLogger.afInfoLog(string, true);
    }

    public static void afErrorLog(String string, Throwable throwable) {
        AFLogger.afErrorLog(string, throwable, true, false, true);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly(string, throwable, false);
    }

    public static void afErrorLogForExcManagerOnly(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, false, false, !bl);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl) {
        AFLogger.afErrorLog(string, throwable, true, bl, true);
    }

    public static void afErrorLog(String string, Throwable throwable, boolean bl, boolean bl2) {
        AFLogger.afErrorLog(string, throwable, true, bl, bl2);
    }

    @Deprecated
    public static void afErrorLog(Throwable throwable) {
        AFLogger.afErrorLogForExcManagerOnly("Unknown", throwable);
    }

    public static void afWarnLog(String string) {
        AFLogger.AFInAppEventType(string);
    }

    public static enum LogLevel {
        NONE(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5);

        private int values;

        private LogLevel(int n2) {
            this.values = n2;
        }

        public final int getLevel() {
            return this.values;
        }
    }
}

