/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast;

import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.annotations.ApolloInternal;
import com.apollographql.apollo.ast.ApolloParser;
import com.apollographql.apollo.ast.ConflictResolution;
import com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.ast.GQLDirectiveDefinition;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.GQLNamed;
import com.apollographql.apollo.ast.GQLNode;
import com.apollographql.apollo.ast.GQLResult;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.MergeOptions;
import com.apollographql.apollo.ast.SDLWriter;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.ast.SourceLocation;
import com.apollographql.apollo.ast.internal.DefinitionsKt;
import com.apollographql.apollo.ast.internal.ExtensionsMerger;
import com.apollographql.apollo.ast.internal.SchemaValidationScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t*\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0010\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0010\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a2\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010 \u001a\u00020!H\u0000\u001a\u001a\u0010\"\u001a\u00020\u0001*\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0016\u0010#\u001a\u00020\u0010*\u00020\u00012\b\b\u0002\u0010$\u001a\u00020\u0010H\u0007\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0011\u001a\u00020\u00108\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013\"\u0016\u0010\u0016\u001a\u00020\u00108\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0013\u00a8\u0006%"}, d2={"withBuiltinDefinitions", "Lcom/apollographql/apollo/ast/GQLDocument;", "toFullSchemaGQLDocument", "toSchema", "Lcom/apollographql/apollo/ast/Schema;", "toMergedGQLDocument", "mergeOptions", "Lcom/apollographql/apollo/ast/MergeOptions;", "mergeExtensions", "Lcom/apollographql/apollo/ast/GQLResult;", "withoutBuiltinDefinitions", "builtinDefinitions", "", "Lcom/apollographql/apollo/ast/GQLDefinition;", "linkDefinitions", "KOTLIN_LABS_VERSION_0_2", "", "KOTLIN_LABS_VERSION", "getKOTLIN_LABS_VERSION$annotations", "()V", "kotlinLabsDefinitions", "version", "NULLABILITY_VERSION", "getNULLABILITY_VERSION$annotations", "nullabilityDefinitions", "definitionsFromString", "string", "withoutDefinitions", "definitions", "combineDefinitions", "left", "right", "conflictResolution", "Lcom/apollographql/apollo/ast/ConflictResolution;", "withDefinitions", "toSDL", "indent", "apollo-ast"})
@SourceDebugExtension(value={"SMAP\ngqldocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 gqldocument.kt\ncom/apollographql/apollo/ast/GqldocumentKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1557#2:213\n1628#2,3:214\n774#2:217\n865#2,2:218\n1863#2:220\n295#2,2:221\n1864#2:223\n1872#2,3:224\n*S KotlinDebug\n*F\n+ 1 gqldocument.kt\ncom/apollographql/apollo/ast/GqldocumentKt\n*L\n117#1:213\n117#1:214,3\n123#1:217\n123#1:218,2\n153#1:220\n157#1:221,2\n153#1:223\n190#1:224,3\n*E\n"})
public final class GqldocumentKt {
    @NotNull
    private static final String KOTLIN_LABS_VERSION_0_2 = "v0.2";
    @NotNull
    public static final String KOTLIN_LABS_VERSION = "v0.3";
    @NotNull
    public static final String NULLABILITY_VERSION = "v0.4";

    @NotNull
    public static final GQLDocument withBuiltinDefinitions(@NotNull GQLDocument $this$withBuiltinDefinitions) {
        Intrinsics.checkNotNullParameter((Object)$this$withBuiltinDefinitions, (String)"<this>");
        return GqldocumentKt.withDefinitions($this$withBuiltinDefinitions, GqldocumentKt.builtinDefinitions());
    }

    @ApolloExperimental
    @NotNull
    public static final GQLDocument toFullSchemaGQLDocument(@NotNull GQLDocument $this$toFullSchemaGQLDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$toFullSchemaGQLDocument, (String)"<this>");
        return GqldocumentKt.toMergedGQLDocument$default(GqldocumentKt.withDefinitions(SchemaValidationScopeKt.ensureSchemaDefinition($this$toFullSchemaGQLDocument), GqldocumentKt.builtinDefinitions()), null, 1, null);
    }

    @NotNull
    public static final Schema toSchema(@NotNull GQLDocument $this$toSchema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSchema, (String)"<this>");
        return ApolloParser.validateAsSchema($this$toSchema).getOrThrow();
    }

    @ApolloExperimental
    @NotNull
    public static final GQLDocument toMergedGQLDocument(@NotNull GQLDocument $this$toMergedGQLDocument, @NotNull MergeOptions mergeOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$toMergedGQLDocument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mergeOptions, (String)"mergeOptions");
        return GqldocumentKt.mergeExtensions($this$toMergedGQLDocument, mergeOptions).getOrThrow();
    }

    public static /* synthetic */ GQLDocument toMergedGQLDocument$default(GQLDocument gQLDocument, MergeOptions mergeOptions, int n, Object object) {
        if ((n & 1) != 0) {
            mergeOptions = MergeOptions.Companion.getDefault();
        }
        return GqldocumentKt.toMergedGQLDocument(gQLDocument, mergeOptions);
    }

    @ApolloExperimental
    @NotNull
    public static final GQLResult<GQLDocument> mergeExtensions(@NotNull GQLDocument $this$mergeExtensions, @NotNull MergeOptions mergeOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$mergeExtensions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mergeOptions, (String)"mergeOptions");
        GQLResult<List<GQLDefinition>> result = new ExtensionsMerger($this$mergeExtensions.getDefinitions(), mergeOptions).merge();
        List list = result.getValue();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return new GQLResult<GQLDocument>(new GQLDocument(list, null), result.getIssues());
    }

    public static /* synthetic */ GQLResult mergeExtensions$default(GQLDocument gQLDocument, MergeOptions mergeOptions, int n, Object object) {
        if ((n & 1) != 0) {
            mergeOptions = MergeOptions.Companion.getDefault();
        }
        return GqldocumentKt.mergeExtensions(gQLDocument, mergeOptions);
    }

    @Deprecated(message="Use GQLDocument.toSDL() to write a GQLDocument")
    @NotNull
    public static final GQLDocument withoutBuiltinDefinitions(@NotNull GQLDocument $this$withoutBuiltinDefinitions) {
        Intrinsics.checkNotNullParameter((Object)$this$withoutBuiltinDefinitions, (String)"<this>");
        return GqldocumentKt.withoutDefinitions($this$withoutBuiltinDefinitions, GqldocumentKt.builtinDefinitions());
    }

    @NotNull
    public static final List<GQLDefinition> builtinDefinitions() {
        return GqldocumentKt.definitionsFromString(DefinitionsKt.getBuiltinsDefinitionsStr());
    }

    @NotNull
    public static final List<GQLDefinition> linkDefinitions() {
        return GqldocumentKt.definitionsFromString(DefinitionsKt.getLinkDefinitionsStr());
    }

    @ApolloInternal
    public static /* synthetic */ void getKOTLIN_LABS_VERSION$annotations() {
    }

    @NotNull
    public static final List<GQLDefinition> kotlinLabsDefinitions(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String string = version;
        if (!Intrinsics.areEqual((Object)string, (Object)KOTLIN_LABS_VERSION_0_2) && !Intrinsics.areEqual((Object)string, (Object)KOTLIN_LABS_VERSION)) {
            throw new IllegalStateException(("kotlin_labs/" + version + " definitions are not supported, please use v0.3").toString());
        }
        return GqldocumentKt.definitionsFromString(DefinitionsKt.getKotlinLabsDefinitions());
    }

    @ApolloInternal
    public static /* synthetic */ void getNULLABILITY_VERSION$annotations() {
    }

    @NotNull
    public static final List<GQLDefinition> nullabilityDefinitions(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!Intrinsics.areEqual((Object)version, (Object)NULLABILITY_VERSION)) {
            throw new IllegalStateException(("nullability/" + version + " definitions are not supported, please use v0.4").toString());
        }
        return GqldocumentKt.definitionsFromString(DefinitionsKt.getNullabilityDefinitionsStr());
    }

    private static final List<GQLDefinition> definitionsFromString(String string) {
        return ((GQLDocument)ApolloParser.parseAsGQLDocument$default(string, null, 1, null).getOrThrow()).getDefinitions();
    }

    /*
     * WARNING - void declaration
     */
    private static final GQLDocument withoutDefinitions(GQLDocument $this$withoutDefinitions, List<? extends GQLDefinition> definitions) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        GQLDefinition it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = definitions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GQLDefinition gQLDefinition = (GQLDefinition)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            if (!(it instanceof GQLNamed)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            object.add(((GQLNamed)((Object)it)).getName());
        }
        Set excludedNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = $this$withoutDefinitions.getDefinitions();
        object = $this$withoutDefinitions;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GQLDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof GQLNamed) ? true : !excludedNames.contains(((GQLNamed)((Object)it)).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return GQLDocument.copy$default((GQLDocument)object, (List)destination$iv$iv, null, 2, null);
    }

    @NotNull
    public static final List<GQLDefinition> combineDefinitions(@NotNull List<? extends GQLDefinition> left, @NotNull List<? extends GQLDefinition> right, @NotNull ConflictResolution conflictResolution) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)((Object)conflictResolution), (String)"conflictResolution");
        List mergedDefinitions = CollectionsKt.toMutableList((Collection)left);
        Iterable $this$forEach$iv = right;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v1;
            GQLDefinition builtInTypeDefinition;
            block4: {
                builtInTypeDefinition = (GQLDefinition)element$iv;
                boolean bl = false;
                if (!(builtInTypeDefinition instanceof GQLNamed)) {
                    boolean $i$a$-check-GqldocumentKt$combineDefinitions$1$22 = false;
                    String $i$a$-check-GqldocumentKt$combineDefinitions$1$22 = "only extra named definitions are supported";
                    throw new IllegalStateException($i$a$-check-GqldocumentKt$combineDefinitions$1$22.toString());
                }
                Iterable $this$firstOrNull$iv = mergedDefinitions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GQLDefinition it = (GQLDefinition)element$iv2;
                    boolean bl2 = false;
                    GQLNamed gQLNamed = it instanceof GQLNamed ? (GQLNamed)((Object)it) : null;
                    if (!Intrinsics.areEqual((Object)(gQLNamed != null ? gQLNamed.getName() : null), (Object)((GQLNamed)((Object)builtInTypeDefinition)).getName())) continue;
                    v1 = element$iv2;
                    break block4;
                }
                v1 = null;
            }
            GQLDefinition existingDefinition = v1;
            if (existingDefinition != null) {
                if (conflictResolution != ConflictResolution.Error) continue;
                SourceLocation sourceLocation = existingDefinition.getSourceLocation();
                String string = "Apollo: definition '" + ((GQLNamed)((Object)builtInTypeDefinition)).getName() + "' is already in the schema at '" + (sourceLocation != null ? sourceLocation.getFilePath() : null) + ':' + existingDefinition.getSourceLocation() + '\'';
                throw new IllegalStateException(string.toString());
            }
            mergedDefinitions.add(builtInTypeDefinition);
        }
        return mergedDefinitions;
    }

    private static final GQLDocument withDefinitions(GQLDocument $this$withDefinitions, List<? extends GQLDefinition> definitions) {
        return GQLDocument.copy$default($this$withDefinitions, GqldocumentKt.combineDefinitions($this$withDefinitions.getDefinitions(), definitions, ConflictResolution.TakeLeft), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @ApolloExperimental
    @NotNull
    public static final String toSDL(@NotNull GQLDocument $this$toSDL, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)$this$toSDL, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Buffer buffer = new Buffer();
        SDLWriter writer = new SDLWriter((BufferedSink)buffer, indent);
        Iterable $this$forEachIndexed$iv = $this$toSDL.getDefinitions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void definition;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GQLDefinition gQLDefinition = (GQLDefinition)item$iv;
            int index = n;
            boolean bl = false;
            if (definition instanceof GQLScalarTypeDefinition && GQLTypeDefinition.Companion.getBuiltInTypes().contains(((GQLScalarTypeDefinition)definition).getName())) continue;
            if (definition instanceof GQLTypeDefinition && GQLTypeDefinition.Companion.getBuiltInTypes().contains(((GQLTypeDefinition)definition).getName()) || definition instanceof GQLDirectiveDefinition && GQLDirectiveDefinition.Companion.getBuiltInDirectives().contains(((GQLDirectiveDefinition)definition).getName())) {
                writer.write((GQLNode)definition);
            } else {
                writer.write((GQLNode)definition);
            }
            if (index >= $this$toSDL.getDefinitions().size() - 1) continue;
            writer.write("\n");
        }
        return buffer.readUtf8();
    }

    public static /* synthetic */ String toSDL$default(GQLDocument gQLDocument, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "  ";
        }
        return GqldocumentKt.toSDL(gQLDocument, string);
    }
}

