/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.json;

import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.internal.JsonScope;
import com.apollographql.apollo.exception.JsonDataException;
import com.apollographql.apollo.exception.JsonEncodingException;
import java.io.EOFException;
import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 H2\u00020\u0001:\u0001HB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\b\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\tH\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u000eH\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u000eH\u0002J\u0010\u00104\u001a\u0002052\u0006\u00101\u001a\u000202H\u0002J\b\u00106\u001a\u000205H\u0002J\b\u00107\u001a\u00020\tH\u0016J\b\u00108\u001a\u000205H\u0016J\b\u00109\u001a\u000205H\u0016J\u0016\u0010:\u001a\u00020\t2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000e0<H\u0016J\u0010\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020\tH\u0002J\u0010\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u00020\u001dH\u0002J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020B0<H\u0016J\b\u0010C\u001a\u00020\u000eH\u0002J\b\u0010D\u001a\u00020%H\u0002J\b\u0010E\u001a\u000205H\u0016J\u0010\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/apollographql/apollo/api/json/BufferedSourceJsonReader;", "Lcom/apollographql/apollo/api/json/JsonReader;", "source", "Lokio/BufferedSource;", "<init>", "(Lokio/BufferedSource;)V", "buffer", "Lokio/Buffer;", "peeked", "", "peekedLong", "", "peekedNumberLength", "peekedString", "", "stack", "", "stackSize", "pathNames", "", "[Ljava/lang/String;", "pathIndices", "indexStack", "indexStackSize", "beginArray", "endArray", "beginObject", "endObject", "hasNext", "", "peek", "Lcom/apollographql/apollo/api/json/JsonReader$Token;", "doPeek", "peekKeyword", "peekNumber", "isLiteral", "c", "", "nextName", "nextString", "nextBoolean", "nextNull", "", "nextDouble", "", "nextLong", "nextNumber", "Lcom/apollographql/apollo/api/json/JsonNumber;", "nextQuotedValue", "runTerminator", "Lokio/ByteString;", "nextUnquotedValue", "skipQuotedValue", "", "skipUnquotedValue", "nextInt", "close", "skipValue", "selectName", "names", "", "push", "newTop", "nextNonWhitespace", "throwOnEof", "getPath", "", "getPathAsString", "readEscapeCharacter", "rewind", "throwSyntaxError", "message", "Companion", "apollo-api"})
@SourceDebugExtension(value={"SMAP\nBufferedSourceJsonReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BufferedSourceJsonReader.kt\ncom/apollographql/apollo/api/json/BufferedSourceJsonReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,894:1\n1#2:895\n*E\n"})
public final class BufferedSourceJsonReader
implements JsonReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final Buffer buffer;
    private int peeked;
    private long peekedLong;
    private int peekedNumberLength;
    @Nullable
    private String peekedString;
    @NotNull
    private int[] stack;
    private int stackSize;
    @NotNull
    private String[] pathNames;
    @NotNull
    private int[] pathIndices;
    @NotNull
    private int[] indexStack;
    private int indexStackSize;
    private static final long MIN_INCOMPLETE_INTEGER = -922337203685477580L;
    @NotNull
    private static final ByteString SINGLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("'\\");
    @NotNull
    private static final ByteString DOUBLE_QUOTE_OR_SLASH = ByteString.Companion.encodeUtf8("\"\\");
    @NotNull
    private static final ByteString UNQUOTED_STRING_TERMINALS = ByteString.Companion.encodeUtf8("{}[]:, \n\t\r/\\;#=");
    private static final int PEEKED_NONE = 0;
    private static final int PEEKED_BEGIN_OBJECT = 1;
    private static final int PEEKED_END_OBJECT = 2;
    private static final int PEEKED_BEGIN_ARRAY = 3;
    private static final int PEEKED_END_ARRAY = 4;
    private static final int PEEKED_TRUE = 5;
    private static final int PEEKED_FALSE = 6;
    private static final int PEEKED_NULL = 7;
    private static final int PEEKED_SINGLE_QUOTED = 8;
    private static final int PEEKED_DOUBLE_QUOTED = 9;
    private static final int PEEKED_UNQUOTED = 10;
    private static final int PEEKED_BUFFERED = 11;
    private static final int PEEKED_SINGLE_QUOTED_NAME = 12;
    private static final int PEEKED_DOUBLE_QUOTED_NAME = 13;
    private static final int PEEKED_UNQUOTED_NAME = 14;
    private static final int PEEKED_LONG = 15;
    private static final int PEEKED_NUMBER = 16;
    private static final int PEEKED_EOF = 17;
    private static final int NUMBER_CHAR_NONE = 0;
    private static final int NUMBER_CHAR_SIGN = 1;
    private static final int NUMBER_CHAR_DIGIT = 2;
    private static final int NUMBER_CHAR_DECIMAL = 3;
    private static final int NUMBER_CHAR_FRACTION_DIGIT = 4;
    private static final int NUMBER_CHAR_EXP_E = 5;
    private static final int NUMBER_CHAR_EXP_SIGN = 6;
    private static final int NUMBER_CHAR_EXP_DIGIT = 7;
    public static final int INITIAL_STACK_SIZE = 64;

    public BufferedSourceJsonReader(@NotNull BufferedSource source) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.buffer = this.source.getBuffer();
        int[] nArray2 = nArray = new int[64];
        BufferedSourceJsonReader bufferedSourceJsonReader = this;
        boolean bl = false;
        $this$stack_u24lambda_u240[0] = 6;
        bufferedSourceJsonReader.stack = nArray;
        this.stackSize = 1;
        this.pathNames = new String[64];
        this.pathIndices = new int[64];
        int[] $this$stack_u24lambda_u240 = nArray = new int[64];
        bufferedSourceJsonReader = this;
        boolean bl2 = false;
        $this$indexStack_u24lambda_u241[0] = false;
        bufferedSourceJsonReader.indexStack = nArray;
        this.indexStackSize = 1;
    }

    @Override
    @NotNull
    public JsonReader beginArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginArray_u24lambda_u243 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginArray_u24lambda_u243.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginArray_u24lambda_u243.doPeek();
        if (p != 3) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u243.peek()) + " at path " + $this$beginArray_u24lambda_u243.getPathAsString());
        }
        $this$beginArray_u24lambda_u243.push(1);
        $this$beginArray_u24lambda_u243.pathIndices[$this$beginArray_u24lambda_u243.stackSize - 1] = 0;
        $this$beginArray_u24lambda_u243.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endArray() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endArray_u24lambda_u245 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endArray_u24lambda_u245.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endArray_u24lambda_u245.doPeek();
        if (p != 4) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u245.peek()) + " at path " + $this$endArray_u24lambda_u245.getPathAsString());
        }
        int n4 = $this$endArray_u24lambda_u245.stackSize;
        $this$endArray_u24lambda_u245.stackSize = n4 + -1;
        int[] nArray = $this$endArray_u24lambda_u245.pathIndices;
        int n5 = $this$endArray_u24lambda_u245.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endArray_u24lambda_u245.peeked = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader beginObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$beginObject_u24lambda_u247 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$beginObject_u24lambda_u247.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$beginObject_u24lambda_u247.doPeek();
        if (p != 1) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u247.peek()) + " at path " + $this$beginObject_u24lambda_u247.getPathAsString());
        }
        $this$beginObject_u24lambda_u247.push(3);
        $this$beginObject_u24lambda_u247.peeked = 0;
        int n4 = $this$beginObject_u24lambda_u247.indexStackSize;
        $this$beginObject_u24lambda_u247.indexStackSize = n4 + 1;
        $this$beginObject_u24lambda_u247.indexStack[$this$beginObject_u24lambda_u247.indexStackSize - 1] = 0;
        return bufferedSourceJsonReader;
    }

    @Override
    @NotNull
    public JsonReader endObject() {
        int p;
        BufferedSourceJsonReader bufferedSourceJsonReader;
        BufferedSourceJsonReader $this$endObject_u24lambda_u249 = bufferedSourceJsonReader = this;
        boolean bl = false;
        Integer n = $this$endObject_u24lambda_u249.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        int n3 = p = n2 != null ? n2.intValue() : $this$endObject_u24lambda_u249.doPeek();
        if (p != 2) {
            throw new JsonDataException("Expected END_OBJECT but was " + (Object)((Object)$this$endObject_u24lambda_u249.peek()) + " at path " + $this$endObject_u24lambda_u249.getPathAsString());
        }
        int n4 = $this$endObject_u24lambda_u249.stackSize;
        $this$endObject_u24lambda_u249.stackSize = n4 + -1;
        $this$endObject_u24lambda_u249.pathNames[$this$endObject_u24lambda_u249.stackSize] = null;
        int[] nArray = $this$endObject_u24lambda_u249.pathIndices;
        int n5 = $this$endObject_u24lambda_u249.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        $this$endObject_u24lambda_u249.peeked = 0;
        int n7 = $this$endObject_u24lambda_u249.indexStackSize;
        $this$endObject_u24lambda_u249.indexStackSize = n7 + -1;
        return bufferedSourceJsonReader;
    }

    @Override
    public boolean hasNext() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        return p != 2 && p != 4;
    }

    @Override
    @NotNull
    public JsonReader.Token peek() {
        JsonReader.Token token;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 1: {
                token = JsonReader.Token.BEGIN_OBJECT;
                break;
            }
            case 2: {
                token = JsonReader.Token.END_OBJECT;
                break;
            }
            case 3: {
                token = JsonReader.Token.BEGIN_ARRAY;
                break;
            }
            case 4: {
                token = JsonReader.Token.END_ARRAY;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                token = JsonReader.Token.NAME;
                break;
            }
            case 5: 
            case 6: {
                token = JsonReader.Token.BOOLEAN;
                break;
            }
            case 7: {
                token = JsonReader.Token.NULL;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                token = JsonReader.Token.STRING;
                break;
            }
            case 15: {
                token = JsonReader.Token.LONG;
                break;
            }
            case 16: {
                token = JsonReader.Token.NUMBER;
                break;
            }
            case 17: {
                token = JsonReader.Token.END_DOCUMENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return token;
    }

    private final int doPeek() {
        int peekStack = this.stack[this.stackSize - 1];
        block0 : switch (peekStack) {
            case 1: {
                this.stack[this.stackSize - 1] = 2;
                break;
            }
            case 2: {
                int c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                switch ((char)c) {
                    case ']': {
                        int n;
                        int it = n = 4;
                        boolean bl = false;
                        this.peeked = it;
                        return n;
                    }
                    case ',': {
                        break block0;
                    }
                }
                this.throwSyntaxError("Unterminated array");
                throw new KotlinNothingValueException();
            }
            case 3: 
            case 5: {
                int n;
                int c;
                this.stack[this.stackSize - 1] = 4;
                if (peekStack == 5) {
                    c = this.nextNonWhitespace(true);
                    this.buffer.readByte();
                    switch ((char)c) {
                        case '}': {
                            int n2;
                            int it = n2 = 2;
                            boolean bl = false;
                            this.peeked = it;
                            return n2;
                        }
                        case ',': {
                            break;
                        }
                        default: {
                            this.throwSyntaxError("Unterminated object");
                            throw new KotlinNothingValueException();
                        }
                    }
                }
                c = this.nextNonWhitespace(true);
                switch ((char)c) {
                    case '\"': {
                        int n3;
                        this.buffer.readByte();
                        int it = n3 = 13;
                        boolean bl = false;
                        this.peeked = it;
                        n = n3;
                        break;
                    }
                    case '}': {
                        if (peekStack != 5) {
                            int n4;
                            this.buffer.readByte();
                            int it = n4 = 2;
                            boolean bl = false;
                            this.peeked = it;
                            n = n4;
                            break;
                        }
                        this.throwSyntaxError("Expected name");
                        throw new KotlinNothingValueException();
                    }
                    default: {
                        this.throwSyntaxError("Unexpected character: " + (char)c);
                        throw new KotlinNothingValueException();
                    }
                }
                return n;
            }
            case 4: {
                this.stack[this.stackSize - 1] = 5;
                int c = this.nextNonWhitespace(true);
                this.buffer.readByte();
                if ((char)c == ':') break;
                this.throwSyntaxError("Expected ':'");
                throw new KotlinNothingValueException();
            }
            case 6: {
                this.stack[this.stackSize - 1] = 7;
                break;
            }
            case 7: {
                int c = this.nextNonWhitespace(false);
                if (c == -1) {
                    int n;
                    int it = n = 17;
                    boolean bl = false;
                    this.peeked = it;
                    return n;
                }
                this.throwSyntaxError("Malformed JSON");
                throw new KotlinNothingValueException();
            }
            default: {
                if (peekStack != 8) break;
                boolean bl = false;
                String string = "JsonReader is closed";
                throw new IllegalStateException(string.toString());
            }
        }
        int c = this.nextNonWhitespace(true);
        switch ((char)c) {
            case ']': {
                if (peekStack == 1) {
                    int n;
                    this.buffer.readByte();
                    int it = n = 4;
                    boolean bl = false;
                    this.peeked = it;
                    return n;
                }
                this.throwSyntaxError("Unexpected value");
                throw new KotlinNothingValueException();
            }
            case '\'': 
            case ',': 
            case ';': {
                this.throwSyntaxError("Unexpected value");
                throw new KotlinNothingValueException();
            }
            case '\"': {
                int n;
                this.buffer.readByte();
                int it = n = 9;
                boolean bl = false;
                this.peeked = it;
                return n;
            }
            case '[': {
                int n;
                this.buffer.readByte();
                int it = n = 3;
                boolean bl = false;
                this.peeked = it;
                return n;
            }
            case '{': {
                int n;
                this.buffer.readByte();
                int it = n = 1;
                boolean bl = false;
                this.peeked = it;
                return n;
            }
        }
        int result = this.peekKeyword();
        if (result != 0) {
            return result;
        }
        result = this.peekNumber();
        if (result != 0) {
            return result;
        }
        if (!this.isLiteral((char)this.buffer.getByte(0L))) {
            this.throwSyntaxError("Expected value");
            throw new KotlinNothingValueException();
        }
        this.throwSyntaxError("Malformed JSON");
        throw new KotlinNothingValueException();
    }

    private final int peekKeyword() {
        int n;
        String keyword = null;
        String keywordUpper = null;
        int peeking = 0;
        byte by = this.buffer.getByte(0L);
        if (by == 116 || by == 84) {
            keyword = "true";
            keywordUpper = "TRUE";
            peeking = 5;
        } else if (by == 102 || by == 70) {
            keyword = "false";
            keywordUpper = "FALSE";
            peeking = 6;
        } else if (by == 110 || by == 78) {
            keyword = "null";
            keywordUpper = "NULL";
            peeking = 7;
        } else {
            return 0;
        }
        int length = keyword.length();
        for (int i = 1; i < length; ++i) {
            if (!this.source.request((long)i + 1L)) {
                return 0;
            }
            byte c = this.buffer.getByte((long)i);
            if (c == (byte)keyword.charAt(i) || c == (byte)keywordUpper.charAt(i)) continue;
            return 0;
        }
        if (this.source.request((long)length + 1L) && this.isLiteral((char)this.buffer.getByte((long)length))) {
            return 0;
        }
        this.buffer.skip((long)length);
        int it = n = peeking;
        boolean bl = false;
        this.peeked = it;
        return n;
    }

    private final int peekNumber() {
        int n;
        int n2;
        long value = 0L;
        boolean negative = false;
        boolean fitsInLong = true;
        int last = 0;
        int i = 0;
        block19: while (this.source.request((long)i + 1L)) {
            byte c = this.buffer.getByte((long)i);
            block0 : switch ((char)c) {
                case '-': {
                    switch (last) {
                        case 0: {
                            negative = true;
                            last = 1;
                            break block0;
                        }
                        case 5: {
                            last = 6;
                            break block0;
                        }
                    }
                    return 0;
                }
                case '+': {
                    if (last == 5) {
                        last = 6;
                        break;
                    }
                    return 0;
                }
                case 'E': 
                case 'e': {
                    switch (last) {
                        case 2: 
                        case 4: {
                            last = 5;
                            break block0;
                        }
                    }
                    return 0;
                }
                case '.': {
                    if (last == 2) {
                        last = 3;
                        break;
                    }
                    return 0;
                }
                default: {
                    if (c < 48 || c > 57) {
                        if (!this.isLiteral((char)c)) break block19;
                        return 0;
                    }
                    switch (last) {
                        case 0: 
                        case 1: {
                            value = -((long)(c - 48));
                            last = 2;
                            break block0;
                        }
                        case 2: {
                            if (value == 0L) {
                                return 0;
                            }
                            long newValue = value * (long)10 - (long)(c - 48);
                            fitsInLong = fitsInLong & value > -922337203685477580L || value == -922337203685477580L && newValue < value;
                            value = newValue;
                            break block0;
                        }
                        case 3: {
                            last = 4;
                            break block0;
                        }
                        case 5: 
                        case 6: {
                            last = 7;
                        }
                    }
                }
            }
            ++i;
        }
        if (last == 2 && fitsInLong && (value != Long.MIN_VALUE || negative)) {
            this.peekedLong = negative ? value : -value;
            this.buffer.skip((long)i);
            int it = n2 = 15;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        } else if (last == 2 || last == 4 || last == 7) {
            this.peekedNumberLength = i;
            int it = n2 = 16;
            boolean bl = false;
            this.peeked = it;
            n = n2;
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isLiteral(char c) {
        boolean bl;
        switch (c) {
            case '#': 
            case '/': 
            case ';': 
            case '=': 
            case '\\': {
                this.throwSyntaxError("Unexpected character: " + c);
                throw new KotlinNothingValueException();
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String nextName() {
        String string;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 14: {
                string = this.nextUnquotedValue();
                break;
            }
            case 13: {
                string = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 12: {
                string = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            default: {
                throw new JsonDataException("Expected a name but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result = string;
        this.peeked = 0;
        this.pathNames[this.stackSize - 1] = result;
        return result;
    }

    @Override
    @Nullable
    public String nextString() {
        Object object;
        Object object2 = this.peeked;
        int it = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it == 0) ? object2 : null;
        switch (object3 != null ? ((Integer)object3).intValue() : this.doPeek()) {
            case 10: {
                object = this.nextUnquotedValue();
                break;
            }
            case 9: {
                object = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                break;
            }
            case 8: {
                object = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
                break;
            }
            case 11: {
                String string = this.peekedString;
                if (string != null) {
                    Object it2 = object2 = string;
                    boolean bl2 = false;
                    this.peekedString = null;
                    object = object2;
                    break;
                }
                object = null;
                break;
            }
            case 15: {
                object = String.valueOf(this.peekedLong);
                break;
            }
            case 16: {
                object = this.buffer.readUtf8((long)this.peekedNumberLength);
                break;
            }
            default: {
                throw new JsonDataException("Expected a string but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        String result = object;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result;
    }

    @Override
    public boolean nextBoolean() {
        boolean bl;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl2 = false;
        Integer n2 = !(it == 0) ? n : null;
        switch (n2 != null ? n2.intValue() : this.doPeek()) {
            case 5: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n3 = this.stackSize - 1;
                int n4 = nArray[n3];
                nArray[n3] = n4 + 1;
                bl = true;
                break;
            }
            case 6: {
                this.peeked = 0;
                int[] nArray = this.pathIndices;
                int n5 = this.stackSize - 1;
                int n4 = nArray[n5];
                nArray[n5] = n4 + 1;
                bl = false;
                break;
            }
            default: {
                throw new JsonDataException("Expected a boolean but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public Void nextNull() {
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        if ((n2 != null ? n2.intValue() : this.doPeek()) != 7) {
            throw new JsonDataException("Expected null but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n3 = this.stackSize - 1;
        int n4 = nArray[n3];
        nArray[n3] = n4 + 1;
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        Integer n = this.peeked;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            int n4 = nArray[n3];
            nArray[n3] = n4 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9) {
            this.peekedString = this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH);
        } else if (p == 8) {
            this.peekedString = this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
        } else if (p == 10) {
            this.peekedString = this.nextUnquotedValue();
        } else if (p != 11) {
            throw new JsonDataException("Expected a double but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a double but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double result = d;
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            throw new JsonEncodingException("JSON forbids NaN and infinities: " + result + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n5 = this.stackSize - 1;
        int n6 = nArray[n5];
        nArray[n5] = n6 + 1;
        return result;
    }

    @Override
    public long nextLong() {
        double it22;
        Integer n = this.peeked;
        int it22 = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it22 == 0) ? n : null;
        int p = n2 != null ? n2.intValue() : this.doPeek();
        if (p == 15) {
            this.peeked = 0;
            int[] nArray = this.pathIndices;
            int n3 = this.stackSize - 1;
            it22 = nArray[n3];
            nArray[n3] = it22 + 1;
            return this.peekedLong;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull((Object)string);
                long result = Long.parseLong(string);
                this.peeked = 0;
                int[] it22 = this.pathIndices;
                int n4 = this.stackSize - 1;
                int n5 = it22[n4];
                it22[n4] = n5 + 1;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected a long but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            it22 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it22;
        long result = (long)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected a long but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n6 = this.stackSize - 1;
        int n7 = nArray[n6];
        nArray[n6] = n7 + 1;
        return result;
    }

    @Override
    @NotNull
    public JsonNumber nextNumber() {
        String string = this.nextString();
        Intrinsics.checkNotNull((Object)string);
        return new JsonNumber(string);
    }

    private final String nextQuotedValue(ByteString runTerminator) {
        String string;
        long index;
        StringBuilder builder = null;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                this.throwSyntaxError("Unterminated string");
                throw new KotlinNothingValueException();
            }
            if (this.buffer.getByte(index) != 92) break;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            builder.append(this.readEscapeCharacter());
        }
        if (builder == null) {
            String result = this.buffer.readUtf8(index);
            this.buffer.readByte();
            string = result;
        } else {
            builder.append(this.buffer.readUtf8(index));
            this.buffer.readByte();
            String string2 = builder.toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        return string;
    }

    private final String nextUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        return i != -1L ? this.buffer.readUtf8(i) : this.buffer.readUtf8();
    }

    private final void skipQuotedValue(ByteString runTerminator) {
        long index;
        while (true) {
            if ((index = this.source.indexOfElement(runTerminator)) == -1L) {
                this.throwSyntaxError("Unterminated string");
                throw new KotlinNothingValueException();
            }
            if (this.buffer.getByte(index) != 92) break;
            this.buffer.skip(index + 1L);
            this.readEscapeCharacter();
        }
        this.buffer.skip(index + 1L);
    }

    private final void skipUnquotedValue() {
        long i = this.source.indexOfElement(UNQUOTED_STRING_TERMINALS);
        this.buffer.skip(i != -1L ? i : this.buffer.size());
    }

    @Override
    public int nextInt() {
        double it2;
        Object object;
        Object object2 = this.peeked;
        int it2 = ((Number)object2).intValue();
        boolean bl = false;
        Object object3 = !(it2 == 0) ? object2 : null;
        int p = object3 != null ? ((Integer)object3).intValue() : this.doPeek();
        if (p == 15) {
            int result = (int)this.peekedLong;
            if (this.peekedLong != (long)result) {
                throw new JsonDataException("Expected an int but was " + this.peekedLong + " at path " + this.getPath());
            }
            this.peeked = 0;
            object2 = this.pathIndices;
            it2 = this.stackSize - 1;
            object = object2[it2];
            object2[it2] = object + true;
            return result;
        }
        if (p == 16) {
            this.peekedString = this.buffer.readUtf8((long)this.peekedNumberLength);
        } else if (p == 9 || p == 8) {
            this.peekedString = p == 9 ? this.nextQuotedValue(DOUBLE_QUOTE_OR_SLASH) : this.nextQuotedValue(SINGLE_QUOTE_OR_SLASH);
            try {
                String string = this.peekedString;
                Intrinsics.checkNotNull((Object)string);
                int result = Integer.parseInt(string);
                this.peeked = 0;
                object2 = this.pathIndices;
                it2 = this.stackSize - 1;
                object = object2[it2];
                object2[it2] = object + true;
                return result;
            }
            catch (NumberFormatException result) {}
        } else if (p != 11) {
            throw new JsonDataException("Expected an int but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.peeked = 11;
        try {
            String string = this.peekedString;
            Intrinsics.checkNotNull((Object)string);
            it2 = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        double asDouble = it2;
        int result = (int)asDouble;
        if (!((double)result == asDouble)) {
            throw new JsonDataException("Expected an int but was " + this.peekedString + " at path " + this.getPathAsString());
        }
        this.peekedString = null;
        this.peeked = 0;
        int[] nArray = this.pathIndices;
        int n = this.stackSize - 1;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return result;
    }

    @Override
    public void close() {
        this.peeked = 0;
        this.stack[0] = 8;
        this.stackSize = 1;
        this.buffer.clear();
        this.source.close();
    }

    @Override
    public void skipValue() {
        int n;
        int count = 0;
        do {
            Integer n2 = this.peeked;
            int it = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = !(it == 0) ? n2 : null;
            switch (n3 != null ? n3.intValue() : this.doPeek()) {
                case 3: {
                    this.push(1);
                    ++count;
                    break;
                }
                case 1: {
                    this.push(3);
                    ++count;
                    break;
                }
                case 4: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 2: {
                    n = this.stackSize;
                    this.stackSize = n + -1;
                    --count;
                    break;
                }
                case 10: 
                case 14: {
                    this.skipUnquotedValue();
                    break;
                }
                case 9: 
                case 13: {
                    this.skipQuotedValue(DOUBLE_QUOTE_OR_SLASH);
                    break;
                }
                case 8: 
                case 12: {
                    this.skipQuotedValue(SINGLE_QUOTE_OR_SLASH);
                    break;
                }
                case 16: {
                    this.buffer.skip((long)this.peekedNumberLength);
                }
            }
            this.peeked = 0;
        } while (count != 0);
        int[] nArray = this.pathIndices;
        n = this.stackSize - 1;
        int n4 = nArray[n];
        nArray[n] = n4 + 1;
        this.pathNames[this.stackSize - 1] = "null";
    }

    @Override
    public int selectName(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        if (names.isEmpty()) {
            return -1;
        }
        while (this.hasNext()) {
            block7: {
                int n;
                String name = this.nextName();
                int expectedIndex = this.indexStack[this.indexStackSize - 1];
                if (Intrinsics.areEqual((Object)names.get(expectedIndex), (Object)name)) {
                    int n2;
                    int it = n2 = expectedIndex;
                    boolean bl = false;
                    this.indexStack[this.indexStackSize - 1] = expectedIndex + 1;
                    if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                        this.indexStack[this.indexStackSize - 1] = 0;
                    }
                    return n2;
                }
                int index = 0;
                index = expectedIndex;
                do {
                    if ((index = (n = index) + 1) == names.size()) {
                        index = 0;
                    }
                    if (index == expectedIndex) break block7;
                } while (!Intrinsics.areEqual((Object)names.get(index), (Object)name));
                int it = n = index;
                boolean bl = false;
                this.indexStack[this.indexStackSize - 1] = index + 1;
                if (this.indexStack[this.indexStackSize - 1] == names.size()) {
                    this.indexStack[this.indexStackSize - 1] = 0;
                }
                return n;
            }
            this.skipValue();
        }
        return -1;
    }

    private final void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = Arrays.copyOf(this.stack, this.stack.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.stack = nArray;
            String[] stringArray = Arrays.copyOf(this.pathNames, this.pathNames.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
            this.pathNames = stringArray;
            int[] nArray2 = Arrays.copyOf(this.pathIndices, this.pathIndices.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
            this.pathIndices = nArray2;
            int[] nArray3 = Arrays.copyOf(this.indexStack, this.indexStack.length * 2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
            this.indexStack = nArray3;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
        this.stack[n] = newTop;
    }

    private final int nextNonWhitespace(boolean throwOnEof) {
        int p = 0;
        block7: while (this.source.request((long)p + 1L)) {
            byte c = this.buffer.getByte((long)p++);
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block7;
                }
            }
            this.buffer.skip((long)p - 1L);
            switch (c) {
                case 47: {
                    if (!this.source.request(2L)) {
                        return c;
                    }
                    this.throwSyntaxError("Malformed JSON");
                    throw new KotlinNothingValueException();
                }
                case 35: {
                    this.throwSyntaxError("Malformed JSON");
                    throw new KotlinNothingValueException();
                }
            }
            return c;
        }
        if (throwOnEof) {
            throw new EOFException("End of input");
        }
        return -1;
    }

    @Override
    @NotNull
    public List<Object> getPath() {
        return JsonScope.INSTANCE.getPath(this.stackSize, this.stack, this.pathNames, this.pathIndices);
    }

    private final String getPathAsString() {
        return CollectionsKt.joinToString$default((Iterable)this.getPath(), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final char readEscapeCharacter() {
        char c;
        if (!this.source.request(1L)) {
            this.throwSyntaxError("Unterminated escape sequence");
            throw new KotlinNothingValueException();
        }
        char escaped = (char)this.buffer.readByte();
        switch (escaped) {
            case 'u': {
                void var2_2;
                int i;
                if (!this.source.request(4L)) {
                    throw new EOFException("Unterminated escape sequence at path " + this.getPath());
                }
                int result = 0;
                int end = i + 4;
                for (i = 0; i < end; ++i) {
                    int n;
                    byte c2 = this.buffer.getByte((long)i);
                    result = (char)(result << 4);
                    if (c2 >= 48 && c2 <= 57) {
                        n = c2 - 48;
                    } else if (c2 >= 97 && c2 <= 102) {
                        n = c2 - 97 + 10;
                    } else if (c2 >= 65 && c2 <= 70) {
                        n = c2 - 65 + 10;
                    } else {
                        this.throwSyntaxError("\\u" + this.buffer.readUtf8(4L));
                        throw new KotlinNothingValueException();
                    }
                    result = (char)(result + n);
                }
                this.buffer.skip(4L);
                c = var2_2;
                break;
            }
            case 't': {
                c = '\t';
                break;
            }
            case 'b': {
                c = '\b';
                break;
            }
            case 'n': {
                c = '\n';
                break;
            }
            case 'r': {
                c = '\r';
                break;
            }
            case 'f': {
                c = '\f';
                break;
            }
            case '\n': 
            case '\"': 
            case '\'': 
            case '/': 
            case '\\': {
                c = escaped;
                break;
            }
            default: {
                this.throwSyntaxError("Invalid escape sequence: \\" + escaped);
                throw new KotlinNothingValueException();
            }
        }
        return c;
    }

    @Override
    public void rewind() {
        throw new IllegalStateException("BufferedSourceJsonReader cannot rewind.".toString());
    }

    private final Void throwSyntaxError(String message) {
        throw new JsonEncodingException(message + " at path " + this.getPath());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo/api/json/BufferedSourceJsonReader$Companion;", "", "<init>", "()V", "MIN_INCOMPLETE_INTEGER", "", "SINGLE_QUOTE_OR_SLASH", "Lokio/ByteString;", "DOUBLE_QUOTE_OR_SLASH", "UNQUOTED_STRING_TERMINALS", "PEEKED_NONE", "", "PEEKED_BEGIN_OBJECT", "PEEKED_END_OBJECT", "PEEKED_BEGIN_ARRAY", "PEEKED_END_ARRAY", "PEEKED_TRUE", "PEEKED_FALSE", "PEEKED_NULL", "PEEKED_SINGLE_QUOTED", "PEEKED_DOUBLE_QUOTED", "PEEKED_UNQUOTED", "PEEKED_BUFFERED", "PEEKED_SINGLE_QUOTED_NAME", "PEEKED_DOUBLE_QUOTED_NAME", "PEEKED_UNQUOTED_NAME", "PEEKED_LONG", "PEEKED_NUMBER", "PEEKED_EOF", "NUMBER_CHAR_NONE", "NUMBER_CHAR_SIGN", "NUMBER_CHAR_DIGIT", "NUMBER_CHAR_DECIMAL", "NUMBER_CHAR_FRACTION_DIGIT", "NUMBER_CHAR_EXP_E", "NUMBER_CHAR_EXP_SIGN", "NUMBER_CHAR_EXP_DIGIT", "INITIAL_STACK_SIZE", "apollo-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

