/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.io.Charsets;

public final class HttpUtils {
    static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    static final String HEADER_VALUE_SEPARATOR = ";";
    static final String ENCODING_VALUE_KEY = "charset";

    public static Charset parseCharacterEncoding(String contentTypeHeader, Charset defaultCharset) {
        if (contentTypeHeader == null) {
            return defaultCharset;
        }
        String[] contentTypeValues = contentTypeHeader.split(HEADER_VALUE_SEPARATOR);
        if (contentTypeValues.length <= 1) {
            return defaultCharset;
        }
        for (String contentTypeValue : contentTypeValues) {
            if (!contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) continue;
            String[] encodingValues = contentTypeValue.split(HEADER_KEY_VALUE_SEPARATOR);
            if (encodingValues.length <= 1) {
                return defaultCharset;
            }
            try {
                return Charsets.toCharset((String)encodingValues[1]);
            }
            catch (UnsupportedCharsetException ex) {
                return defaultCharset;
            }
        }
        return defaultCharset;
    }

    public static String appendCharacterEncoding(String currentContentType, String newEncoding) {
        if (currentContentType == null || currentContentType.trim().isEmpty()) {
            return null;
        }
        if (currentContentType.contains(HEADER_VALUE_SEPARATOR)) {
            String[] contentTypeValues = currentContentType.split(HEADER_VALUE_SEPARATOR);
            StringBuilder contentType = new StringBuilder(contentTypeValues[0]);
            for (int i = 1; i < contentTypeValues.length; ++i) {
                String contentTypeValue = contentTypeValues[i];
                String contentTypeString = "; " + contentTypeValue;
                if (contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) {
                    contentTypeString = "; charset=" + newEncoding;
                }
                contentType.append(contentTypeString);
            }
            return contentType.toString();
        }
        return currentContentType + HEADER_VALUE_SEPARATOR + " " + ENCODING_VALUE_KEY + HEADER_KEY_VALUE_SEPARATOR + newEncoding;
    }
}

