/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpApiV2ProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpSession;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletRegistration;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyRequestDispatcher
implements RequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AwsHttpSession.class);
    private String dispatchTo;
    private boolean isNamedDispatcher;
    private AwsLambdaServletContainerHandler lambdaContainerHandler;

    public AwsProxyRequestDispatcher(String target, boolean namedDispatcher, AwsLambdaServletContainerHandler handler) {
        this.isNamedDispatcher = namedDispatcher;
        this.dispatchTo = target;
        this.lambdaContainerHandler = handler;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (this.lambdaContainerHandler == null) {
            throw new IllegalStateException("Null container handler in dispatcher");
        }
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Cannot forward request with committed response");
        }
        servletResponse.resetBuffer();
        if (this.isNamedDispatcher) {
            this.lambdaContainerHandler.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, ((AwsServletRegistration)servletRequest.getServletContext().getServletRegistration(this.dispatchTo)).getServlet());
            return;
        }
        servletRequest.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.FORWARD);
        this.setRequestPath(servletRequest, this.dispatchTo);
        this.lambdaContainerHandler.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.getServlet((HttpServletRequest)servletRequest));
    }

    @SuppressFBWarnings(value={"SERVLET_QUERY_STRING"})
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (this.lambdaContainerHandler == null) {
            throw new IllegalStateException("Null container handler in dispatcher");
        }
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Cannot forward request with committed response");
        }
        servletRequest.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.INCLUDE);
        if (!this.isNamedDispatcher) {
            servletRequest.setAttribute("javax.servlet.include.request_uri", (Object)((HttpServletRequest)servletRequest).getRequestURI());
            servletRequest.setAttribute("javax.servlet.include.context_path", (Object)((HttpServletRequest)servletRequest).getContextPath());
            servletRequest.setAttribute("javax.servlet.include.servlet_path", (Object)((HttpServletRequest)servletRequest).getServletPath());
            servletRequest.setAttribute("javax.servlet.include.path_info", (Object)((HttpServletRequest)servletRequest).getPathInfo());
            servletRequest.setAttribute("javax.servlet.include.query_string", (Object)SecurityUtils.encode(SecurityUtils.crlf(((HttpServletRequest)servletRequest).getQueryString())));
            this.setRequestPath(servletRequest, this.dispatchTo);
        }
        this.lambdaContainerHandler.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.getServlet((HttpServletRequest)servletRequest));
    }

    void setRequestPath(ServletRequest req, String destinationPath) {
        if (req instanceof AwsProxyHttpServletRequest) {
            ((AwsProxyHttpServletRequest)req).getAwsProxyRequest().setPath(this.dispatchTo);
            return;
        }
        if (req instanceof AwsHttpApiV2ProxyHttpServletRequest) {
            ((AwsHttpApiV2ProxyHttpServletRequest)req).getRequest().setRawPath(destinationPath);
            return;
        }
        log.debug("Request is not an proxy request generated by this library, attempting to extract the proxy event type from the request attributes");
        if (req.getAttribute("com.amazonaws.apigateway.request") != null && req.getAttribute("com.amazonaws.apigateway.request") instanceof AwsProxyRequest) {
            ((AwsProxyRequest)req.getAttribute("com.amazonaws.apigateway.request")).setPath(this.dispatchTo);
            return;
        }
        if (req.getAttribute("com.amazonaws.httpapi.request") != null && req.getAttribute("com.amazonaws.httpapi.request") instanceof HttpApiV2ProxyRequest) {
            ((HttpApiV2ProxyRequest)req.getAttribute("com.amazonaws.httpapi.request")).setRawPath(destinationPath);
            return;
        }
        throw new IllegalStateException("Could not set new target path for the given ServletRequest object");
    }

    private Servlet getServlet(HttpServletRequest req) {
        return ((AwsServletContext)this.lambdaContainerHandler.getServletContext()).getServletForPath(req.getPathInfo());
    }
}

