/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequestWrapper;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsAsyncContext
implements AsyncContext {
    private HttpServletRequest req;
    private HttpServletResponse res;
    private AwsLambdaServletContainerHandler handler;
    private List<AsyncListenerHolder> listeners;
    private long timeout;
    private AtomicBoolean dispatched;
    private AtomicBoolean completed;
    private Logger log = LoggerFactory.getLogger(AwsAsyncContext.class);

    public AwsAsyncContext(HttpServletRequest request, HttpServletResponse response, AwsLambdaServletContainerHandler servletHandler) {
        this.log.debug("Initializing async context for request: " + SecurityUtils.crlf(request.getPathInfo()) + " - " + SecurityUtils.crlf(request.getMethod()));
        this.req = request;
        this.res = response;
        this.handler = servletHandler;
        this.listeners = new ArrayList<AsyncListenerHolder>();
        this.timeout = 3000L;
        this.dispatched = new AtomicBoolean(false);
        this.completed = new AtomicBoolean(false);
    }

    public ServletRequest getRequest() {
        return this.req;
    }

    public ServletResponse getResponse() {
        return this.res;
    }

    public boolean hasOriginalRequestAndResponse() {
        return true;
    }

    public void dispatch() {
        try {
            this.log.debug("Dispatching request");
            if (this.dispatched.get()) {
                throw new IllegalStateException("Dispatching already started");
            }
            this.dispatched.set(true);
            this.handler.doFilter(this.req, this.res, ((AwsServletContext)this.req.getServletContext()).getServletForPath(this.req.getRequestURI()));
            this.notifyListeners(NotificationType.START_ASYNC, null);
        }
        catch (ServletException | IOException e) {
            this.notifyListeners(NotificationType.ERROR, e);
        }
    }

    public void dispatch(String s) {
        this.req = new AwsHttpServletRequestWrapper(this.req, s);
        this.dispatch();
    }

    public void dispatch(ServletContext servletContext, String s) {
        this.req = new AwsHttpServletRequestWrapper(this.req, s);
        ((AwsHttpServletRequestWrapper)this.req).setServletContext(servletContext);
        this.dispatch(s);
    }

    public void complete() {
        try {
            this.log.debug("Completing request");
            this.notifyListeners(NotificationType.COMPLETE, null);
            this.res.flushBuffer();
            this.completed.set(true);
        }
        catch (IOException e) {
            this.log.error("Could not flush response buffer", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void start(Runnable runnable) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void addListener(AsyncListener asyncListener) {
        this.listeners.add(new AsyncListenerHolder(asyncListener, this));
    }

    public void addListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
        AsyncListenerHolder holder = new AsyncListenerHolder(asyncListener, this);
        holder.setSuppliedRequest(servletRequest);
        holder.setSuppliedResponse(servletResponse);
        this.listeners.add(holder);
    }

    public <T extends AsyncListener> T createListener(Class<T> aClass) throws ServletException {
        try {
            return (T)((AsyncListener)aClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isDispatched() {
        return this.dispatched.get();
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    private void notifyListeners(NotificationType type, Throwable t) {
        this.listeners.forEach(h -> {
            block6: {
                try {
                    switch (type) {
                        case COMPLETE: 
                        case START_ASYNC: 
                        case TIMEOUT: {
                            h.getListener().onComplete(h.getAsyncEvent());
                            break;
                        }
                        case ERROR: {
                            h.getListener().onError(h.getAsyncEvent(t));
                        }
                    }
                }
                catch (IOException e) {
                    if (type == NotificationType.ERROR) break block6;
                    this.notifyListeners(NotificationType.ERROR, e);
                }
            }
        });
    }

    private static enum NotificationType {
        COMPLETE,
        ERROR,
        START_ASYNC,
        TIMEOUT;

    }

    private static final class AsyncListenerHolder {
        private AsyncListener listener;
        private ServletRequest suppliedRequest;
        private ServletResponse suppliedResponse;
        private AsyncContext context;

        public AsyncListenerHolder(AsyncListener l, AsyncContext ctx) {
            this.listener = l;
            this.context = ctx;
        }

        public AsyncListener getListener() {
            return this.listener;
        }

        public void setListener(AsyncListener listener) {
            this.listener = listener;
        }

        public ServletRequest getSuppliedRequest() {
            return this.suppliedRequest;
        }

        public void setSuppliedRequest(ServletRequest suppliedRequest) {
            this.suppliedRequest = suppliedRequest;
        }

        public ServletResponse getSuppliedResponse() {
            return this.suppliedResponse;
        }

        public void setSuppliedResponse(ServletResponse suppliedResponse) {
            this.suppliedResponse = suppliedResponse;
        }

        public AsyncEvent getAsyncEvent(Throwable t) {
            if (this.suppliedRequest != null && this.suppliedResponse != null) {
                if (t != null) {
                    return new AsyncEvent(this.context, this.suppliedRequest, this.suppliedResponse, t);
                }
                return new AsyncEvent(this.context, this.suppliedRequest, this.suppliedResponse);
            }
            return new AsyncEvent(this.context);
        }

        public AsyncEvent getAsyncEvent() {
            return this.getAsyncEvent(null);
        }
    }
}

