/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import com.amazonaws.services.lambda.runtime.api.client.AWSLambda;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class UserFault
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    public final String msg;
    public final String exception;
    public final String trace;
    public final Boolean fatal;
    private static final String packagePrefix = AWSLambda.class.getPackage().getName();

    public UserFault(String msg, String exception, String trace) {
        this.msg = msg;
        this.exception = exception;
        this.trace = trace;
        this.fatal = false;
    }

    public UserFault(String msg, String exception, String trace, Boolean fatal) {
        this.msg = msg;
        this.exception = exception;
        this.trace = trace;
        this.fatal = fatal;
    }

    public static UserFault makeUserFault(Throwable t) {
        return UserFault.makeUserFault(t, false);
    }

    public static UserFault makeUserFault(Throwable t, boolean fatal) {
        String msg = t.getLocalizedMessage() == null ? t.getClass().getName() : t.getLocalizedMessage();
        return new UserFault(msg, t.getClass().getName(), UserFault.trace(t), (Boolean)fatal);
    }

    public static UserFault makeUserFault(String msg) {
        return new UserFault(msg, null, null);
    }

    public static String trace(Throwable t) {
        UserFault.filterStackTrace(t);
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static <T extends Throwable> T filterStackTrace(T t) {
        Throwable cause;
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            if (!trace[i].getClassName().startsWith(packagePrefix)) continue;
            StackTraceElement[] newTrace = new StackTraceElement[i];
            System.arraycopy(trace, 0, newTrace, 0, i);
            t.setStackTrace(newTrace);
            break;
        }
        if ((cause = t.getCause()) != null) {
            UserFault.filterStackTrace(cause);
        }
        return t;
    }

    static UserFault makeInitErrorUserFault(Throwable e, String className) {
        return new UserFault("Error loading class " + className + (e.getMessage() == null ? "" : ": " + e.getMessage()), e.getClass().getName(), UserFault.trace(e), (Boolean)true);
    }

    static UserFault makeClassNotFoundUserFault(Throwable e, String className) {
        return new UserFault("Class not found: " + className, e.getClass().getName(), UserFault.trace(e), (Boolean)false);
    }

    public String reportableError() {
        if (this.exception != null || this.trace != null) {
            return String.format("%s: %s\n%s\n", this.msg, this.exception == null ? "" : this.exception, this.trace == null ? "" : this.trace);
        }
        return String.format("%s\n", this.msg);
    }
}

