/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import com.amazonaws.services.lambda.runtime.ClientContext;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaRuntimeInternal;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.lambda.runtime.api.client.AWSLambda;
import com.amazonaws.services.lambda.runtime.api.client.HandlerInfo;
import com.amazonaws.services.lambda.runtime.api.client.LambdaEnvironment;
import com.amazonaws.services.lambda.runtime.api.client.LambdaRequestHandler;
import com.amazonaws.services.lambda.runtime.api.client.UserFault;
import com.amazonaws.services.lambda.runtime.api.client.api.LambdaClientContext;
import com.amazonaws.services.lambda.runtime.api.client.api.LambdaCognitoIdentity;
import com.amazonaws.services.lambda.runtime.api.client.api.LambdaContext;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.InvocationRequest;
import com.amazonaws.services.lambda.runtime.api.client.util.UnsafeUtil;
import com.amazonaws.services.lambda.runtime.serialization.PojoSerializer;
import com.amazonaws.services.lambda.runtime.serialization.events.LambdaEventSerializers;
import com.amazonaws.services.lambda.runtime.serialization.factories.GsonFactory;
import com.amazonaws.services.lambda.runtime.serialization.factories.JacksonFactory;
import com.amazonaws.services.lambda.runtime.serialization.util.Functions;
import com.amazonaws.services.lambda.runtime.serialization.util.ReflectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

public final class EventHandlerLoader {
    private static final byte[] _JsonNull = new byte[]{110, 117, 108, 108};
    private static final EnumMap<Platform, Map<Type, PojoSerializer<Object>>> typeCache = new EnumMap(Platform.class);
    private static volatile PojoSerializer<LambdaClientContext> contextSerializer;
    private static volatile PojoSerializer<LambdaCognitoIdentity> cognitoSerializer;
    private static final Comparator<Method> methodPriority;

    private EventHandlerLoader() {
    }

    private static PojoSerializer<Object> getSerializer(Platform platform, Type type) {
        Class clazz;
        if (type instanceof Class && LambdaEventSerializers.isLambdaSupportedEvent((String)(clazz = (Class)type).getName())) {
            return LambdaEventSerializers.serializerFor((Class)clazz, (ClassLoader)AWSLambda.customerClassLoader);
        }
        switch (platform) {
            case ANDROID: {
                return GsonFactory.getInstance().getSerializer(type);
            }
        }
        return JacksonFactory.getInstance().getSerializer(type);
    }

    private static PojoSerializer<Object> getSerializerCached(Platform platform, Type type) {
        PojoSerializer<Object> serializer;
        Map<Type, PojoSerializer<Object>> cache = typeCache.get((Object)platform);
        if (cache == null) {
            cache = new HashMap<Type, PojoSerializer<Object>>();
            typeCache.put(platform, cache);
        }
        if ((serializer = cache.get(type)) == null) {
            serializer = EventHandlerLoader.getSerializer(platform, type);
            cache.put(type, serializer);
        }
        return serializer;
    }

    private static PojoSerializer<LambdaClientContext> getContextSerializer() {
        if (contextSerializer == null) {
            contextSerializer = GsonFactory.getInstance().getSerializer(LambdaClientContext.class);
        }
        return contextSerializer;
    }

    private static PojoSerializer<LambdaCognitoIdentity> getCognitoSerializer() {
        if (cognitoSerializer == null) {
            cognitoSerializer = GsonFactory.getInstance().getSerializer(LambdaCognitoIdentity.class);
        }
        return cognitoSerializer;
    }

    private static Platform getPlatform(Context context) {
        ClientContext cc = context.getClientContext();
        if (cc == null) {
            return Platform.UNKNOWN;
        }
        Map env = cc.getEnvironment();
        if (env == null) {
            return Platform.UNKNOWN;
        }
        String platform = (String)env.get("platform");
        if (platform == null) {
            return Platform.UNKNOWN;
        }
        if ("Android".equalsIgnoreCase(platform)) {
            return Platform.ANDROID;
        }
        if ("iPhoneOS".equalsIgnoreCase(platform)) {
            return Platform.IOS;
        }
        return Platform.UNKNOWN;
    }

    private static boolean isVoid(Type type) {
        return Void.TYPE.equals(type) || type instanceof Class && Void.class.isAssignableFrom((Class)type);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz) throws Exception {
        Constructor<T> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
                throw new Exception("Class " + clazz.getName() + " cannot be instantiated because it is a non-static inner class");
            }
            throw new Exception("Class " + clazz.getName() + " has no public zero-argument constructor", e);
        }
        return constructor;
    }

    public static <T> T newInstance(Constructor<? extends T> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (UserFault e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw UserFault.makeUserFault(e.getCause() == null ? e : e.getCause(), true);
        }
        catch (InstantiationException e) {
            throw UnsafeUtil.throwException(e.getCause() == null ? e : e.getCause());
        }
        catch (IllegalAccessException e) {
            throw UnsafeUtil.throwException(e);
        }
    }

    public static Type[] findInterfaceParameters(Class<?> clazz, Class<?> iface) {
        LinkedList<ClassContext> clazzes = new LinkedList<ClassContext>();
        clazzes.addFirst(new ClassContext(clazz, (Type[])null));
        while (!clazzes.isEmpty()) {
            Type[] interfaces;
            ClassContext curContext = (ClassContext)clazzes.removeLast();
            for (Type type : interfaces = curContext.clazz.getGenericInterfaces()) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType candidate = (ParameterizedType)type;
                    Type rawType = candidate.getRawType();
                    if (!(rawType instanceof Class)) {
                        System.err.println("raw type is not a class: " + rawType);
                        continue;
                    }
                    Class rawClass = (Class)rawType;
                    if (iface.isAssignableFrom(rawClass)) {
                        return new ClassContext((ParameterizedType)candidate, (ClassContext)curContext).actualTypeArguments;
                    }
                    clazzes.addFirst(new ClassContext(candidate, curContext));
                    continue;
                }
                if (type instanceof Class) {
                    clazzes.addFirst(new ClassContext((Class)type, curContext));
                    continue;
                }
                System.err.println("Unexpected type class " + type.getClass().getName());
            }
            Type superClass = curContext.clazz.getGenericSuperclass();
            if (superClass instanceof ParameterizedType) {
                clazzes.addFirst(new ClassContext((ParameterizedType)superClass, curContext));
                continue;
            }
            if (superClass == null) continue;
            clazzes.addFirst(new ClassContext((Class)superClass, curContext));
        }
        return null;
    }

    public static LambdaRequestHandler wrapRequestHandlerClass(Class<? extends RequestHandler> clazz) {
        Type[] ptypes = EventHandlerLoader.findInterfaceParameters(clazz, RequestHandler.class);
        if (ptypes == null) {
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault("Class " + clazz.getName() + " does not implement RequestHandler with concrete type parameters"));
        }
        if (ptypes.length != 2) {
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault("Invalid class signature for RequestHandler. Expected two generic types, got " + ptypes.length));
        }
        for (Type t : ptypes) {
            if (!(t instanceof TypeVariable)) continue;
            Type[] bounds = ((TypeVariable)t).getBounds();
            boolean foundBound = false;
            if (bounds != null) {
                for (Type bound : bounds) {
                    if (Object.class.equals((Object)bound)) continue;
                    foundBound = true;
                    break;
                }
            }
            if (foundBound) continue;
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault("Class " + clazz.getName() + " does not implement RequestHandler with concrete type parameters: parameter " + t + " has no upper bound."));
        }
        Type pType = ptypes[0];
        Type rType = ptypes[1];
        try {
            Constructor<? extends RequestHandler> constructor = EventHandlerLoader.getConstructor(clazz);
            return EventHandlerLoader.wrapPojoHandler(EventHandlerLoader.newInstance(constructor), pType, rType);
        }
        catch (UserFault f) {
            return new LambdaRequestHandler.UserFaultHandler(f);
        }
        catch (Throwable e) {
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault(e));
        }
    }

    public static LambdaRequestHandler wrapRequestStreamHandlerClass(Class<? extends RequestStreamHandler> clazz) {
        try {
            Constructor<? extends RequestStreamHandler> constructor = EventHandlerLoader.getConstructor(clazz);
            return EventHandlerLoader.wrapRequestStreamHandler(EventHandlerLoader.newInstance(constructor));
        }
        catch (UserFault f) {
            return new LambdaRequestHandler.UserFaultHandler(f);
        }
        catch (Throwable e) {
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault(e));
        }
    }

    public static LambdaRequestHandler loadStreamingRequestHandler(Class<?> clazz) {
        if (RequestStreamHandler.class.isAssignableFrom(clazz)) {
            return EventHandlerLoader.wrapRequestStreamHandlerClass(clazz.asSubclass(RequestStreamHandler.class));
        }
        if (RequestHandler.class.isAssignableFrom(clazz)) {
            return EventHandlerLoader.wrapRequestHandlerClass(clazz.asSubclass(RequestHandler.class));
        }
        return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault("Class does not implement an appropriate handler interface: " + clazz.getName()));
    }

    public static LambdaRequestHandler loadEventHandler(HandlerInfo handlerInfo) {
        if (handlerInfo.methodName == null) {
            return EventHandlerLoader.loadStreamingRequestHandler(handlerInfo.clazz);
        }
        return EventHandlerLoader.loadEventPojoHandler(handlerInfo);
    }

    private static Optional<LambdaRequestHandler> getOneLengthHandler(Class<?> clazz, Method m, Type pType, Type rType) {
        if (InputStream.class.equals((Object)pType)) {
            return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, true, false, false));
        }
        if (OutputStream.class.equals((Object)pType)) {
            return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, false, true, false));
        }
        if (EventHandlerLoader.isContext(pType)) {
            return Optional.of(PojoMethodRequestHandler.makeRequestHandler(clazz, m, null, rType, true));
        }
        return Optional.of(PojoMethodRequestHandler.makeRequestHandler(clazz, m, pType, rType, false));
    }

    private static Optional<LambdaRequestHandler> getTwoLengthHandler(Class<?> clazz, Method m, Type pType1, Type pType2, Type rType) {
        if (OutputStream.class.equals((Object)pType1)) {
            if (EventHandlerLoader.isContext(pType2)) {
                return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, false, true, true));
            }
            System.err.println("Ignoring two-argument overload because first argument type is OutputStream and second argument type is not Context");
            return Optional.empty();
        }
        if (EventHandlerLoader.isContext(pType1)) {
            System.err.println("Ignoring two-argument overload because first argument type is Context");
            return Optional.empty();
        }
        if (InputStream.class.equals((Object)pType1)) {
            if (OutputStream.class.equals((Object)pType2)) {
                return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, true, true, false));
            }
            if (EventHandlerLoader.isContext(pType2)) {
                return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, true, false, true));
            }
            System.err.println("Ignoring two-argument overload because second parameter type, " + ReflectUtil.getRawClass((Type)pType2).getName() + ", is not OutputStream.");
            return Optional.empty();
        }
        if (EventHandlerLoader.isContext(pType2)) {
            return Optional.of(PojoMethodRequestHandler.makeRequestHandler(clazz, m, pType1, rType, true));
        }
        System.err.println("Ignoring two-argument overload because second parameter type is not Context");
        return Optional.empty();
    }

    private static Optional<LambdaRequestHandler> getThreeLengthHandler(Class<?> clazz, Method m, Type pType1, Type pType2, Type pType3, Type rType) {
        if (InputStream.class.equals((Object)pType1) && OutputStream.class.equals((Object)pType2) && EventHandlerLoader.isContext(pType3)) {
            return Optional.of(StreamMethodRequestHandler.makeRequestHandler(clazz, m, true, true, true));
        }
        System.err.println("Ignoring three-argument overload because argument signature is not (InputStream, OutputStream, Context");
        return Optional.empty();
    }

    private static Optional<LambdaRequestHandler> getHandlerFromOverload(Class<?> clazz, Method m) {
        Type rType = m.getGenericReturnType();
        Type[] pTypes = m.getGenericParameterTypes();
        if (pTypes.length == 0) {
            return Optional.of(PojoMethodRequestHandler.makeRequestHandler(clazz, m, null, rType, false));
        }
        if (pTypes.length == 1) {
            return EventHandlerLoader.getOneLengthHandler(clazz, m, pTypes[0], rType);
        }
        if (pTypes.length == 2) {
            return EventHandlerLoader.getTwoLengthHandler(clazz, m, pTypes[0], pTypes[1], rType);
        }
        if (pTypes.length == 3) {
            return EventHandlerLoader.getThreeLengthHandler(clazz, m, pTypes[0], pTypes[1], pTypes[2], rType);
        }
        System.err.println("Ignoring an overload of method " + m.getName() + " because it has too many parameters: Expected at most 3, got " + pTypes.length);
        return Optional.empty();
    }

    private static final boolean isContext(Type t) {
        return Context.class.equals((Object)t);
    }

    private static final boolean lastParameterIsContext(Class<?>[] params) {
        return params.length != 0 && EventHandlerLoader.isContext(params[params.length - 1]);
    }

    private static LambdaRequestHandler loadEventPojoHandler(HandlerInfo handlerInfo) {
        Method[] methods;
        try {
            methods = handlerInfo.clazz.getMethods();
        }
        catch (NoClassDefFoundError e) {
            return new LambdaRequestHandler.UserFaultHandler(new UserFault("Error loading method " + handlerInfo.methodName + " on class " + handlerInfo.clazz.getName(), e.getClass().getName(), UserFault.trace(e)));
        }
        if (methods.length == 0) {
            String msg = "Class " + handlerInfo.getClass().getName() + " has no public method named " + handlerInfo.methodName;
            return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault(msg));
        }
        int slide = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method m;
            methods[i - slide] = m = methods[i];
            if (m.getName().equals(handlerInfo.methodName)) continue;
            ++slide;
        }
        int end = methods.length - slide;
        Arrays.sort(methods, 0, end, methodPriority);
        for (int i = 0; i < end; ++i) {
            Method m = methods[i];
            Optional<LambdaRequestHandler> result = EventHandlerLoader.getHandlerFromOverload(handlerInfo.clazz, m);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault("No public method named " + handlerInfo.methodName + " with appropriate method signature found on class " + handlerInfo.clazz.getName()));
    }

    public static LambdaRequestHandler wrapPojoHandler(RequestHandler instance, Type pType, Type rType) {
        return EventHandlerLoader.wrapRequestStreamHandler(new PojoHandlerAsStreamHandler(instance, Optional.ofNullable(pType), EventHandlerLoader.isVoid(rType) ? Optional.empty() : Optional.of(rType)));
    }

    public static String exceptionToString(Throwable t) {
        StringWriter writer = new StringWriter(65536);
        try (PrintWriter wrapped = new PrintWriter(writer);){
            t.printStackTrace(wrapped);
        }
        StringBuffer buffer = writer.getBuffer();
        if (buffer.length() > 262144) {
            String extra = " Truncated by Lambda";
            buffer.delete(262144, buffer.length());
            buffer.append(" Truncated by Lambda");
        }
        return buffer.toString();
    }

    public static LambdaRequestHandler wrapRequestStreamHandler(final RequestStreamHandler handler) {
        return new LambdaRequestHandler(){
            private final ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            private Functions.V2<String, String> log4jContextPutMethod = null;

            private void safeAddRequestIdToLog4j(String log4jContextClassName, InvocationRequest request, Class contextMapValueClass) {
                try {
                    Class log4jContextClass = ReflectUtil.loadClass((ClassLoader)AWSLambda.customerClassLoader, (String)log4jContextClassName);
                    this.log4jContextPutMethod = ReflectUtil.loadStaticV2((Class)log4jContextClass, (String)"put", (boolean)false, String.class, (Class)contextMapValueClass);
                    this.log4jContextPutMethod.call((Object)"AWSRequestId", (Object)request.getId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public ByteArrayOutputStream call(InvocationRequest request) throws Error, Exception {
                this.output.reset();
                LambdaCognitoIdentity cognitoIdentity = null;
                if (request.getCognitoIdentity() != null && !request.getCognitoIdentity().isEmpty()) {
                    cognitoIdentity = (LambdaCognitoIdentity)EventHandlerLoader.getCognitoSerializer().fromJson(request.getCognitoIdentity());
                }
                LambdaClientContext clientContext = null;
                if (request.getClientContext() != null && !request.getClientContext().isEmpty()) {
                    clientContext = (LambdaClientContext)EventHandlerLoader.getContextSerializer().fromJson(request.getClientContext());
                }
                LambdaContext context = new LambdaContext(LambdaEnvironment.MEMORY_LIMIT, request.getDeadlineTimeInMs(), request.getId(), LambdaEnvironment.LOG_GROUP_NAME, LambdaEnvironment.LOG_STREAM_NAME, LambdaEnvironment.FUNCTION_NAME, cognitoIdentity, LambdaEnvironment.FUNCTION_VERSION, request.getInvokedFunctionArn(), clientContext);
                if (LambdaRuntimeInternal.getUseLog4jAppender()) {
                    this.safeAddRequestIdToLog4j("org.apache.log4j.MDC", request, Object.class);
                    this.safeAddRequestIdToLog4j("org.apache.logging.log4j.ThreadContext", request, String.class);
                    if (this.log4jContextPutMethod == null) {
                        System.err.println("Customer using log4j appender but unable to load either org.apache.log4j.MDC or org.apache.logging.log4j.ThreadContext. Customer cannot see RequestId in log4j log lines.");
                    }
                }
                handler.handleRequest(request.getContentAsStream(), (OutputStream)this.output, (Context)context);
                return this.output;
            }
        };
    }

    static {
        methodPriority = new Comparator<Method>(){

            @Override
            public int compare(Method lhs, Method rhs) {
                if (!lhs.isBridge() && rhs.isBridge()) {
                    return -1;
                }
                if (!rhs.isBridge() && lhs.isBridge()) {
                    return 1;
                }
                Class[] lParams = lhs.getParameterTypes();
                Class[] rParams = rhs.getParameterTypes();
                int lParamCompareLength = lParams.length;
                int rParamCompareLength = rParams.length;
                if (EventHandlerLoader.lastParameterIsContext(lParams)) {
                    ++lParamCompareLength;
                }
                if (EventHandlerLoader.lastParameterIsContext(rParams)) {
                    ++rParamCompareLength;
                }
                return -Integer.compare(lParamCompareLength, rParamCompareLength);
            }
        };
    }

    private static final class ClassContext {
        public final Class<?> clazz;
        public final Type[] actualTypeArguments;
        private TypeVariable[] typeParameters;

        public ClassContext(Class<?> clazz, Type[] actualTypeArguments) {
            this.clazz = clazz;
            this.actualTypeArguments = actualTypeArguments;
        }

        public ClassContext(Class<?> clazz, ClassContext curContext) {
            this.typeParameters = clazz.getTypeParameters();
            if (this.typeParameters.length == 0 || curContext.actualTypeArguments == null) {
                this.clazz = clazz;
                this.actualTypeArguments = null;
            } else {
                Type[] types = new Type[this.typeParameters.length];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = curContext.resolveTypeVariable(this.typeParameters[i]);
                }
                this.clazz = clazz;
                this.actualTypeArguments = types;
            }
        }

        public ClassContext(ParameterizedType type, ClassContext curContext) {
            Type[] types = type.getActualTypeArguments();
            for (int i = 0; i < types.length; ++i) {
                Type t = types[i];
                if (!(t instanceof TypeVariable)) continue;
                types[i] = curContext.resolveTypeVariable((TypeVariable)t);
            }
            Type t = type.getRawType();
            if (t instanceof Class) {
                this.clazz = (Class)t;
            } else if (t instanceof TypeVariable) {
                this.clazz = (Class)((TypeVariable)t).getGenericDeclaration();
            } else {
                throw new RuntimeException("Type " + t + " is of unexpected type " + t.getClass());
            }
            this.actualTypeArguments = types;
        }

        public Type resolveTypeVariable(TypeVariable t) {
            TypeVariable[] variables = this.getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                if (!t.getName().equals(variables[i].getName())) continue;
                return this.actualTypeArguments == null ? variables[i] : this.actualTypeArguments[i];
            }
            return t;
        }

        private TypeVariable[] getTypeParameters() {
            if (this.typeParameters == null) {
                this.typeParameters = this.clazz.getTypeParameters();
            }
            return this.typeParameters;
        }
    }

    private static final class StreamMethodRequestHandler
    implements RequestStreamHandler {
        public final Method m;
        public final Object instance;
        public final boolean needsInput;
        public final boolean needsOutput;
        public final boolean needsContext;
        public final int argSize;

        public StreamMethodRequestHandler(Method m, Object instance, boolean needsInput, boolean needsOutput, boolean needsContext) {
            this.m = m;
            this.instance = instance;
            this.needsInput = needsInput;
            this.needsOutput = needsOutput;
            this.needsContext = needsContext;
            this.argSize = (needsInput ? 1 : 0) + (needsOutput ? 1 : 0) + (needsContext ? 1 : 0);
        }

        public static StreamMethodRequestHandler fromMethod(Class<?> clazz, Method m, boolean needsInput, boolean needsOutput, boolean needsContext) throws Exception {
            if (!EventHandlerLoader.isVoid(m.getReturnType())) {
                System.err.println("Will ignore return type " + m.getReturnType() + " on byte stream handler");
            }
            Object instance = Modifier.isStatic(m.getModifiers()) ? null : EventHandlerLoader.newInstance(EventHandlerLoader.getConstructor(clazz));
            return new StreamMethodRequestHandler(m, instance, needsInput, needsOutput, needsContext);
        }

        public static LambdaRequestHandler makeRequestHandler(Class<?> clazz, Method m, boolean needsInput, boolean needsOutput, boolean needsContext) {
            try {
                return EventHandlerLoader.wrapRequestStreamHandler(StreamMethodRequestHandler.fromMethod(clazz, m, needsInput, needsOutput, needsContext));
            }
            catch (UserFault f) {
                return new LambdaRequestHandler.UserFaultHandler(f);
            }
            catch (Throwable t) {
                return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault(t));
            }
        }

        public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
            Object[] args = new Object[this.argSize];
            int idx = 0;
            if (this.needsInput) {
                args[idx++] = inputStream;
            } else {
                inputStream.close();
            }
            if (this.needsOutput) {
                args[idx++] = outputStream;
            }
            if (this.needsContext) {
                args[idx++] = context;
            }
            try {
                this.m.invoke(this.instance, args);
                if (!this.needsOutput) {
                    outputStream.write(_JsonNull);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw UnsafeUtil.throwException(UserFault.filterStackTrace(e.getCause()));
                }
                throw UnsafeUtil.throwException(UserFault.filterStackTrace(e));
            }
            catch (Throwable t) {
                throw UnsafeUtil.throwException(UserFault.filterStackTrace(t));
            }
        }
    }

    private static final class PojoMethodRequestHandler
    implements RequestHandler<Object, Object> {
        public final Method m;
        public final Type pType;
        public final Object instance;
        public final boolean needsContext;
        public final int argSize;

        public PojoMethodRequestHandler(Method m, Type pType, Type rType, Object instance, boolean needsContext) {
            this.m = m;
            this.pType = pType;
            this.instance = instance;
            this.needsContext = needsContext;
            this.argSize = (needsContext ? 1 : 0) + (pType != null ? 1 : 0);
        }

        public static PojoMethodRequestHandler fromMethod(Class<?> clazz, Method m, Type pType, Type rType, boolean needsContext) throws Exception {
            Object instance = Modifier.isStatic(m.getModifiers()) ? null : EventHandlerLoader.newInstance(EventHandlerLoader.getConstructor(clazz));
            return new PojoMethodRequestHandler(m, pType, rType, instance, needsContext);
        }

        public static LambdaRequestHandler makeRequestHandler(Class<?> clazz, Method m, Type pType, Type rType, boolean needsContext) {
            try {
                return EventHandlerLoader.wrapPojoHandler(PojoMethodRequestHandler.fromMethod(clazz, m, pType, rType, needsContext), pType, rType);
            }
            catch (UserFault f) {
                return new LambdaRequestHandler.UserFaultHandler(f);
            }
            catch (Throwable t) {
                return new LambdaRequestHandler.UserFaultHandler(UserFault.makeUserFault(t));
            }
        }

        public Object handleRequest(Object input, Context context) {
            Object[] args = new Object[this.argSize];
            int idx = 0;
            if (this.pType != null) {
                args[idx++] = input;
            }
            if (this.needsContext) {
                args[idx++] = context;
            }
            try {
                return this.m.invoke(this.instance, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw UnsafeUtil.throwException(UserFault.filterStackTrace(e.getCause()));
                }
                throw UnsafeUtil.throwException(UserFault.filterStackTrace(e));
            }
            catch (Throwable t) {
                throw UnsafeUtil.throwException(UserFault.filterStackTrace(t));
            }
        }
    }

    private static final class PojoHandlerAsStreamHandler
    implements RequestStreamHandler {
        public RequestHandler innerHandler;
        public final Optional<Type> inputType;
        public final Optional<Type> outputType;

        public PojoHandlerAsStreamHandler(RequestHandler innerHandler, Optional<Type> inputType, Optional<Type> outputType) {
            this.innerHandler = innerHandler;
            this.inputType = inputType;
            this.outputType = outputType;
            if (inputType.isPresent()) {
                EventHandlerLoader.getSerializerCached(Platform.UNKNOWN, inputType.get());
            }
            if (outputType.isPresent()) {
                EventHandlerLoader.getSerializerCached(Platform.UNKNOWN, outputType.get());
            }
        }

        public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
            Object output;
            Object input;
            Platform platform = EventHandlerLoader.getPlatform(context);
            try {
                input = this.inputType.isPresent() ? EventHandlerLoader.getSerializerCached(platform, this.inputType.get()).fromJson(inputStream) : null;
            }
            catch (Throwable t) {
                throw new RuntimeException("An error occurred during JSON parsing", UserFault.filterStackTrace(t));
            }
            try {
                output = this.innerHandler.handleRequest(input, context);
            }
            catch (Throwable t) {
                throw UnsafeUtil.throwException(UserFault.filterStackTrace(t));
            }
            try {
                if (this.outputType.isPresent()) {
                    PojoSerializer serializer = EventHandlerLoader.getSerializerCached(platform, this.outputType.get());
                    serializer.toJson(output, outputStream);
                } else {
                    outputStream.write(_JsonNull);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("An error occurred during JSON serialization of response", t);
            }
        }
    }

    private static enum Platform {
        ANDROID,
        IOS,
        UNKNOWN;

    }
}

