/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.ServiceId;
import com.amazonaws.services.xray.model.transform.TraceUserMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TraceUser
implements Serializable,
Cloneable,
StructuredPojo {
    private String userName;
    private List<ServiceId> serviceIds;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public TraceUser withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public List<ServiceId> getServiceIds() {
        return this.serviceIds;
    }

    public void setServiceIds(Collection<ServiceId> serviceIds) {
        if (serviceIds == null) {
            this.serviceIds = null;
            return;
        }
        this.serviceIds = new ArrayList<ServiceId>(serviceIds);
    }

    public TraceUser withServiceIds(ServiceId ... serviceIds) {
        if (this.serviceIds == null) {
            this.setServiceIds(new ArrayList<ServiceId>(serviceIds.length));
        }
        for (ServiceId ele : serviceIds) {
            this.serviceIds.add(ele);
        }
        return this;
    }

    public TraceUser withServiceIds(Collection<ServiceId> serviceIds) {
        this.setServiceIds(serviceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName()).append(",");
        }
        if (this.getServiceIds() != null) {
            sb.append("ServiceIds: ").append(this.getServiceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceUser)) {
            return false;
        }
        TraceUser other = (TraceUser)obj;
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getServiceIds() == null ^ this.getServiceIds() == null) {
            return false;
        }
        return other.getServiceIds() == null || other.getServiceIds().equals(this.getServiceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceIds() == null ? 0 : this.getServiceIds().hashCode());
        return hashCode;
    }

    public TraceUser clone() {
        try {
            return (TraceUser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TraceUserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

