/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.SamplingStatisticsDocument;
import java.util.Date;

@SdkInternalApi
public class SamplingStatisticsDocumentMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleName").build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientID").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> REQUESTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestCount").build();
    private static final MarshallingInfo<Integer> SAMPLEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampledCount").build();
    private static final MarshallingInfo<Integer> BORROWCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BorrowCount").build();
    private static final SamplingStatisticsDocumentMarshaller instance = new SamplingStatisticsDocumentMarshaller();

    public static SamplingStatisticsDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(SamplingStatisticsDocument samplingStatisticsDocument, ProtocolMarshaller protocolMarshaller) {
        if (samplingStatisticsDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getRuleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getClientID(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getRequestCount(), REQUESTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getSampledCount(), SAMPLEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)samplingStatisticsDocument.getBorrowCount(), BORROWCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

