/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspacesweb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspacesweb.model.IpRule;
import com.amazonaws.services.workspacesweb.model.transform.IpAccessSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IpAccessSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> additionalEncryptionContext;
    private List<String> associatedPortalArns;
    private Date creationDate;
    private String customerManagedKey;
    private String description;
    private String displayName;
    private String ipAccessSettingsArn;
    private List<IpRule> ipRules;

    public Map<String, String> getAdditionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.additionalEncryptionContext = additionalEncryptionContext;
    }

    public IpAccessSettings withAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
        this.setAdditionalEncryptionContext(additionalEncryptionContext);
        return this;
    }

    public IpAccessSettings addAdditionalEncryptionContextEntry(String key, String value) {
        if (null == this.additionalEncryptionContext) {
            this.additionalEncryptionContext = new HashMap<String, String>();
        }
        if (this.additionalEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalEncryptionContext.put(key, value);
        return this;
    }

    public IpAccessSettings clearAdditionalEncryptionContextEntries() {
        this.additionalEncryptionContext = null;
        return this;
    }

    public List<String> getAssociatedPortalArns() {
        return this.associatedPortalArns;
    }

    public void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
        if (associatedPortalArns == null) {
            this.associatedPortalArns = null;
            return;
        }
        this.associatedPortalArns = new ArrayList<String>(associatedPortalArns);
    }

    public IpAccessSettings withAssociatedPortalArns(String ... associatedPortalArns) {
        if (this.associatedPortalArns == null) {
            this.setAssociatedPortalArns(new ArrayList<String>(associatedPortalArns.length));
        }
        for (String ele : associatedPortalArns) {
            this.associatedPortalArns.add(ele);
        }
        return this;
    }

    public IpAccessSettings withAssociatedPortalArns(Collection<String> associatedPortalArns) {
        this.setAssociatedPortalArns(associatedPortalArns);
        return this;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public IpAccessSettings withCreationDate(Date creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setCustomerManagedKey(String customerManagedKey) {
        this.customerManagedKey = customerManagedKey;
    }

    public String getCustomerManagedKey() {
        return this.customerManagedKey;
    }

    public IpAccessSettings withCustomerManagedKey(String customerManagedKey) {
        this.setCustomerManagedKey(customerManagedKey);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public IpAccessSettings withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IpAccessSettings withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public void setIpAccessSettingsArn(String ipAccessSettingsArn) {
        this.ipAccessSettingsArn = ipAccessSettingsArn;
    }

    public String getIpAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public IpAccessSettings withIpAccessSettingsArn(String ipAccessSettingsArn) {
        this.setIpAccessSettingsArn(ipAccessSettingsArn);
        return this;
    }

    public List<IpRule> getIpRules() {
        return this.ipRules;
    }

    public void setIpRules(Collection<IpRule> ipRules) {
        if (ipRules == null) {
            this.ipRules = null;
            return;
        }
        this.ipRules = new ArrayList<IpRule>(ipRules);
    }

    public IpAccessSettings withIpRules(IpRule ... ipRules) {
        if (this.ipRules == null) {
            this.setIpRules(new ArrayList<IpRule>(ipRules.length));
        }
        for (IpRule ele : ipRules) {
            this.ipRules.add(ele);
        }
        return this;
    }

    public IpAccessSettings withIpRules(Collection<IpRule> ipRules) {
        this.setIpRules(ipRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalEncryptionContext() != null) {
            sb.append("AdditionalEncryptionContext: ").append(this.getAdditionalEncryptionContext()).append(",");
        }
        if (this.getAssociatedPortalArns() != null) {
            sb.append("AssociatedPortalArns: ").append(this.getAssociatedPortalArns()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getCustomerManagedKey() != null) {
            sb.append("CustomerManagedKey: ").append(this.getCustomerManagedKey()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getIpAccessSettingsArn() != null) {
            sb.append("IpAccessSettingsArn: ").append(this.getIpAccessSettingsArn()).append(",");
        }
        if (this.getIpRules() != null) {
            sb.append("IpRules: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettings)) {
            return false;
        }
        IpAccessSettings other = (IpAccessSettings)obj;
        if (other.getAdditionalEncryptionContext() == null ^ this.getAdditionalEncryptionContext() == null) {
            return false;
        }
        if (other.getAdditionalEncryptionContext() != null && !other.getAdditionalEncryptionContext().equals(this.getAdditionalEncryptionContext())) {
            return false;
        }
        if (other.getAssociatedPortalArns() == null ^ this.getAssociatedPortalArns() == null) {
            return false;
        }
        if (other.getAssociatedPortalArns() != null && !other.getAssociatedPortalArns().equals(this.getAssociatedPortalArns())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getCustomerManagedKey() == null ^ this.getCustomerManagedKey() == null) {
            return false;
        }
        if (other.getCustomerManagedKey() != null && !other.getCustomerManagedKey().equals(this.getCustomerManagedKey())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getIpAccessSettingsArn() == null ^ this.getIpAccessSettingsArn() == null) {
            return false;
        }
        if (other.getIpAccessSettingsArn() != null && !other.getIpAccessSettingsArn().equals(this.getIpAccessSettingsArn())) {
            return false;
        }
        if (other.getIpRules() == null ^ this.getIpRules() == null) {
            return false;
        }
        return other.getIpRules() == null || other.getIpRules().equals(this.getIpRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalEncryptionContext() == null ? 0 : this.getAdditionalEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedPortalArns() == null ? 0 : this.getAssociatedPortalArns().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerManagedKey() == null ? 0 : this.getCustomerManagedKey().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getIpAccessSettingsArn() == null ? 0 : this.getIpAccessSettingsArn().hashCode());
        hashCode = 31 * hashCode + (this.getIpRules() == null ? 0 : this.getIpRules().hashCode());
        return hashCode;
    }

    public IpAccessSettings clone() {
        try {
            return (IpAccessSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IpAccessSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

