/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.IpRuleItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AuthorizeIpRulesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String groupId;
    private SdkInternalList<IpRuleItem> userRules;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public AuthorizeIpRulesRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public List<IpRuleItem> getUserRules() {
        if (this.userRules == null) {
            this.userRules = new SdkInternalList();
        }
        return this.userRules;
    }

    public void setUserRules(Collection<IpRuleItem> userRules) {
        if (userRules == null) {
            this.userRules = null;
            return;
        }
        this.userRules = new SdkInternalList(userRules);
    }

    public AuthorizeIpRulesRequest withUserRules(IpRuleItem ... userRules) {
        if (this.userRules == null) {
            this.setUserRules((Collection<IpRuleItem>)new SdkInternalList(userRules.length));
        }
        for (IpRuleItem ele : userRules) {
            this.userRules.add((Object)ele);
        }
        return this;
    }

    public AuthorizeIpRulesRequest withUserRules(Collection<IpRuleItem> userRules) {
        this.setUserRules(userRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getUserRules() != null) {
            sb.append("UserRules: ").append(this.getUserRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeIpRulesRequest)) {
            return false;
        }
        AuthorizeIpRulesRequest other = (AuthorizeIpRulesRequest)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getUserRules() == null ^ this.getUserRules() == null) {
            return false;
        }
        return other.getUserRules() == null || other.getUserRules().equals(this.getUserRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getUserRules() == null ? 0 : this.getUserRules().hashCode());
        return hashCode;
    }

    public AuthorizeIpRulesRequest clone() {
        return (AuthorizeIpRulesRequest)super.clone();
    }
}

