/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.wellarchitected.model.ImportLensRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.Map;

@SdkInternalApi
public class ImportLensRequestMarshaller {
    private static final MarshallingInfo<String> LENSALIAS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LensAlias").build();
    private static final MarshallingInfo<String> JSONSTRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JSONString").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ImportLensRequestMarshaller instance = new ImportLensRequestMarshaller();

    public static ImportLensRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportLensRequest importLensRequest, ProtocolMarshaller protocolMarshaller) {
        if (importLensRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importLensRequest.getLensAlias(), LENSALIAS_BINDING);
            protocolMarshaller.marshall((Object)importLensRequest.getJSONString(), JSONSTRING_BINDING);
            protocolMarshaller.marshall((Object)importLensRequest.getClientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall(importLensRequest.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

