/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wellarchitected.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wellarchitected.model.BestPractice;
import com.amazonaws.services.wellarchitected.model.Risk;
import com.amazonaws.services.wellarchitected.model.transform.QuestionMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QuestionMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String questionId;
    private String risk;
    private List<BestPractice> bestPractices;

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public QuestionMetric withQuestionId(String questionId) {
        this.setQuestionId(questionId);
        return this;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public String getRisk() {
        return this.risk;
    }

    public QuestionMetric withRisk(String risk) {
        this.setRisk(risk);
        return this;
    }

    public QuestionMetric withRisk(Risk risk) {
        this.risk = risk.toString();
        return this;
    }

    public List<BestPractice> getBestPractices() {
        return this.bestPractices;
    }

    public void setBestPractices(Collection<BestPractice> bestPractices) {
        if (bestPractices == null) {
            this.bestPractices = null;
            return;
        }
        this.bestPractices = new ArrayList<BestPractice>(bestPractices);
    }

    public QuestionMetric withBestPractices(BestPractice ... bestPractices) {
        if (this.bestPractices == null) {
            this.setBestPractices(new ArrayList<BestPractice>(bestPractices.length));
        }
        for (BestPractice ele : bestPractices) {
            this.bestPractices.add(ele);
        }
        return this;
    }

    public QuestionMetric withBestPractices(Collection<BestPractice> bestPractices) {
        this.setBestPractices(bestPractices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuestionId() != null) {
            sb.append("QuestionId: ").append(this.getQuestionId()).append(",");
        }
        if (this.getRisk() != null) {
            sb.append("Risk: ").append(this.getRisk()).append(",");
        }
        if (this.getBestPractices() != null) {
            sb.append("BestPractices: ").append(this.getBestPractices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuestionMetric)) {
            return false;
        }
        QuestionMetric other = (QuestionMetric)obj;
        if (other.getQuestionId() == null ^ this.getQuestionId() == null) {
            return false;
        }
        if (other.getQuestionId() != null && !other.getQuestionId().equals(this.getQuestionId())) {
            return false;
        }
        if (other.getRisk() == null ^ this.getRisk() == null) {
            return false;
        }
        if (other.getRisk() != null && !other.getRisk().equals(this.getRisk())) {
            return false;
        }
        if (other.getBestPractices() == null ^ this.getBestPractices() == null) {
            return false;
        }
        return other.getBestPractices() == null || other.getBestPractices().equals(this.getBestPractices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuestionId() == null ? 0 : this.getQuestionId().hashCode());
        hashCode = 31 * hashCode + (this.getRisk() == null ? 0 : this.getRisk().hashCode());
        hashCode = 31 * hashCode + (this.getBestPractices() == null ? 0 : this.getBestPractices().hashCode());
        return hashCode;
    }

    public QuestionMetric clone() {
        try {
            return (QuestionMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuestionMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

