/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreaminfluxdb;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.timestreaminfluxdb.AWSTimestreamInfluxDB;
import com.amazonaws.services.timestreaminfluxdb.AWSTimestreamInfluxDBClientBuilder;
import com.amazonaws.services.timestreaminfluxdb.model.AWSTimestreamInfluxDBException;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbParameterGroupRequest;
import com.amazonaws.services.timestreaminfluxdb.model.CreateDbParameterGroupResult;
import com.amazonaws.services.timestreaminfluxdb.model.DeleteDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.DeleteDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbParameterGroupRequest;
import com.amazonaws.services.timestreaminfluxdb.model.GetDbParameterGroupResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbInstancesRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbInstancesResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbParameterGroupsRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListDbParameterGroupsResult;
import com.amazonaws.services.timestreaminfluxdb.model.ListTagsForResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.ListTagsForResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.TagResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.TagResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.UntagResourceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.UntagResourceResult;
import com.amazonaws.services.timestreaminfluxdb.model.UpdateDbInstanceRequest;
import com.amazonaws.services.timestreaminfluxdb.model.UpdateDbInstanceResult;
import com.amazonaws.services.timestreaminfluxdb.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.CreateDbInstanceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.CreateDbInstanceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.CreateDbParameterGroupRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.CreateDbParameterGroupResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.DeleteDbInstanceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.DeleteDbInstanceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.GetDbInstanceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.GetDbInstanceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.GetDbParameterGroupRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.GetDbParameterGroupResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListDbInstancesRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListDbInstancesResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListDbParameterGroupsRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListDbParameterGroupsResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.UpdateDbInstanceRequestProtocolMarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.UpdateDbInstanceResultJsonUnmarshaller;
import com.amazonaws.services.timestreaminfluxdb.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSTimestreamInfluxDBClient
extends AmazonWebServiceClient
implements AWSTimestreamInfluxDB {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSTimestreamInfluxDB.class);
    private static final String DEFAULT_SIGNING_NAME = "timestream-influxdb";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSTimestreamInfluxDBException.class));

    public static AWSTimestreamInfluxDBClientBuilder builder() {
        return AWSTimestreamInfluxDBClientBuilder.standard();
    }

    AWSTimestreamInfluxDBClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSTimestreamInfluxDBClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("timestream-influxdb.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/timestreaminfluxdb/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/timestreaminfluxdb/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDbInstanceResult createDbInstance(CreateDbInstanceRequest request) {
        request = (CreateDbInstanceRequest)this.beforeClientExecution(request);
        return this.executeCreateDbInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDbInstanceResult executeCreateDbInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDbInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDbInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDbInstanceRequestProtocolMarshaller(protocolFactory).marshall((CreateDbInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDbInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDbInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDbInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDbInstanceResult createDbInstanceResult = (CreateDbInstanceResult)response.getAwsResponse();
            return createDbInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDbParameterGroupResult createDbParameterGroup(CreateDbParameterGroupRequest request) {
        request = (CreateDbParameterGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateDbParameterGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDbParameterGroupResult executeCreateDbParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDbParameterGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDbParameterGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDbParameterGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateDbParameterGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDbParameterGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDbParameterGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDbParameterGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDbParameterGroupResult createDbParameterGroupResult = (CreateDbParameterGroupResult)response.getAwsResponse();
            return createDbParameterGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDbInstanceResult deleteDbInstance(DeleteDbInstanceRequest request) {
        request = (DeleteDbInstanceRequest)this.beforeClientExecution(request);
        return this.executeDeleteDbInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDbInstanceResult executeDeleteDbInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDbInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDbInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDbInstanceRequestProtocolMarshaller(protocolFactory).marshall((DeleteDbInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDbInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDbInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDbInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDbInstanceResult deleteDbInstanceResult = (DeleteDbInstanceResult)response.getAwsResponse();
            return deleteDbInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDbInstanceResult getDbInstance(GetDbInstanceRequest request) {
        request = (GetDbInstanceRequest)this.beforeClientExecution(request);
        return this.executeGetDbInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDbInstanceResult executeGetDbInstance(GetDbInstanceRequest getDbInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDbInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDbInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDbInstanceRequestProtocolMarshaller(protocolFactory).marshall((GetDbInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDbInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDbInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDbInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDbInstanceResult getDbInstanceResult = (GetDbInstanceResult)response.getAwsResponse();
            return getDbInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDbParameterGroupResult getDbParameterGroup(GetDbParameterGroupRequest request) {
        request = (GetDbParameterGroupRequest)this.beforeClientExecution(request);
        return this.executeGetDbParameterGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDbParameterGroupResult executeGetDbParameterGroup(GetDbParameterGroupRequest getDbParameterGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDbParameterGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDbParameterGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDbParameterGroupRequestProtocolMarshaller(protocolFactory).marshall((GetDbParameterGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDbParameterGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDbParameterGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDbParameterGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDbParameterGroupResult getDbParameterGroupResult = (GetDbParameterGroupResult)response.getAwsResponse();
            return getDbParameterGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDbInstancesResult listDbInstances(ListDbInstancesRequest request) {
        request = (ListDbInstancesRequest)this.beforeClientExecution(request);
        return this.executeListDbInstances(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDbInstancesResult executeListDbInstances(ListDbInstancesRequest listDbInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDbInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDbInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDbInstancesRequestProtocolMarshaller(protocolFactory).marshall((ListDbInstancesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDbInstancesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDbInstances");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDbInstancesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDbInstancesResult listDbInstancesResult = (ListDbInstancesResult)response.getAwsResponse();
            return listDbInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDbParameterGroupsResult listDbParameterGroups(ListDbParameterGroupsRequest request) {
        request = (ListDbParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executeListDbParameterGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDbParameterGroupsResult executeListDbParameterGroups(ListDbParameterGroupsRequest listDbParameterGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDbParameterGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDbParameterGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDbParameterGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListDbParameterGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDbParameterGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDbParameterGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDbParameterGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDbParameterGroupsResult listDbParameterGroupsResult = (ListDbParameterGroupsResult)response.getAwsResponse();
            return listDbParameterGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDbInstanceResult updateDbInstance(UpdateDbInstanceRequest request) {
        request = (UpdateDbInstanceRequest)this.beforeClientExecution(request);
        return this.executeUpdateDbInstance(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDbInstanceResult executeUpdateDbInstance(UpdateDbInstanceRequest updateDbInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDbInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDbInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDbInstanceRequestProtocolMarshaller(protocolFactory).marshall((UpdateDbInstanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDbInstanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Timestream InfluxDB");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDbInstance");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDbInstanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDbInstanceResult updateDbInstanceResult = (UpdateDbInstanceResult)response.getAwsResponse();
            return updateDbInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

