/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model;

import com.amazonaws.services.taxsettings.model.AWSTaxSettingsException;
import com.amazonaws.services.taxsettings.model.ValidationExceptionErrorCode;
import com.amazonaws.services.taxsettings.model.ValidationExceptionField;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidationException
extends AWSTaxSettingsException {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private List<ValidationExceptionField> fieldList;

    public ValidationException(String message) {
        super(message);
    }

    @JsonProperty(value="errorCode")
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public ValidationException withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public ValidationException withErrorCode(ValidationExceptionErrorCode errorCode) {
        this.errorCode = errorCode.toString();
        return this;
    }

    @JsonProperty(value="fieldList")
    public List<ValidationExceptionField> getFieldList() {
        return this.fieldList;
    }

    @JsonProperty(value="fieldList")
    public void setFieldList(Collection<ValidationExceptionField> fieldList) {
        if (fieldList == null) {
            this.fieldList = null;
            return;
        }
        this.fieldList = new ArrayList<ValidationExceptionField>(fieldList);
    }

    public ValidationException withFieldList(ValidationExceptionField ... fieldList) {
        if (this.fieldList == null) {
            this.setFieldList(new ArrayList<ValidationExceptionField>(fieldList.length));
        }
        for (ValidationExceptionField ele : fieldList) {
            this.fieldList.add(ele);
        }
        return this;
    }

    public ValidationException withFieldList(Collection<ValidationExceptionField> fieldList) {
        this.setFieldList(fieldList);
        return this;
    }
}

