/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String volumeARN;
    private String snapshotDescription;
    private SdkInternalList<Tag> tags;

    public void setVolumeARN(String volumeARN) {
        this.volumeARN = volumeARN;
    }

    public String getVolumeARN() {
        return this.volumeARN;
    }

    public CreateSnapshotRequest withVolumeARN(String volumeARN) {
        this.setVolumeARN(volumeARN);
        return this;
    }

    public void setSnapshotDescription(String snapshotDescription) {
        this.snapshotDescription = snapshotDescription;
    }

    public String getSnapshotDescription() {
        return this.snapshotDescription;
    }

    public CreateSnapshotRequest withSnapshotDescription(String snapshotDescription) {
        this.setSnapshotDescription(snapshotDescription);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateSnapshotRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateSnapshotRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeARN() != null) {
            sb.append("VolumeARN: ").append(this.getVolumeARN()).append(",");
        }
        if (this.getSnapshotDescription() != null) {
            sb.append("SnapshotDescription: ").append(this.getSnapshotDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)obj;
        if (other.getVolumeARN() == null ^ this.getVolumeARN() == null) {
            return false;
        }
        if (other.getVolumeARN() != null && !other.getVolumeARN().equals(this.getVolumeARN())) {
            return false;
        }
        if (other.getSnapshotDescription() == null ^ this.getSnapshotDescription() == null) {
            return false;
        }
        if (other.getSnapshotDescription() != null && !other.getSnapshotDescription().equals(this.getSnapshotDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeARN() == null ? 0 : this.getVolumeARN().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotDescription() == null ? 0 : this.getSnapshotDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateSnapshotRequest clone() {
        return (CreateSnapshotRequest)super.clone();
    }
}

