/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.FileShareInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListFileSharesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private String nextMarker;
    private SdkInternalList<FileShareInfo> fileShareInfoList;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListFileSharesResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListFileSharesResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public List<FileShareInfo> getFileShareInfoList() {
        if (this.fileShareInfoList == null) {
            this.fileShareInfoList = new SdkInternalList();
        }
        return this.fileShareInfoList;
    }

    public void setFileShareInfoList(Collection<FileShareInfo> fileShareInfoList) {
        if (fileShareInfoList == null) {
            this.fileShareInfoList = null;
            return;
        }
        this.fileShareInfoList = new SdkInternalList(fileShareInfoList);
    }

    public ListFileSharesResult withFileShareInfoList(FileShareInfo ... fileShareInfoList) {
        if (this.fileShareInfoList == null) {
            this.setFileShareInfoList((Collection<FileShareInfo>)new SdkInternalList(fileShareInfoList.length));
        }
        for (FileShareInfo ele : fileShareInfoList) {
            this.fileShareInfoList.add((Object)ele);
        }
        return this;
    }

    public ListFileSharesResult withFileShareInfoList(Collection<FileShareInfo> fileShareInfoList) {
        this.setFileShareInfoList(fileShareInfoList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getFileShareInfoList() != null) {
            sb.append("FileShareInfoList: ").append(this.getFileShareInfoList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFileSharesResult)) {
            return false;
        }
        ListFileSharesResult other = (ListFileSharesResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getFileShareInfoList() == null ^ this.getFileShareInfoList() == null) {
            return false;
        }
        return other.getFileShareInfoList() == null || other.getFileShareInfoList().equals(this.getFileShareInfoList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getFileShareInfoList() == null ? 0 : this.getFileShareInfoList().hashCode());
        return hashCode;
    }

    public ListFileSharesResult clone() {
        try {
            return (ListFileSharesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

