/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.internal.JacksonUtils;
import com.amazonaws.services.stepfunctions.builder.states.Branch;
import com.amazonaws.services.stepfunctions.builder.states.Catcher;
import com.amazonaws.services.stepfunctions.builder.states.InputOutputResultPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.ParametersBuilder;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.ResultSelectorBuilder;
import com.amazonaws.services.stepfunctions.builder.states.Retrier;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.TransitionStateBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.List;

public final class ParallelState
extends TransitionState {
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="Branches")
    private final List<Branch> branches;
    @JsonUnwrapped
    private final PathContainer pathContainer;
    @JsonUnwrapped
    private final Transition transition;
    @JsonProperty(value="Retry")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Retrier> retriers;
    @JsonProperty(value="Catch")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Catcher> catchers;

    private ParallelState(Builder builder) {
        this.comment = builder.comment;
        this.branches = Buildable.Utils.build(builder.branches);
        this.pathContainer = builder.pathContainer.build();
        this.transition = (Transition)builder.transition.build();
        this.retriers = Buildable.Utils.build(builder.retriers);
        this.catchers = Buildable.Utils.build(builder.catchers);
    }

    @Override
    public String getType() {
        return "Parallel";
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.pathContainer.getInputPath();
    }

    @JsonIgnore
    public String getResultPath() {
        return this.pathContainer.getResultPath();
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.pathContainer.getOutputPath();
    }

    @JsonIgnore
    public String getParameters() {
        return JacksonUtils.jsonToString(this.pathContainer.getParameters());
    }

    public List<Retrier> getRetriers() {
        return this.retriers;
    }

    public List<Catcher> getCatchers() {
        return this.catchers;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TransitionStateBuilder
    implements InputOutputResultPathBuilder<Builder>,
    ParametersBuilder<Builder>,
    ResultSelectorBuilder<Builder> {
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="Branches")
        private List<Branch.Builder> branches = new ArrayList<Branch.Builder>();
        @JsonUnwrapped
        private final PathContainer.Builder pathContainer = PathContainer.builder();
        private Transition.Builder transition = Transition.NULL_BUILDER;
        @JsonProperty(value="Retry")
        private List<Retrier.Builder> retriers = new ArrayList<Retrier.Builder>();
        @JsonProperty(value="Catch")
        private List<Catcher.Builder> catchers = new ArrayList<Catcher.Builder>();

        private Builder() {
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder branch(Branch.Builder branchBuilder) {
            this.branches.add(branchBuilder);
            return this;
        }

        public Builder branches(Branch.Builder ... branchBuilders) {
            for (Branch.Builder branchBuilder : branchBuilders) {
                this.branch(branchBuilder);
            }
            return this;
        }

        @Override
        public Builder inputPath(String inputPath) {
            this.pathContainer.inputPath(inputPath);
            return this;
        }

        @Override
        public Builder resultPath(String resultPath) {
            this.pathContainer.resultPath(resultPath);
            return this;
        }

        @Override
        public Builder outputPath(String outputPath) {
            this.pathContainer.outputPath(outputPath);
            return this;
        }

        @Override
        public Builder parameters(String parameters) {
            this.pathContainer.parameters(JacksonUtils.stringToJsonNode("Parameters", parameters));
            return this;
        }

        @Override
        public Builder parameters(Object parameters) {
            this.pathContainer.parameters(JacksonUtils.objectToJsonNode(parameters));
            return this;
        }

        @Override
        public Builder resultSelector(String resultSelector) {
            this.pathContainer.resultSelector(JacksonUtils.stringToJsonNode("ResultSelector", resultSelector));
            return this;
        }

        @Override
        public Builder resultSelector(Object resultSelector) {
            this.pathContainer.resultSelector(JacksonUtils.objectToJsonNode(resultSelector));
            return this;
        }

        @Override
        public Builder transition(Transition.Builder builder) {
            this.transition = builder;
            return this;
        }

        public Builder retriers(Retrier.Builder ... retrierBuilders) {
            for (Retrier.Builder retrierBuilder : retrierBuilders) {
                this.retrier(retrierBuilder);
            }
            return this;
        }

        public Builder retrier(Retrier.Builder retrierBuilder) {
            this.retriers.add(retrierBuilder);
            return this;
        }

        public Builder catchers(Catcher.Builder ... catcherBuilders) {
            for (Catcher.Builder catcherBuilder : catcherBuilders) {
                this.catcher(catcherBuilder);
            }
            return this;
        }

        public Builder catcher(Catcher.Builder catcherBuilder) {
            this.catchers.add(catcherBuilder);
            return this;
        }

        @Override
        public ParallelState build() {
            return new ParallelState(this);
        }
    }
}

