/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmsap.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmsap.model.IpAddressMember;
import com.amazonaws.services.ssmsap.model.transform.AssociatedHostMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssociatedHost
implements Serializable,
Cloneable,
StructuredPojo {
    private String hostname;
    private String ec2InstanceId;
    private List<IpAddressMember> ipAddresses;
    private String osVersion;

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public AssociatedHost withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    public AssociatedHost withEc2InstanceId(String ec2InstanceId) {
        this.setEc2InstanceId(ec2InstanceId);
        return this;
    }

    public List<IpAddressMember> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(Collection<IpAddressMember> ipAddresses) {
        if (ipAddresses == null) {
            this.ipAddresses = null;
            return;
        }
        this.ipAddresses = new ArrayList<IpAddressMember>(ipAddresses);
    }

    public AssociatedHost withIpAddresses(IpAddressMember ... ipAddresses) {
        if (this.ipAddresses == null) {
            this.setIpAddresses(new ArrayList<IpAddressMember>(ipAddresses.length));
        }
        for (IpAddressMember ele : ipAddresses) {
            this.ipAddresses.add(ele);
        }
        return this;
    }

    public AssociatedHost withIpAddresses(Collection<IpAddressMember> ipAddresses) {
        this.setIpAddresses(ipAddresses);
        return this;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public AssociatedHost withOsVersion(String osVersion) {
        this.setOsVersion(osVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getEc2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(this.getEc2InstanceId()).append(",");
        }
        if (this.getIpAddresses() != null) {
            sb.append("IpAddresses: ").append(this.getIpAddresses()).append(",");
        }
        if (this.getOsVersion() != null) {
            sb.append("OsVersion: ").append(this.getOsVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedHost)) {
            return false;
        }
        AssociatedHost other = (AssociatedHost)obj;
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null) {
            return false;
        }
        if (other.getEc2InstanceId() != null && !other.getEc2InstanceId().equals(this.getEc2InstanceId())) {
            return false;
        }
        if (other.getIpAddresses() == null ^ this.getIpAddresses() == null) {
            return false;
        }
        if (other.getIpAddresses() != null && !other.getIpAddresses().equals(this.getIpAddresses())) {
            return false;
        }
        if (other.getOsVersion() == null ^ this.getOsVersion() == null) {
            return false;
        }
        return other.getOsVersion() == null || other.getOsVersion().equals(this.getOsVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceId() == null ? 0 : this.getEc2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddresses() == null ? 0 : this.getIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getOsVersion() == null ? 0 : this.getOsVersion().hashCode());
        return hashCode;
    }

    public AssociatedHost clone() {
        try {
            return (AssociatedHost)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociatedHostMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

