/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.Target;
import com.amazonaws.services.ssmcontacts.model.transform.StageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Stage
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer durationInMinutes;
    private List<Target> targets;

    public void setDurationInMinutes(Integer durationInMinutes) {
        this.durationInMinutes = durationInMinutes;
    }

    public Integer getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public Stage withDurationInMinutes(Integer durationInMinutes) {
        this.setDurationInMinutes(durationInMinutes);
        return this;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<Target>(targets);
    }

    public Stage withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<Target>(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public Stage withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDurationInMinutes() != null) {
            sb.append("DurationInMinutes: ").append(this.getDurationInMinutes()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage)obj;
        if (other.getDurationInMinutes() == null ^ this.getDurationInMinutes() == null) {
            return false;
        }
        if (other.getDurationInMinutes() != null && !other.getDurationInMinutes().equals(this.getDurationInMinutes())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        return other.getTargets() == null || other.getTargets().equals(this.getTargets());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDurationInMinutes() == null ? 0 : this.getDurationInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        return hashCode;
    }

    public Stage clone() {
        try {
            return (Stage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

