/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.transform.PreviewOverrideMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PreviewOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> newMembers;
    private Date startTime;
    private Date endTime;

    public List<String> getNewMembers() {
        return this.newMembers;
    }

    public void setNewMembers(Collection<String> newMembers) {
        if (newMembers == null) {
            this.newMembers = null;
            return;
        }
        this.newMembers = new ArrayList<String>(newMembers);
    }

    public PreviewOverride withNewMembers(String ... newMembers) {
        if (this.newMembers == null) {
            this.setNewMembers(new ArrayList<String>(newMembers.length));
        }
        for (String ele : newMembers) {
            this.newMembers.add(ele);
        }
        return this;
    }

    public PreviewOverride withNewMembers(Collection<String> newMembers) {
        this.setNewMembers(newMembers);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public PreviewOverride withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PreviewOverride withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNewMembers() != null) {
            sb.append("NewMembers: ").append(this.getNewMembers()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewOverride)) {
            return false;
        }
        PreviewOverride other = (PreviewOverride)obj;
        if (other.getNewMembers() == null ^ this.getNewMembers() == null) {
            return false;
        }
        if (other.getNewMembers() != null && !other.getNewMembers().equals(this.getNewMembers())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        return other.getEndTime() == null || other.getEndTime().equals(this.getEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNewMembers() == null ? 0 : this.getNewMembers().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        return hashCode;
    }

    public PreviewOverride clone() {
        try {
            return (PreviewOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PreviewOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

