/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.AutomationExecutionStatus;
import com.amazonaws.services.simplesystemsmanagement.model.FailureDetails;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.TargetLocation;
import com.amazonaws.services.simplesystemsmanagement.model.transform.StepExecutionMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String stepName;
    private String action;
    private Long timeoutSeconds;
    private String onFailure;
    private Integer maxAttempts;
    private Date executionStartTime;
    private Date executionEndTime;
    private String stepStatus;
    private String responseCode;
    private Map<String, String> inputs;
    private Map<String, List<String>> outputs;
    private String response;
    private String failureMessage;
    private FailureDetails failureDetails;
    private String stepExecutionId;
    private Map<String, List<String>> overriddenParameters;
    private Boolean isEnd;
    private String nextStep;
    private Boolean isCritical;
    private SdkInternalList<String> validNextSteps;
    private SdkInternalList<Target> targets;
    private TargetLocation targetLocation;

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public String getStepName() {
        return this.stepName;
    }

    public StepExecution withStepName(String stepName) {
        this.setStepName(stepName);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public StepExecution withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public StepExecution withTimeoutSeconds(Long timeoutSeconds) {
        this.setTimeoutSeconds(timeoutSeconds);
        return this;
    }

    public void setOnFailure(String onFailure) {
        this.onFailure = onFailure;
    }

    public String getOnFailure() {
        return this.onFailure;
    }

    public StepExecution withOnFailure(String onFailure) {
        this.setOnFailure(onFailure);
        return this;
    }

    public void setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public StepExecution withMaxAttempts(Integer maxAttempts) {
        this.setMaxAttempts(maxAttempts);
        return this;
    }

    public void setExecutionStartTime(Date executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public Date getExecutionStartTime() {
        return this.executionStartTime;
    }

    public StepExecution withExecutionStartTime(Date executionStartTime) {
        this.setExecutionStartTime(executionStartTime);
        return this;
    }

    public void setExecutionEndTime(Date executionEndTime) {
        this.executionEndTime = executionEndTime;
    }

    public Date getExecutionEndTime() {
        return this.executionEndTime;
    }

    public StepExecution withExecutionEndTime(Date executionEndTime) {
        this.setExecutionEndTime(executionEndTime);
        return this;
    }

    public void setStepStatus(String stepStatus) {
        this.stepStatus = stepStatus;
    }

    public String getStepStatus() {
        return this.stepStatus;
    }

    public StepExecution withStepStatus(String stepStatus) {
        this.setStepStatus(stepStatus);
        return this;
    }

    public void setStepStatus(AutomationExecutionStatus stepStatus) {
        this.withStepStatus(stepStatus);
    }

    public StepExecution withStepStatus(AutomationExecutionStatus stepStatus) {
        this.stepStatus = stepStatus.toString();
        return this;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public StepExecution withResponseCode(String responseCode) {
        this.setResponseCode(responseCode);
        return this;
    }

    public Map<String, String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, String> inputs) {
        this.inputs = inputs;
    }

    public StepExecution withInputs(Map<String, String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public StepExecution addInputsEntry(String key, String value) {
        if (null == this.inputs) {
            this.inputs = new HashMap<String, String>();
        }
        if (this.inputs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.inputs.put(key, value);
        return this;
    }

    public StepExecution clearInputsEntries() {
        this.inputs = null;
        return this;
    }

    public Map<String, List<String>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, List<String>> outputs) {
        this.outputs = outputs;
    }

    public StepExecution withOutputs(Map<String, List<String>> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public StepExecution addOutputsEntry(String key, List<String> value) {
        if (null == this.outputs) {
            this.outputs = new HashMap<String, List<String>>();
        }
        if (this.outputs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.outputs.put(key, value);
        return this;
    }

    public StepExecution clearOutputsEntries() {
        this.outputs = null;
        return this;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    public StepExecution withResponse(String response) {
        this.setResponse(response);
        return this;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public StepExecution withFailureMessage(String failureMessage) {
        this.setFailureMessage(failureMessage);
        return this;
    }

    public void setFailureDetails(FailureDetails failureDetails) {
        this.failureDetails = failureDetails;
    }

    public FailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    public StepExecution withFailureDetails(FailureDetails failureDetails) {
        this.setFailureDetails(failureDetails);
        return this;
    }

    public void setStepExecutionId(String stepExecutionId) {
        this.stepExecutionId = stepExecutionId;
    }

    public String getStepExecutionId() {
        return this.stepExecutionId;
    }

    public StepExecution withStepExecutionId(String stepExecutionId) {
        this.setStepExecutionId(stepExecutionId);
        return this;
    }

    public Map<String, List<String>> getOverriddenParameters() {
        return this.overriddenParameters;
    }

    public void setOverriddenParameters(Map<String, List<String>> overriddenParameters) {
        this.overriddenParameters = overriddenParameters;
    }

    public StepExecution withOverriddenParameters(Map<String, List<String>> overriddenParameters) {
        this.setOverriddenParameters(overriddenParameters);
        return this;
    }

    public StepExecution addOverriddenParametersEntry(String key, List<String> value) {
        if (null == this.overriddenParameters) {
            this.overriddenParameters = new HashMap<String, List<String>>();
        }
        if (this.overriddenParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.overriddenParameters.put(key, value);
        return this;
    }

    public StepExecution clearOverriddenParametersEntries() {
        this.overriddenParameters = null;
        return this;
    }

    public void setIsEnd(Boolean isEnd) {
        this.isEnd = isEnd;
    }

    public Boolean getIsEnd() {
        return this.isEnd;
    }

    public StepExecution withIsEnd(Boolean isEnd) {
        this.setIsEnd(isEnd);
        return this;
    }

    public Boolean isEnd() {
        return this.isEnd;
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public String getNextStep() {
        return this.nextStep;
    }

    public StepExecution withNextStep(String nextStep) {
        this.setNextStep(nextStep);
        return this;
    }

    public void setIsCritical(Boolean isCritical) {
        this.isCritical = isCritical;
    }

    public Boolean getIsCritical() {
        return this.isCritical;
    }

    public StepExecution withIsCritical(Boolean isCritical) {
        this.setIsCritical(isCritical);
        return this;
    }

    public Boolean isCritical() {
        return this.isCritical;
    }

    public List<String> getValidNextSteps() {
        if (this.validNextSteps == null) {
            this.validNextSteps = new SdkInternalList();
        }
        return this.validNextSteps;
    }

    public void setValidNextSteps(Collection<String> validNextSteps) {
        if (validNextSteps == null) {
            this.validNextSteps = null;
            return;
        }
        this.validNextSteps = new SdkInternalList(validNextSteps);
    }

    public StepExecution withValidNextSteps(String ... validNextSteps) {
        if (this.validNextSteps == null) {
            this.setValidNextSteps((Collection<String>)new SdkInternalList(validNextSteps.length));
        }
        for (String ele : validNextSteps) {
            this.validNextSteps.add((Object)ele);
        }
        return this;
    }

    public StepExecution withValidNextSteps(Collection<String> validNextSteps) {
        this.setValidNextSteps(validNextSteps);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public StepExecution withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public StepExecution withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setTargetLocation(TargetLocation targetLocation) {
        this.targetLocation = targetLocation;
    }

    public TargetLocation getTargetLocation() {
        return this.targetLocation;
    }

    public StepExecution withTargetLocation(TargetLocation targetLocation) {
        this.setTargetLocation(targetLocation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStepName() != null) {
            sb.append("StepName: ").append(this.getStepName()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getTimeoutSeconds() != null) {
            sb.append("TimeoutSeconds: ").append(this.getTimeoutSeconds()).append(",");
        }
        if (this.getOnFailure() != null) {
            sb.append("OnFailure: ").append(this.getOnFailure()).append(",");
        }
        if (this.getMaxAttempts() != null) {
            sb.append("MaxAttempts: ").append(this.getMaxAttempts()).append(",");
        }
        if (this.getExecutionStartTime() != null) {
            sb.append("ExecutionStartTime: ").append(this.getExecutionStartTime()).append(",");
        }
        if (this.getExecutionEndTime() != null) {
            sb.append("ExecutionEndTime: ").append(this.getExecutionEndTime()).append(",");
        }
        if (this.getStepStatus() != null) {
            sb.append("StepStatus: ").append(this.getStepStatus()).append(",");
        }
        if (this.getResponseCode() != null) {
            sb.append("ResponseCode: ").append(this.getResponseCode()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getResponse() != null) {
            sb.append("Response: ").append(this.getResponse()).append(",");
        }
        if (this.getFailureMessage() != null) {
            sb.append("FailureMessage: ").append(this.getFailureMessage()).append(",");
        }
        if (this.getFailureDetails() != null) {
            sb.append("FailureDetails: ").append(this.getFailureDetails()).append(",");
        }
        if (this.getStepExecutionId() != null) {
            sb.append("StepExecutionId: ").append(this.getStepExecutionId()).append(",");
        }
        if (this.getOverriddenParameters() != null) {
            sb.append("OverriddenParameters: ").append(this.getOverriddenParameters()).append(",");
        }
        if (this.getIsEnd() != null) {
            sb.append("IsEnd: ").append(this.getIsEnd()).append(",");
        }
        if (this.getNextStep() != null) {
            sb.append("NextStep: ").append(this.getNextStep()).append(",");
        }
        if (this.getIsCritical() != null) {
            sb.append("IsCritical: ").append(this.getIsCritical()).append(",");
        }
        if (this.getValidNextSteps() != null) {
            sb.append("ValidNextSteps: ").append(this.getValidNextSteps()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTargetLocation() != null) {
            sb.append("TargetLocation: ").append(this.getTargetLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecution)) {
            return false;
        }
        StepExecution other = (StepExecution)obj;
        if (other.getStepName() == null ^ this.getStepName() == null) {
            return false;
        }
        if (other.getStepName() != null && !other.getStepName().equals(this.getStepName())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getTimeoutSeconds() == null ^ this.getTimeoutSeconds() == null) {
            return false;
        }
        if (other.getTimeoutSeconds() != null && !other.getTimeoutSeconds().equals(this.getTimeoutSeconds())) {
            return false;
        }
        if (other.getOnFailure() == null ^ this.getOnFailure() == null) {
            return false;
        }
        if (other.getOnFailure() != null && !other.getOnFailure().equals(this.getOnFailure())) {
            return false;
        }
        if (other.getMaxAttempts() == null ^ this.getMaxAttempts() == null) {
            return false;
        }
        if (other.getMaxAttempts() != null && !other.getMaxAttempts().equals(this.getMaxAttempts())) {
            return false;
        }
        if (other.getExecutionStartTime() == null ^ this.getExecutionStartTime() == null) {
            return false;
        }
        if (other.getExecutionStartTime() != null && !other.getExecutionStartTime().equals(this.getExecutionStartTime())) {
            return false;
        }
        if (other.getExecutionEndTime() == null ^ this.getExecutionEndTime() == null) {
            return false;
        }
        if (other.getExecutionEndTime() != null && !other.getExecutionEndTime().equals(this.getExecutionEndTime())) {
            return false;
        }
        if (other.getStepStatus() == null ^ this.getStepStatus() == null) {
            return false;
        }
        if (other.getStepStatus() != null && !other.getStepStatus().equals(this.getStepStatus())) {
            return false;
        }
        if (other.getResponseCode() == null ^ this.getResponseCode() == null) {
            return false;
        }
        if (other.getResponseCode() != null && !other.getResponseCode().equals(this.getResponseCode())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getResponse() == null ^ this.getResponse() == null) {
            return false;
        }
        if (other.getResponse() != null && !other.getResponse().equals(this.getResponse())) {
            return false;
        }
        if (other.getFailureMessage() == null ^ this.getFailureMessage() == null) {
            return false;
        }
        if (other.getFailureMessage() != null && !other.getFailureMessage().equals(this.getFailureMessage())) {
            return false;
        }
        if (other.getFailureDetails() == null ^ this.getFailureDetails() == null) {
            return false;
        }
        if (other.getFailureDetails() != null && !other.getFailureDetails().equals(this.getFailureDetails())) {
            return false;
        }
        if (other.getStepExecutionId() == null ^ this.getStepExecutionId() == null) {
            return false;
        }
        if (other.getStepExecutionId() != null && !other.getStepExecutionId().equals(this.getStepExecutionId())) {
            return false;
        }
        if (other.getOverriddenParameters() == null ^ this.getOverriddenParameters() == null) {
            return false;
        }
        if (other.getOverriddenParameters() != null && !other.getOverriddenParameters().equals(this.getOverriddenParameters())) {
            return false;
        }
        if (other.getIsEnd() == null ^ this.getIsEnd() == null) {
            return false;
        }
        if (other.getIsEnd() != null && !other.getIsEnd().equals(this.getIsEnd())) {
            return false;
        }
        if (other.getNextStep() == null ^ this.getNextStep() == null) {
            return false;
        }
        if (other.getNextStep() != null && !other.getNextStep().equals(this.getNextStep())) {
            return false;
        }
        if (other.getIsCritical() == null ^ this.getIsCritical() == null) {
            return false;
        }
        if (other.getIsCritical() != null && !other.getIsCritical().equals(this.getIsCritical())) {
            return false;
        }
        if (other.getValidNextSteps() == null ^ this.getValidNextSteps() == null) {
            return false;
        }
        if (other.getValidNextSteps() != null && !other.getValidNextSteps().equals(this.getValidNextSteps())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTargetLocation() == null ^ this.getTargetLocation() == null) {
            return false;
        }
        return other.getTargetLocation() == null || other.getTargetLocation().equals(this.getTargetLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStepName() == null ? 0 : this.getStepName().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutSeconds() == null ? 0 : this.getTimeoutSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getOnFailure() == null ? 0 : this.getOnFailure().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAttempts() == null ? 0 : this.getMaxAttempts().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStartTime() == null ? 0 : this.getExecutionStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionEndTime() == null ? 0 : this.getExecutionEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getStepStatus() == null ? 0 : this.getStepStatus().hashCode());
        hashCode = 31 * hashCode + (this.getResponseCode() == null ? 0 : this.getResponseCode().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getResponse() == null ? 0 : this.getResponse().hashCode());
        hashCode = 31 * hashCode + (this.getFailureMessage() == null ? 0 : this.getFailureMessage().hashCode());
        hashCode = 31 * hashCode + (this.getFailureDetails() == null ? 0 : this.getFailureDetails().hashCode());
        hashCode = 31 * hashCode + (this.getStepExecutionId() == null ? 0 : this.getStepExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.getOverriddenParameters() == null ? 0 : this.getOverriddenParameters().hashCode());
        hashCode = 31 * hashCode + (this.getIsEnd() == null ? 0 : this.getIsEnd().hashCode());
        hashCode = 31 * hashCode + (this.getNextStep() == null ? 0 : this.getNextStep().hashCode());
        hashCode = 31 * hashCode + (this.getIsCritical() == null ? 0 : this.getIsCritical().hashCode());
        hashCode = 31 * hashCode + (this.getValidNextSteps() == null ? 0 : this.getValidNextSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTargetLocation() == null ? 0 : this.getTargetLocation().hashCode());
        return hashCode;
    }

    public StepExecution clone() {
        try {
            return (StepExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

