/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.MaintenanceWindowResourceType;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.MaintenanceWindowTargetMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class MaintenanceWindowTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String windowId;
    private String windowTargetId;
    private String resourceType;
    private SdkInternalList<Target> targets;
    private String ownerInformation;

    public void setWindowId(String windowId) {
        this.windowId = windowId;
    }

    public String getWindowId() {
        return this.windowId;
    }

    public MaintenanceWindowTarget withWindowId(String windowId) {
        this.setWindowId(windowId);
        return this;
    }

    public void setWindowTargetId(String windowTargetId) {
        this.windowTargetId = windowTargetId;
    }

    public String getWindowTargetId() {
        return this.windowTargetId;
    }

    public MaintenanceWindowTarget withWindowTargetId(String windowTargetId) {
        this.setWindowTargetId(windowTargetId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public MaintenanceWindowTarget withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(MaintenanceWindowResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public MaintenanceWindowTarget withResourceType(MaintenanceWindowResourceType resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public MaintenanceWindowTarget withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public MaintenanceWindowTarget withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setOwnerInformation(String ownerInformation) {
        this.ownerInformation = ownerInformation;
    }

    public String getOwnerInformation() {
        return this.ownerInformation;
    }

    public MaintenanceWindowTarget withOwnerInformation(String ownerInformation) {
        this.setOwnerInformation(ownerInformation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWindowId() != null) {
            sb.append("WindowId: ").append(this.getWindowId()).append(",");
        }
        if (this.getWindowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.getWindowTargetId()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getOwnerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.getOwnerInformation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTarget)) {
            return false;
        }
        MaintenanceWindowTarget other = (MaintenanceWindowTarget)obj;
        if (other.getWindowId() == null ^ this.getWindowId() == null) {
            return false;
        }
        if (other.getWindowId() != null && !other.getWindowId().equals(this.getWindowId())) {
            return false;
        }
        if (other.getWindowTargetId() == null ^ this.getWindowTargetId() == null) {
            return false;
        }
        if (other.getWindowTargetId() != null && !other.getWindowTargetId().equals(this.getWindowTargetId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getOwnerInformation() == null ^ this.getOwnerInformation() == null) {
            return false;
        }
        return other.getOwnerInformation() == null || other.getOwnerInformation().equals(this.getOwnerInformation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWindowId() == null ? 0 : this.getWindowId().hashCode());
        hashCode = 31 * hashCode + (this.getWindowTargetId() == null ? 0 : this.getWindowTargetId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerInformation() == null ? 0 : this.getOwnerInformation().hashCode());
        return hashCode;
    }

    public MaintenanceWindowTarget clone() {
        try {
            return (MaintenanceWindowTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

