/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.snowdevicemanagement.model.CpuOptions;

@SdkInternalApi
public class CpuOptionsMarshaller {
    private static final MarshallingInfo<Integer> CORECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("coreCount").build();
    private static final MarshallingInfo<Integer> THREADSPERCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("threadsPerCore").build();
    private static final CpuOptionsMarshaller instance = new CpuOptionsMarshaller();

    public static CpuOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CpuOptions cpuOptions, ProtocolMarshaller protocolMarshaller) {
        if (cpuOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cpuOptions.getCoreCount(), CORECOUNT_BINDING);
            protocolMarshaller.marshall((Object)cpuOptions.getThreadsPerCore(), THREADSPERCORE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

