/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowdevicemanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowdevicemanagement.model.TaskState;
import com.amazonaws.services.snowdevicemanagement.model.transform.TaskSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TaskSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String state;
    private Map<String, String> tags;
    private String taskArn;
    private String taskId;

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public TaskSummary withState(String state) {
        this.setState(state);
        return this;
    }

    public TaskSummary withState(TaskState state) {
        this.state = state.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public TaskSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public TaskSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public TaskSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public TaskSummary withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskSummary withTaskId(String taskId) {
        this.setTaskId(taskId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getTaskId() != null) {
            sb.append("TaskId: ").append(this.getTaskId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskSummary)) {
            return false;
        }
        TaskSummary other = (TaskSummary)obj;
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        return other.getTaskId() == null || other.getTaskId().equals(this.getTaskId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        return hashCode;
    }

    public TaskSummary clone() {
        try {
            return (TaskSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

