/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.snowball.model.ShippingDetails;

@SdkInternalApi
public class ShippingDetailsMarshaller {
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").build();
    private static final MarshallingInfo<StructuredPojo> INBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboundShipment").build();
    private static final MarshallingInfo<StructuredPojo> OUTBOUNDSHIPMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutboundShipment").build();
    private static final ShippingDetailsMarshaller instance = new ShippingDetailsMarshaller();

    public static ShippingDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(ShippingDetails shippingDetails, ProtocolMarshaller protocolMarshaller) {
        if (shippingDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)shippingDetails.getShippingOption(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.getInboundShipment(), INBOUNDSHIPMENT_BINDING);
            protocolMarshaller.marshall((Object)shippingDetails.getOutboundShipment(), OUTBOUNDSHIPMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

