/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.shield.model.ProtectedResourceType;
import com.amazonaws.services.shield.model.ProtectionGroupAggregation;
import com.amazonaws.services.shield.model.ProtectionGroupPattern;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateProtectionGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String protectionGroupId;
    private String aggregation;
    private String pattern;
    private String resourceType;
    private List<String> members;

    public void setProtectionGroupId(String protectionGroupId) {
        this.protectionGroupId = protectionGroupId;
    }

    public String getProtectionGroupId() {
        return this.protectionGroupId;
    }

    public UpdateProtectionGroupRequest withProtectionGroupId(String protectionGroupId) {
        this.setProtectionGroupId(protectionGroupId);
        return this;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public UpdateProtectionGroupRequest withAggregation(String aggregation) {
        this.setAggregation(aggregation);
        return this;
    }

    public UpdateProtectionGroupRequest withAggregation(ProtectionGroupAggregation aggregation) {
        this.aggregation = aggregation.toString();
        return this;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public UpdateProtectionGroupRequest withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public UpdateProtectionGroupRequest withPattern(ProtectionGroupPattern pattern) {
        this.pattern = pattern.toString();
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public UpdateProtectionGroupRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public UpdateProtectionGroupRequest withResourceType(ProtectedResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<String> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<String>(members);
    }

    public UpdateProtectionGroupRequest withMembers(String ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<String>(members.length));
        }
        for (String ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public UpdateProtectionGroupRequest withMembers(Collection<String> members) {
        this.setMembers(members);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtectionGroupId() != null) {
            sb.append("ProtectionGroupId: ").append(this.getProtectionGroupId()).append(",");
        }
        if (this.getAggregation() != null) {
            sb.append("Aggregation: ").append(this.getAggregation()).append(",");
        }
        if (this.getPattern() != null) {
            sb.append("Pattern: ").append(this.getPattern()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProtectionGroupRequest)) {
            return false;
        }
        UpdateProtectionGroupRequest other = (UpdateProtectionGroupRequest)obj;
        if (other.getProtectionGroupId() == null ^ this.getProtectionGroupId() == null) {
            return false;
        }
        if (other.getProtectionGroupId() != null && !other.getProtectionGroupId().equals(this.getProtectionGroupId())) {
            return false;
        }
        if (other.getAggregation() == null ^ this.getAggregation() == null) {
            return false;
        }
        if (other.getAggregation() != null && !other.getAggregation().equals(this.getAggregation())) {
            return false;
        }
        if (other.getPattern() == null ^ this.getPattern() == null) {
            return false;
        }
        if (other.getPattern() != null && !other.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        return other.getMembers() == null || other.getMembers().equals(this.getMembers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtectionGroupId() == null ? 0 : this.getProtectionGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getAggregation() == null ? 0 : this.getAggregation().hashCode());
        hashCode = 31 * hashCode + (this.getPattern() == null ? 0 : this.getPattern().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        return hashCode;
    }

    public UpdateProtectionGroupRequest clone() {
        return (UpdateProtectionGroupRequest)super.clone();
    }
}

