/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.servicecatalog.model.LaunchPathSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLaunchPathsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LaunchPathSummary> launchPathSummaries;
    private String nextPageToken;

    public List<LaunchPathSummary> getLaunchPathSummaries() {
        return this.launchPathSummaries;
    }

    public void setLaunchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
        if (launchPathSummaries == null) {
            this.launchPathSummaries = null;
            return;
        }
        this.launchPathSummaries = new ArrayList<LaunchPathSummary>(launchPathSummaries);
    }

    public ListLaunchPathsResult withLaunchPathSummaries(LaunchPathSummary ... launchPathSummaries) {
        if (this.launchPathSummaries == null) {
            this.setLaunchPathSummaries(new ArrayList<LaunchPathSummary>(launchPathSummaries.length));
        }
        for (LaunchPathSummary ele : launchPathSummaries) {
            this.launchPathSummaries.add(ele);
        }
        return this;
    }

    public ListLaunchPathsResult withLaunchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
        this.setLaunchPathSummaries(launchPathSummaries);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public ListLaunchPathsResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLaunchPathSummaries() != null) {
            sb.append("LaunchPathSummaries: ").append(this.getLaunchPathSummaries()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchPathsResult)) {
            return false;
        }
        ListLaunchPathsResult other = (ListLaunchPathsResult)obj;
        if (other.getLaunchPathSummaries() == null ^ this.getLaunchPathSummaries() == null) {
            return false;
        }
        if (other.getLaunchPathSummaries() != null && !other.getLaunchPathSummaries().equals(this.getLaunchPathSummaries())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLaunchPathSummaries() == null ? 0 : this.getLaunchPathSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public ListLaunchPathsResult clone() {
        try {
            return (ListLaunchPathsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

