/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.ParameterValue;
import java.util.List;

@SdkInternalApi
public class ParameterValueMarshaller {
    private static final MarshallingInfo<Integer> INTEGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Integer").build();
    private static final MarshallingInfo<List> INTEGERLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerList").build();
    private static final MarshallingInfo<Double> DOUBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Double").build();
    private static final MarshallingInfo<String> STRING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("String").build();
    private static final MarshallingInfo<List> STRINGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringList").build();
    private static final MarshallingInfo<Boolean> BOOLEAN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Boolean").build();
    private static final MarshallingInfo<String> ENUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enum").build();
    private static final MarshallingInfo<List> ENUMLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnumList").build();
    private static final ParameterValueMarshaller instance = new ParameterValueMarshaller();

    public static ParameterValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParameterValue parameterValue, ProtocolMarshaller protocolMarshaller) {
        if (parameterValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)parameterValue.getInteger(), INTEGER_BINDING);
            protocolMarshaller.marshall(parameterValue.getIntegerList(), INTEGERLIST_BINDING);
            protocolMarshaller.marshall((Object)parameterValue.getDouble(), DOUBLE_BINDING);
            protocolMarshaller.marshall((Object)parameterValue.getString(), STRING_BINDING);
            protocolMarshaller.marshall(parameterValue.getStringList(), STRINGLIST_BINDING);
            protocolMarshaller.marshall((Object)parameterValue.getBoolean(), BOOLEAN_BINDING);
            protocolMarshaller.marshall((Object)parameterValue.getEnum(), ENUM_BINDING);
            protocolMarshaller.marshall(parameterValue.getEnumList(), ENUMLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

