/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Network;

@SdkInternalApi
public class NetworkMarshaller {
    private static final MarshallingInfo<String> DIRECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Direction").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Protocol").build();
    private static final MarshallingInfo<StructuredPojo> OPENPORTRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OpenPortRange").build();
    private static final MarshallingInfo<String> SOURCEIPV4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIpV4").build();
    private static final MarshallingInfo<String> SOURCEIPV6_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceIpV6").build();
    private static final MarshallingInfo<Integer> SOURCEPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourcePort").build();
    private static final MarshallingInfo<String> SOURCEDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceDomain").build();
    private static final MarshallingInfo<String> SOURCEMAC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceMac").build();
    private static final MarshallingInfo<String> DESTINATIONIPV4_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationIpV4").build();
    private static final MarshallingInfo<String> DESTINATIONIPV6_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationIpV6").build();
    private static final MarshallingInfo<Integer> DESTINATIONPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationPort").build();
    private static final MarshallingInfo<String> DESTINATIONDOMAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationDomain").build();
    private static final NetworkMarshaller instance = new NetworkMarshaller();

    public static NetworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(Network network, ProtocolMarshaller protocolMarshaller) {
        if (network == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)network.getDirection(), DIRECTION_BINDING);
            protocolMarshaller.marshall((Object)network.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)network.getOpenPortRange(), OPENPORTRANGE_BINDING);
            protocolMarshaller.marshall((Object)network.getSourceIpV4(), SOURCEIPV4_BINDING);
            protocolMarshaller.marshall((Object)network.getSourceIpV6(), SOURCEIPV6_BINDING);
            protocolMarshaller.marshall((Object)network.getSourcePort(), SOURCEPORT_BINDING);
            protocolMarshaller.marshall((Object)network.getSourceDomain(), SOURCEDOMAIN_BINDING);
            protocolMarshaller.marshall((Object)network.getSourceMac(), SOURCEMAC_BINDING);
            protocolMarshaller.marshall((Object)network.getDestinationIpV4(), DESTINATIONIPV4_BINDING);
            protocolMarshaller.marshall((Object)network.getDestinationIpV6(), DESTINATIONIPV6_BINDING);
            protocolMarshaller.marshall((Object)network.getDestinationPort(), DESTINATIONPORT_BINDING);
            protocolMarshaller.marshall((Object)network.getDestinationDomain(), DESTINATIONDOMAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

