/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.Invitation;
import java.util.Date;

@SdkInternalApi
public class InvitationMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> INVITATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvitationId").build();
    private static final MarshallingInfo<Date> INVITEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvitedAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> MEMBERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemberStatus").build();
    private static final InvitationMarshaller instance = new InvitationMarshaller();

    public static InvitationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Invitation invitation, ProtocolMarshaller protocolMarshaller) {
        if (invitation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)invitation.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)invitation.getInvitationId(), INVITATIONID_BINDING);
            protocolMarshaller.marshall((Object)invitation.getInvitedAt(), INVITEDAT_BINDING);
            protocolMarshaller.marshall((Object)invitation.getMemberStatus(), MEMBERSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

