/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.transform.EnumListConfigurationOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumListConfigurationOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> defaultValue;
    private Integer maxItems;
    private List<String> allowedValues;

    public List<String> getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Collection<String> defaultValue) {
        if (defaultValue == null) {
            this.defaultValue = null;
            return;
        }
        this.defaultValue = new ArrayList<String>(defaultValue);
    }

    public EnumListConfigurationOptions withDefaultValue(String ... defaultValue) {
        if (this.defaultValue == null) {
            this.setDefaultValue(new ArrayList<String>(defaultValue.length));
        }
        for (String ele : defaultValue) {
            this.defaultValue.add(ele);
        }
        return this;
    }

    public EnumListConfigurationOptions withDefaultValue(Collection<String> defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public EnumListConfigurationOptions withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<String>(allowedValues);
    }

    public EnumListConfigurationOptions withAllowedValues(String ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<String>(allowedValues.length));
        }
        for (String ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public EnumListConfigurationOptions withAllowedValues(Collection<String> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumListConfigurationOptions)) {
            return false;
        }
        EnumListConfigurationOptions other = (EnumListConfigurationOptions)obj;
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        return other.getAllowedValues() == null || other.getAllowedValues().equals(this.getAllowedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        return hashCode;
    }

    public EnumListConfigurationOptions clone() {
        try {
            return (EnumListConfigurationOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnumListConfigurationOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

