/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutSecretValueRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String secretId;
    private String clientRequestToken;
    private ByteBuffer secretBinary;
    private String secretString;
    private List<String> versionStages;
    private String rotationToken;

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public PutSecretValueRequest withSecretId(String secretId) {
        this.setSecretId(secretId);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public PutSecretValueRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setSecretBinary(ByteBuffer secretBinary) {
        this.secretBinary = secretBinary;
    }

    public ByteBuffer getSecretBinary() {
        return this.secretBinary;
    }

    public PutSecretValueRequest withSecretBinary(ByteBuffer secretBinary) {
        this.setSecretBinary(secretBinary);
        return this;
    }

    public void setSecretString(String secretString) {
        this.secretString = secretString;
    }

    public String getSecretString() {
        return this.secretString;
    }

    public PutSecretValueRequest withSecretString(String secretString) {
        this.setSecretString(secretString);
        return this;
    }

    public List<String> getVersionStages() {
        return this.versionStages;
    }

    public void setVersionStages(Collection<String> versionStages) {
        if (versionStages == null) {
            this.versionStages = null;
            return;
        }
        this.versionStages = new ArrayList<String>(versionStages);
    }

    public PutSecretValueRequest withVersionStages(String ... versionStages) {
        if (this.versionStages == null) {
            this.setVersionStages(new ArrayList<String>(versionStages.length));
        }
        for (String ele : versionStages) {
            this.versionStages.add(ele);
        }
        return this;
    }

    public PutSecretValueRequest withVersionStages(Collection<String> versionStages) {
        this.setVersionStages(versionStages);
        return this;
    }

    public void setRotationToken(String rotationToken) {
        this.rotationToken = rotationToken;
    }

    public String getRotationToken() {
        return this.rotationToken;
    }

    public PutSecretValueRequest withRotationToken(String rotationToken) {
        this.setRotationToken(rotationToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecretId() != null) {
            sb.append("SecretId: ").append(this.getSecretId()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getSecretBinary() != null) {
            sb.append("SecretBinary: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSecretString() != null) {
            sb.append("SecretString: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getVersionStages() != null) {
            sb.append("VersionStages: ").append(this.getVersionStages()).append(",");
        }
        if (this.getRotationToken() != null) {
            sb.append("RotationToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSecretValueRequest)) {
            return false;
        }
        PutSecretValueRequest other = (PutSecretValueRequest)obj;
        if (other.getSecretId() == null ^ this.getSecretId() == null) {
            return false;
        }
        if (other.getSecretId() != null && !other.getSecretId().equals(this.getSecretId())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getSecretBinary() == null ^ this.getSecretBinary() == null) {
            return false;
        }
        if (other.getSecretBinary() != null && !other.getSecretBinary().equals(this.getSecretBinary())) {
            return false;
        }
        if (other.getSecretString() == null ^ this.getSecretString() == null) {
            return false;
        }
        if (other.getSecretString() != null && !other.getSecretString().equals(this.getSecretString())) {
            return false;
        }
        if (other.getVersionStages() == null ^ this.getVersionStages() == null) {
            return false;
        }
        if (other.getVersionStages() != null && !other.getVersionStages().equals(this.getVersionStages())) {
            return false;
        }
        if (other.getRotationToken() == null ^ this.getRotationToken() == null) {
            return false;
        }
        return other.getRotationToken() == null || other.getRotationToken().equals(this.getRotationToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecretId() == null ? 0 : this.getSecretId().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getSecretBinary() == null ? 0 : this.getSecretBinary().hashCode());
        hashCode = 31 * hashCode + (this.getSecretString() == null ? 0 : this.getSecretString().hashCode());
        hashCode = 31 * hashCode + (this.getVersionStages() == null ? 0 : this.getVersionStages().hashCode());
        hashCode = 31 * hashCode + (this.getRotationToken() == null ? 0 : this.getRotationToken().hashCode());
        return hashCode;
    }

    public PutSecretValueRequest clone() {
        return (PutSecretValueRequest)super.clone();
    }
}

