/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.AlgorithmNameCloudRemoval;
import com.amazonaws.services.sagemakergeospatial.model.transform.CloudRemovalConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CloudRemovalConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithmName;
    private String interpolationValue;
    private List<String> targetBands;

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public CloudRemovalConfigInput withAlgorithmName(String algorithmName) {
        this.setAlgorithmName(algorithmName);
        return this;
    }

    public CloudRemovalConfigInput withAlgorithmName(AlgorithmNameCloudRemoval algorithmName) {
        this.algorithmName = algorithmName.toString();
        return this;
    }

    public void setInterpolationValue(String interpolationValue) {
        this.interpolationValue = interpolationValue;
    }

    public String getInterpolationValue() {
        return this.interpolationValue;
    }

    public CloudRemovalConfigInput withInterpolationValue(String interpolationValue) {
        this.setInterpolationValue(interpolationValue);
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public CloudRemovalConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public CloudRemovalConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmName() != null) {
            sb.append("AlgorithmName: ").append(this.getAlgorithmName()).append(",");
        }
        if (this.getInterpolationValue() != null) {
            sb.append("InterpolationValue: ").append(this.getInterpolationValue()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudRemovalConfigInput)) {
            return false;
        }
        CloudRemovalConfigInput other = (CloudRemovalConfigInput)obj;
        if (other.getAlgorithmName() == null ^ this.getAlgorithmName() == null) {
            return false;
        }
        if (other.getAlgorithmName() != null && !other.getAlgorithmName().equals(this.getAlgorithmName())) {
            return false;
        }
        if (other.getInterpolationValue() == null ^ this.getInterpolationValue() == null) {
            return false;
        }
        if (other.getInterpolationValue() != null && !other.getInterpolationValue().equals(this.getInterpolationValue())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        return other.getTargetBands() == null || other.getTargetBands().equals(this.getTargetBands());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmName() == null ? 0 : this.getAlgorithmName().hashCode());
        hashCode = 31 * hashCode + (this.getInterpolationValue() == null ? 0 : this.getInterpolationValue().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        return hashCode;
    }

    public CloudRemovalConfigInput clone() {
        try {
            return (CloudRemovalConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudRemovalConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

