/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ModelCardSecurityConfig;
import com.amazonaws.services.sagemaker.model.ModelCardStatus;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateModelCardRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelCardName;
    private ModelCardSecurityConfig securityConfig;
    private String content;
    private String modelCardStatus;
    private List<Tag> tags;

    public void setModelCardName(String modelCardName) {
        this.modelCardName = modelCardName;
    }

    public String getModelCardName() {
        return this.modelCardName;
    }

    public CreateModelCardRequest withModelCardName(String modelCardName) {
        this.setModelCardName(modelCardName);
        return this;
    }

    public void setSecurityConfig(ModelCardSecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public ModelCardSecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public CreateModelCardRequest withSecurityConfig(ModelCardSecurityConfig securityConfig) {
        this.setSecurityConfig(securityConfig);
        return this;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public CreateModelCardRequest withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setModelCardStatus(String modelCardStatus) {
        this.modelCardStatus = modelCardStatus;
    }

    public String getModelCardStatus() {
        return this.modelCardStatus;
    }

    public CreateModelCardRequest withModelCardStatus(String modelCardStatus) {
        this.setModelCardStatus(modelCardStatus);
        return this;
    }

    public CreateModelCardRequest withModelCardStatus(ModelCardStatus modelCardStatus) {
        this.modelCardStatus = modelCardStatus.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateModelCardRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateModelCardRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelCardName() != null) {
            sb.append("ModelCardName: ").append(this.getModelCardName()).append(",");
        }
        if (this.getSecurityConfig() != null) {
            sb.append("SecurityConfig: ").append(this.getSecurityConfig()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getModelCardStatus() != null) {
            sb.append("ModelCardStatus: ").append(this.getModelCardStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCardRequest)) {
            return false;
        }
        CreateModelCardRequest other = (CreateModelCardRequest)obj;
        if (other.getModelCardName() == null ^ this.getModelCardName() == null) {
            return false;
        }
        if (other.getModelCardName() != null && !other.getModelCardName().equals(this.getModelCardName())) {
            return false;
        }
        if (other.getSecurityConfig() == null ^ this.getSecurityConfig() == null) {
            return false;
        }
        if (other.getSecurityConfig() != null && !other.getSecurityConfig().equals(this.getSecurityConfig())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getModelCardStatus() == null ^ this.getModelCardStatus() == null) {
            return false;
        }
        if (other.getModelCardStatus() != null && !other.getModelCardStatus().equals(this.getModelCardStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelCardName() == null ? 0 : this.getModelCardName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityConfig() == null ? 0 : this.getSecurityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getModelCardStatus() == null ? 0 : this.getModelCardStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateModelCardRequest clone() {
        return (CreateModelCardRequest)super.clone();
    }
}

