/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Transition;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class TransitionStaxUnmarshaller
implements Unmarshaller<Transition, StaxUnmarshallerContext> {
    private static TransitionStaxUnmarshaller instance;

    public Transition unmarshall(StaxUnmarshallerContext context) throws Exception {
        Transition transition = new Transition();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return transition;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Date", targetDepth)) {
                    transition.setDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Days", targetDepth)) {
                    transition.setDays(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("StorageClass", targetDepth)) continue;
                transition.setStorageClass(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return transition;
    }

    public static TransitionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TransitionStaxUnmarshaller();
        }
        return instance;
    }
}

